/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.time.internal.properties.configurators;

import java.time.LocalDateTime;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.configurators.ArbitraryConfiguratorBase;
import net.jqwik.api.providers.TypeUsage;
import net.jqwik.time.api.arbitraries.LocalDateTimeArbitrary;
import net.jqwik.time.api.constraints.DateTimeRange;

public class DateTimeRangeConfigurator
extends ArbitraryConfiguratorBase {
    protected boolean acceptTargetType(TypeUsage targetType) {
        return targetType.isAssignableFrom(LocalDateTime.class);
    }

    public Arbitrary<LocalDateTime> configure(Arbitrary<LocalDateTime> arbitrary, DateTimeRange range) {
        LocalDateTime min = DateTimeRangeConfigurator.stringToLocalDateTime(range.min());
        LocalDateTime max = DateTimeRangeConfigurator.stringToLocalDateTime(range.max());
        if (arbitrary instanceof LocalDateTimeArbitrary) {
            LocalDateTimeArbitrary localDateTimeArbitrary = (LocalDateTimeArbitrary)arbitrary;
            return localDateTimeArbitrary.between(min, max);
        }
        return arbitrary.filter(v -> DateTimeRangeConfigurator.filter(v, min, max));
    }

    private static LocalDateTime stringToLocalDateTime(String dateTime) {
        return LocalDateTime.parse(dateTime);
    }

    private static boolean filter(LocalDateTime dateTime, LocalDateTime min, LocalDateTime max) {
        return !dateTime.isBefore(min) && !dateTime.isAfter(max);
    }
}

