/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.time.internal.properties.configurators;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.configurators.ArbitraryConfiguratorBase;
import net.jqwik.api.providers.TypeUsage;
import net.jqwik.time.api.arbitraries.CalendarArbitrary;
import net.jqwik.time.api.arbitraries.DateArbitrary;
import net.jqwik.time.api.arbitraries.LocalDateArbitrary;
import net.jqwik.time.api.constraints.DayOfWeekRange;
import net.jqwik.time.internal.properties.arbitraries.DefaultCalendarArbitrary;

public class DayOfWeekRangeConfigurator {
    private static DayOfWeek[] createDayOfWeekArray(DayOfWeekRange range) {
        ArrayList<DayOfWeek> dayOfWeeks = new ArrayList<DayOfWeek>();
        for (int i = range.min().getValue(); i <= range.max().getValue(); ++i) {
            dayOfWeeks.add(DayOfWeek.of(i));
        }
        return dayOfWeeks.toArray(new DayOfWeek[0]);
    }

    private static boolean filter(DayOfWeek dayOfWeek, DayOfWeek[] dayOfWeeks) {
        for (DayOfWeek dow : dayOfWeeks) {
            if (dayOfWeek != dow) continue;
            return true;
        }
        return false;
    }

    private static boolean filter(LocalDate date, DayOfWeek[] dayOfWeeks) {
        return DayOfWeekRangeConfigurator.filter(date.getDayOfWeek(), dayOfWeeks);
    }

    private static boolean filter(Calendar date, DayOfWeek[] dayOfWeeks) {
        DayOfWeek dayOfWeek = DefaultCalendarArbitrary.calendarDayOfWeekToDayOfWeek(date.get(7));
        return DayOfWeekRangeConfigurator.filter(dayOfWeek, dayOfWeeks);
    }

    private static boolean filter(Date date, DayOfWeek[] dayOfWeeks) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return DayOfWeekRangeConfigurator.filter(calendar, dayOfWeeks);
    }

    public static class ForDate
    extends ArbitraryConfiguratorBase {
        protected boolean acceptTargetType(TypeUsage targetType) {
            return targetType.isAssignableFrom(Date.class);
        }

        public Arbitrary<Date> configure(Arbitrary<Date> arbitrary, DayOfWeekRange range) {
            DayOfWeek[] dayOfWeeks = DayOfWeekRangeConfigurator.createDayOfWeekArray(range);
            if (arbitrary instanceof DateArbitrary) {
                DateArbitrary dateArbitrary = (DateArbitrary)arbitrary;
                return dateArbitrary.onlyDaysOfWeek(dayOfWeeks);
            }
            return arbitrary.filter(v -> DayOfWeekRangeConfigurator.filter(v, dayOfWeeks));
        }
    }

    public static class ForCalendar
    extends ArbitraryConfiguratorBase {
        protected boolean acceptTargetType(TypeUsage targetType) {
            return targetType.isAssignableFrom(Calendar.class);
        }

        public Arbitrary<Calendar> configure(Arbitrary<Calendar> arbitrary, DayOfWeekRange range) {
            DayOfWeek[] dayOfWeeks = DayOfWeekRangeConfigurator.createDayOfWeekArray(range);
            if (arbitrary instanceof CalendarArbitrary) {
                CalendarArbitrary calendarArbitrary = (CalendarArbitrary)arbitrary;
                return calendarArbitrary.onlyDaysOfWeek(dayOfWeeks);
            }
            return arbitrary.filter(v -> DayOfWeekRangeConfigurator.filter(v, dayOfWeeks));
        }
    }

    public static class ForLocalDate
    extends ArbitraryConfiguratorBase {
        protected boolean acceptTargetType(TypeUsage targetType) {
            return targetType.isAssignableFrom(LocalDate.class);
        }

        public Arbitrary<LocalDate> configure(Arbitrary<LocalDate> arbitrary, DayOfWeekRange range) {
            DayOfWeek[] dayOfWeeks = DayOfWeekRangeConfigurator.createDayOfWeekArray(range);
            if (arbitrary instanceof LocalDateArbitrary) {
                LocalDateArbitrary localDateArbitrary = (LocalDateArbitrary)arbitrary;
                return localDateArbitrary.onlyDaysOfWeek(dayOfWeeks);
            }
            return arbitrary.filter(v -> DayOfWeekRangeConfigurator.filter(v, dayOfWeeks));
        }
    }
}

