/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.time.internal.properties.configurators;

import java.time.LocalTime;
import java.time.OffsetTime;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.configurators.ArbitraryConfiguratorBase;
import net.jqwik.api.providers.TypeUsage;
import net.jqwik.time.api.arbitraries.LocalTimeArbitrary;
import net.jqwik.time.api.arbitraries.OffsetTimeArbitrary;
import net.jqwik.time.api.constraints.HourRange;

public class HourRangeConfigurator {
    private static boolean filter(LocalTime time, int min, int max) {
        return time.getHour() >= min && time.getHour() <= max;
    }

    private static boolean filter(OffsetTime offsetTime, int min, int max) {
        LocalTime time = offsetTime.toLocalTime();
        return HourRangeConfigurator.filter(time, min, max);
    }

    public static class ForOffsetTime
    extends ArbitraryConfiguratorBase {
        protected boolean acceptTargetType(TypeUsage targetType) {
            return targetType.isAssignableFrom(OffsetTime.class);
        }

        public Arbitrary<OffsetTime> configure(Arbitrary<OffsetTime> arbitrary, HourRange range) {
            int min = range.min();
            int max = range.max();
            if (arbitrary instanceof OffsetTimeArbitrary) {
                OffsetTimeArbitrary offsetTimeArbitrary = (OffsetTimeArbitrary)arbitrary;
                return offsetTimeArbitrary.hourBetween(min, max);
            }
            return arbitrary.filter(v -> HourRangeConfigurator.filter(v, min, max));
        }
    }

    public static class ForLocalTime
    extends ArbitraryConfiguratorBase {
        protected boolean acceptTargetType(TypeUsage targetType) {
            return targetType.isAssignableFrom(LocalTime.class);
        }

        public Arbitrary<LocalTime> configure(Arbitrary<LocalTime> arbitrary, HourRange range) {
            int min = range.min();
            int max = range.max();
            if (arbitrary instanceof LocalTimeArbitrary) {
                LocalTimeArbitrary localTimeArbitrary = (LocalTimeArbitrary)arbitrary;
                return localTimeArbitrary.hourBetween(min, max);
            }
            return arbitrary.filter(v -> HourRangeConfigurator.filter(v, min, max));
        }
    }
}

