/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.time.internal.properties.configurators;

import java.time.LocalDate;
import java.time.YearMonth;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.configurators.ArbitraryConfiguratorBase;
import net.jqwik.api.providers.TypeUsage;
import net.jqwik.time.api.arbitraries.CalendarArbitrary;
import net.jqwik.time.api.arbitraries.DateArbitrary;
import net.jqwik.time.api.arbitraries.LocalDateArbitrary;
import net.jqwik.time.api.arbitraries.YearMonthArbitrary;
import net.jqwik.time.api.constraints.LeapYears;

public class LeapYearsConfigurator {
    private static boolean filter(int year, boolean withLeapYears) {
        return withLeapYears || !new GregorianCalendar().isLeapYear(year);
    }

    private static boolean filter(LocalDate date, boolean withLeapYears) {
        return LeapYearsConfigurator.filter(date.getYear(), withLeapYears);
    }

    private static boolean filter(Calendar date, boolean withLeapYears) {
        int year = date.get(1);
        if (date.get(0) == 0) {
            year = -year;
        }
        return LeapYearsConfigurator.filter(year, withLeapYears);
    }

    private static boolean filter(Date date, boolean withLeapYears) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return LeapYearsConfigurator.filter(calendar, withLeapYears);
    }

    private static boolean filter(YearMonth yearMonth, boolean withLeapYears) {
        return LeapYearsConfigurator.filter(yearMonth.getYear(), withLeapYears);
    }

    public static class ForYearMonth
    extends ArbitraryConfiguratorBase {
        protected boolean acceptTargetType(TypeUsage targetType) {
            return targetType.isAssignableFrom(YearMonth.class);
        }

        public Arbitrary<YearMonth> configure(Arbitrary<YearMonth> arbitrary, LeapYears leapYears) {
            boolean withLeapYears = leapYears.withLeapYears();
            if (arbitrary instanceof YearMonthArbitrary) {
                YearMonthArbitrary yearMonthArbitrary = (YearMonthArbitrary)arbitrary;
                return yearMonthArbitrary.leapYears(leapYears.withLeapYears());
            }
            return arbitrary.filter(v -> LeapYearsConfigurator.filter(v, withLeapYears));
        }
    }

    public static class ForDate
    extends ArbitraryConfiguratorBase {
        protected boolean acceptTargetType(TypeUsage targetType) {
            return targetType.isAssignableFrom(Date.class);
        }

        public Arbitrary<Date> configure(Arbitrary<Date> arbitrary, LeapYears leapYears) {
            boolean withLeapYears = leapYears.withLeapYears();
            if (arbitrary instanceof DateArbitrary) {
                DateArbitrary dateArbitrary = (DateArbitrary)arbitrary;
                return dateArbitrary.leapYears(withLeapYears);
            }
            return arbitrary.filter(v -> LeapYearsConfigurator.filter(v, withLeapYears));
        }
    }

    public static class ForCalendar
    extends ArbitraryConfiguratorBase {
        protected boolean acceptTargetType(TypeUsage targetType) {
            return targetType.isAssignableFrom(Calendar.class);
        }

        public Arbitrary<Calendar> configure(Arbitrary<Calendar> arbitrary, LeapYears leapYears) {
            boolean withLeapYears = leapYears.withLeapYears();
            if (arbitrary instanceof CalendarArbitrary) {
                CalendarArbitrary calendarArbitrary = (CalendarArbitrary)arbitrary;
                return calendarArbitrary.leapYears(withLeapYears);
            }
            return arbitrary.filter(v -> LeapYearsConfigurator.filter(v, withLeapYears));
        }
    }

    public static class ForLocalDate
    extends ArbitraryConfiguratorBase {
        protected boolean acceptTargetType(TypeUsage targetType) {
            return targetType.isAssignableFrom(LocalDate.class);
        }

        public Arbitrary<LocalDate> configure(Arbitrary<LocalDate> arbitrary, LeapYears leapYears) {
            boolean withLeapYears = leapYears.withLeapYears();
            if (arbitrary instanceof LocalDateArbitrary) {
                LocalDateArbitrary localDateArbitrary = (LocalDateArbitrary)arbitrary;
                return localDateArbitrary.leapYears(withLeapYears);
            }
            return arbitrary.filter(v -> LeapYearsConfigurator.filter(v, withLeapYears));
        }
    }
}

