/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.time.internal.properties.configurators;

import java.time.LocalDate;
import java.time.Month;
import java.time.MonthDay;
import java.time.YearMonth;
import java.util.Calendar;
import java.util.Date;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.configurators.ArbitraryConfiguratorBase;
import net.jqwik.api.providers.TypeUsage;
import net.jqwik.time.api.arbitraries.CalendarArbitrary;
import net.jqwik.time.api.arbitraries.DateArbitrary;
import net.jqwik.time.api.arbitraries.LocalDateArbitrary;
import net.jqwik.time.api.arbitraries.MonthDayArbitrary;
import net.jqwik.time.api.arbitraries.YearMonthArbitrary;
import net.jqwik.time.api.constraints.MonthRange;
import net.jqwik.time.internal.properties.arbitraries.DefaultCalendarArbitrary;

public class MonthRangeConfigurator {
    private static boolean filter(Month month, Month min, Month max) {
        return month.compareTo(min) >= 0 && month.compareTo(max) <= 0;
    }

    private static boolean filter(LocalDate date, Month min, Month max) {
        return MonthRangeConfigurator.filter(date.getMonth(), min, max);
    }

    private static boolean filter(Calendar date, Month min, Month max) {
        Month month = DefaultCalendarArbitrary.calendarMonthToMonth(date);
        return MonthRangeConfigurator.filter(month, min, max);
    }

    private static boolean filter(Date date, Month min, Month max) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return MonthRangeConfigurator.filter(calendar, min, max);
    }

    private static boolean filter(YearMonth yearMonth, Month min, Month max) {
        return MonthRangeConfigurator.filter(yearMonth.getMonth(), min, max);
    }

    private static boolean filter(MonthDay monthDay, Month min, Month max) {
        return MonthRangeConfigurator.filter(monthDay.getMonth(), min, max);
    }

    public static class ForMonthDay
    extends ArbitraryConfiguratorBase {
        protected boolean acceptTargetType(TypeUsage targetType) {
            return targetType.isAssignableFrom(MonthDay.class);
        }

        public Arbitrary<MonthDay> configure(Arbitrary<MonthDay> arbitrary, MonthRange range) {
            Month min = range.min();
            Month max = range.max();
            if (arbitrary instanceof MonthDayArbitrary) {
                MonthDayArbitrary monthDayArbitrary = (MonthDayArbitrary)arbitrary;
                return monthDayArbitrary.monthBetween(min, max);
            }
            return arbitrary.filter(v -> MonthRangeConfigurator.filter(v, min, max));
        }
    }

    public static class ForYearMonth
    extends ArbitraryConfiguratorBase {
        protected boolean acceptTargetType(TypeUsage targetType) {
            return targetType.isAssignableFrom(YearMonth.class);
        }

        public Arbitrary<YearMonth> configure(Arbitrary<YearMonth> arbitrary, MonthRange range) {
            Month min = range.min();
            Month max = range.max();
            if (arbitrary instanceof YearMonthArbitrary) {
                YearMonthArbitrary yearMonthArbitrary = (YearMonthArbitrary)arbitrary;
                return yearMonthArbitrary.monthBetween(min, max);
            }
            return arbitrary.filter(v -> MonthRangeConfigurator.filter(v, min, max));
        }
    }

    public static class ForDate
    extends ArbitraryConfiguratorBase {
        protected boolean acceptTargetType(TypeUsage targetType) {
            return targetType.isAssignableFrom(Date.class);
        }

        public Arbitrary<Date> configure(Arbitrary<Date> arbitrary, MonthRange range) {
            Month min = range.min();
            Month max = range.max();
            if (arbitrary instanceof DateArbitrary) {
                DateArbitrary dateArbitrary = (DateArbitrary)arbitrary;
                return dateArbitrary.monthBetween(min, max);
            }
            return arbitrary.filter(v -> MonthRangeConfigurator.filter(v, min, max));
        }
    }

    public static class ForCalendar
    extends ArbitraryConfiguratorBase {
        protected boolean acceptTargetType(TypeUsage targetType) {
            return targetType.isAssignableFrom(Calendar.class);
        }

        public Arbitrary<Calendar> configure(Arbitrary<Calendar> arbitrary, MonthRange range) {
            Month min = range.min();
            Month max = range.max();
            if (arbitrary instanceof CalendarArbitrary) {
                CalendarArbitrary calendarArbitrary = (CalendarArbitrary)arbitrary;
                return calendarArbitrary.monthBetween(min, max);
            }
            return arbitrary.filter(v -> MonthRangeConfigurator.filter(v, min, max));
        }
    }

    public static class ForLocalDate
    extends ArbitraryConfiguratorBase {
        protected boolean acceptTargetType(TypeUsage targetType) {
            return targetType.isAssignableFrom(LocalDate.class);
        }

        public Arbitrary<LocalDate> configure(Arbitrary<LocalDate> arbitrary, MonthRange range) {
            Month min = range.min();
            Month max = range.max();
            if (arbitrary instanceof LocalDateArbitrary) {
                LocalDateArbitrary localDateArbitrary = (LocalDateArbitrary)arbitrary;
                return localDateArbitrary.monthBetween(min, max);
            }
            return arbitrary.filter(v -> MonthRangeConfigurator.filter(v, min, max));
        }
    }
}

