/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.time.internal.properties.configurators;

import java.time.OffsetTime;
import java.time.ZoneOffset;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.configurators.ArbitraryConfiguratorBase;
import net.jqwik.api.providers.TypeUsage;
import net.jqwik.time.api.arbitraries.OffsetTimeArbitrary;
import net.jqwik.time.api.arbitraries.ZoneOffsetArbitrary;
import net.jqwik.time.api.constraints.OffsetRange;

public class OffsetRangeConfigurator {
    private static boolean filter(OffsetTime offsetTime, ZoneOffset min, ZoneOffset max) {
        ZoneOffset offset = offsetTime.getOffset();
        return OffsetRangeConfigurator.filter(offset, min, max);
    }

    private static boolean filter(ZoneOffset offset, ZoneOffset min, ZoneOffset max) {
        if (min.getTotalSeconds() > max.getTotalSeconds()) {
            ZoneOffset remember = min;
            min = max;
            max = remember;
        }
        return offset.getTotalSeconds() >= min.getTotalSeconds() && offset.getTotalSeconds() <= max.getTotalSeconds();
    }

    public static class ForZoneOffset
    extends ArbitraryConfiguratorBase {
        protected boolean acceptTargetType(TypeUsage targetType) {
            return targetType.isAssignableFrom(ZoneOffset.class);
        }

        public Arbitrary<ZoneOffset> configure(Arbitrary<ZoneOffset> arbitrary, OffsetRange range) {
            ZoneOffset min = ZoneOffset.of(range.min());
            ZoneOffset max = ZoneOffset.of(range.max());
            if (arbitrary instanceof ZoneOffsetArbitrary) {
                ZoneOffsetArbitrary zoneOffsetArbitrary = (ZoneOffsetArbitrary)arbitrary;
                return zoneOffsetArbitrary.between(min, max);
            }
            return arbitrary.filter(v -> OffsetRangeConfigurator.filter(v, min, max));
        }
    }

    public static class ForOffsetTime
    extends ArbitraryConfiguratorBase {
        protected boolean acceptTargetType(TypeUsage targetType) {
            return targetType.isAssignableFrom(OffsetTime.class);
        }

        public Arbitrary<OffsetTime> configure(Arbitrary<OffsetTime> arbitrary, OffsetRange range) {
            ZoneOffset min = ZoneOffset.of(range.min());
            ZoneOffset max = ZoneOffset.of(range.max());
            if (arbitrary instanceof OffsetTimeArbitrary) {
                OffsetTimeArbitrary offsetTimeArbitrary = (OffsetTimeArbitrary)arbitrary;
                return offsetTimeArbitrary.offsetBetween(min, max);
            }
            return arbitrary.filter(v -> OffsetRangeConfigurator.filter(v, min, max));
        }
    }
}

