/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.time.internal.properties.configurators;

import java.time.Duration;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.temporal.ChronoUnit;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.configurators.ArbitraryConfiguratorBase;
import net.jqwik.api.providers.TypeUsage;
import net.jqwik.time.api.arbitraries.DurationArbitrary;
import net.jqwik.time.api.arbitraries.LocalDateTimeArbitrary;
import net.jqwik.time.api.arbitraries.LocalTimeArbitrary;
import net.jqwik.time.api.arbitraries.OffsetTimeArbitrary;
import net.jqwik.time.api.constraints.Precision;

public class PrecisionConfigurator {
    private static boolean filter(int minute, int second, int nano, ChronoUnit ofPrecision) {
        switch (ofPrecision) {
            case HOURS: {
                if (minute != 0) {
                    return false;
                }
            }
            case MINUTES: {
                if (second != 0) {
                    return false;
                }
            }
            case SECONDS: {
                if (nano == 0) break;
                return false;
            }
            case MILLIS: {
                if (nano % 1000000 == 0) break;
                return false;
            }
            case MICROS: {
                if (nano % 1000 == 0) break;
                return false;
            }
        }
        return true;
    }

    private static boolean filter(LocalDateTime dateTime, ChronoUnit ofPrecision) {
        return PrecisionConfigurator.filter(dateTime.toLocalTime(), ofPrecision);
    }

    private static boolean filter(LocalTime time, ChronoUnit ofPrecision) {
        return PrecisionConfigurator.filter(time.getMinute(), time.getSecond(), time.getNano(), ofPrecision);
    }

    private static boolean filter(OffsetTime offsetTime, ChronoUnit ofPrecision) {
        LocalTime time = offsetTime.toLocalTime();
        return PrecisionConfigurator.filter(time, ofPrecision);
    }

    private static boolean filter(Duration duration, ChronoUnit ofPrecision) {
        int minutes = (int)(duration.getSeconds() % 3600L / 60L);
        int seconds = (int)(duration.getSeconds() % 60L);
        int nanos = duration.getNano();
        return PrecisionConfigurator.filter(minutes, seconds, nanos, ofPrecision);
    }

    public static class ForDuration
    extends ArbitraryConfiguratorBase {
        protected boolean acceptTargetType(TypeUsage targetType) {
            return targetType.isAssignableFrom(Duration.class);
        }

        public Arbitrary<Duration> configure(Arbitrary<Duration> arbitrary, Precision range) {
            ChronoUnit ofPrecision = range.value();
            if (arbitrary instanceof DurationArbitrary) {
                DurationArbitrary durationArbitrary = (DurationArbitrary)arbitrary;
                return durationArbitrary.ofPrecision(ofPrecision);
            }
            return arbitrary.filter(v -> PrecisionConfigurator.filter(v, ofPrecision));
        }
    }

    public static class ForOffsetTime
    extends ArbitraryConfiguratorBase {
        protected boolean acceptTargetType(TypeUsage targetType) {
            return targetType.isAssignableFrom(OffsetTime.class);
        }

        public Arbitrary<OffsetTime> configure(Arbitrary<OffsetTime> arbitrary, Precision range) {
            ChronoUnit ofPrecision = range.value();
            if (arbitrary instanceof OffsetTimeArbitrary) {
                OffsetTimeArbitrary offsetTimeArbitrary = (OffsetTimeArbitrary)arbitrary;
                return offsetTimeArbitrary.ofPrecision(ofPrecision);
            }
            return arbitrary.filter(v -> PrecisionConfigurator.filter(v, ofPrecision));
        }
    }

    public static class ForLocalTime
    extends ArbitraryConfiguratorBase {
        protected boolean acceptTargetType(TypeUsage targetType) {
            return targetType.isAssignableFrom(LocalTime.class);
        }

        public Arbitrary<LocalTime> configure(Arbitrary<LocalTime> arbitrary, Precision range) {
            ChronoUnit ofPrecision = range.value();
            if (arbitrary instanceof LocalTimeArbitrary) {
                LocalTimeArbitrary localTimeArbitrary = (LocalTimeArbitrary)arbitrary;
                return localTimeArbitrary.ofPrecision(ofPrecision);
            }
            return arbitrary.filter(v -> PrecisionConfigurator.filter(v, ofPrecision));
        }
    }

    public static class ForLocalDateTime
    extends ArbitraryConfiguratorBase {
        protected boolean acceptTargetType(TypeUsage targetType) {
            return targetType.isAssignableFrom(LocalDateTime.class);
        }

        public Arbitrary<LocalDateTime> configure(Arbitrary<LocalDateTime> arbitrary, Precision range) {
            ChronoUnit ofPrecision = range.value();
            if (arbitrary instanceof LocalDateTimeArbitrary) {
                LocalDateTimeArbitrary localDateTimeArbitrary = (LocalDateTimeArbitrary)arbitrary;
                return localDateTimeArbitrary.ofPrecision(ofPrecision);
            }
            return arbitrary.filter(v -> PrecisionConfigurator.filter(v, ofPrecision));
        }
    }
}

