/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.time.internal.properties.configurators;

import java.time.LocalTime;
import java.time.OffsetTime;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.configurators.ArbitraryConfiguratorBase;
import net.jqwik.api.providers.TypeUsage;
import net.jqwik.time.api.arbitraries.LocalTimeArbitrary;
import net.jqwik.time.api.arbitraries.OffsetTimeArbitrary;
import net.jqwik.time.api.constraints.TimeRange;

public class TimeRangeConfigurator {
    private static LocalTime stringToLocalTime(String time) {
        return LocalTime.parse(time);
    }

    private static boolean filter(LocalTime time, LocalTime min, LocalTime max) {
        return !time.isBefore(min) && !time.isAfter(max);
    }

    private static boolean filter(OffsetTime offsetTime, LocalTime min, LocalTime max) {
        LocalTime time = offsetTime.toLocalTime();
        return TimeRangeConfigurator.filter(time, min, max);
    }

    public static class ForOffsetTime
    extends ArbitraryConfiguratorBase {
        protected boolean acceptTargetType(TypeUsage targetType) {
            return targetType.isAssignableFrom(OffsetTime.class);
        }

        public Arbitrary<OffsetTime> configure(Arbitrary<OffsetTime> arbitrary, TimeRange range) {
            LocalTime min = TimeRangeConfigurator.stringToLocalTime(range.min());
            LocalTime max = TimeRangeConfigurator.stringToLocalTime(range.max());
            if (arbitrary instanceof OffsetTimeArbitrary) {
                OffsetTimeArbitrary offsetTimeArbitrary = (OffsetTimeArbitrary)arbitrary;
                return offsetTimeArbitrary.between(min, max);
            }
            return arbitrary.filter(v -> TimeRangeConfigurator.filter(v, min, max));
        }
    }

    public static class ForLocalTime
    extends ArbitraryConfiguratorBase {
        protected boolean acceptTargetType(TypeUsage targetType) {
            return targetType.isAssignableFrom(LocalTime.class);
        }

        public Arbitrary<LocalTime> configure(Arbitrary<LocalTime> arbitrary, TimeRange range) {
            LocalTime min = TimeRangeConfigurator.stringToLocalTime(range.min());
            LocalTime max = TimeRangeConfigurator.stringToLocalTime(range.max());
            if (arbitrary instanceof LocalTimeArbitrary) {
                LocalTimeArbitrary localTimeArbitrary = (LocalTimeArbitrary)arbitrary;
                return localTimeArbitrary.between(min, max);
            }
            return arbitrary.filter(v -> TimeRangeConfigurator.filter(v, min, max));
        }
    }
}

