/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.time.internal.properties.arbitraries.valueRanges;

import java.math.BigInteger;
import java.time.Duration;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class OfPrecision {
    public static final ChronoUnit DEFAULT = ChronoUnit.SECONDS;
    private static final Set<ChronoUnit> ALLOWED_PRECISIONS = new HashSet<ChronoUnit>(Arrays.asList(ChronoUnit.HOURS, ChronoUnit.MINUTES, ChronoUnit.SECONDS, ChronoUnit.MILLIS, ChronoUnit.MICROS, ChronoUnit.NANOS));
    private ChronoUnit precision = DEFAULT;
    private boolean precisionSet = false;

    public void set(ChronoUnit precision) {
        this.setProgrammatically(precision);
        this.precisionSet = true;
    }

    public void setProgrammatically(ChronoUnit precision) {
        if (!ALLOWED_PRECISIONS.contains(precision)) {
            throw new IllegalArgumentException("Precision value must be one of these ChronoUnit values: HOURS, MINUTES, SECONDS, MILLIS, MICROS, NANOS");
        }
        this.precision = precision;
    }

    public ChronoUnit get() {
        return this.precision;
    }

    public boolean isSet() {
        return this.precisionSet;
    }

    public boolean isGreatherThan(ChronoUnit precision) {
        return this.precision.compareTo(precision) > 0;
    }

    public boolean isLessOrEqualTo(ChronoUnit precision) {
        return this.precision.compareTo(precision) <= 0;
    }

    public boolean valueWithPrecisionIsAllowed(int minutes, int seconds, int nanos) {
        boolean retVal = true;
        switch (this.precision) {
            case HOURS: {
                retVal = minutes == 0;
            }
            case MINUTES: {
                retVal = retVal && seconds == 0;
            }
            case SECONDS: {
                retVal = retVal && nanos == 0;
                break;
            }
            case MILLIS: {
                retVal = nanos % 1000000 == 0;
                break;
            }
            case MICROS: {
                retVal = nanos % 1000 == 0;
            }
        }
        return retVal;
    }

    public Duration maxPossibleDuration() {
        switch (this.precision) {
            case HOURS: {
                return Duration.ofSeconds(9223372036854774000L, 0L);
            }
            case MINUTES: {
                return Duration.ofSeconds(0x7FFFFFFFFFFFFFF8L, 0L);
            }
            case MILLIS: {
                return Duration.ofSeconds(Long.MAX_VALUE, 999000000L);
            }
            case MICROS: {
                return Duration.ofSeconds(Long.MAX_VALUE, 999999000L);
            }
            case NANOS: {
                return Duration.ofSeconds(Long.MAX_VALUE, 999999999L);
            }
        }
        return Duration.ofSeconds(Long.MAX_VALUE, 0L);
    }

    public LocalTime maxPossibleLocalTime() {
        switch (this.precision) {
            case HOURS: {
                return LocalTime.of(23, 0, 0, 0);
            }
            case MINUTES: {
                return LocalTime.of(23, 59, 0, 0);
            }
            case MILLIS: {
                return LocalTime.of(23, 59, 59, 999000000);
            }
            case MICROS: {
                return LocalTime.of(23, 59, 59, 999999000);
            }
            case NANOS: {
                return LocalTime.of(23, 59, 59, 999999999);
            }
        }
        return LocalTime.of(23, 59, 59, 0);
    }

    public long longsBetween(LocalTime effectiveMin, LocalTime effectiveMax) {
        switch (this.precision) {
            case HOURS: {
                return ChronoUnit.HOURS.between(effectiveMin, effectiveMax);
            }
            case MINUTES: {
                return ChronoUnit.MINUTES.between(effectiveMin, effectiveMax);
            }
            case SECONDS: {
                return ChronoUnit.SECONDS.between(effectiveMin, effectiveMax);
            }
            case MILLIS: {
                return ChronoUnit.MILLIS.between(effectiveMin, effectiveMax);
            }
            case MICROS: {
                return ChronoUnit.MICROS.between(effectiveMin, effectiveMax);
            }
        }
        return ChronoUnit.NANOS.between(effectiveMin, effectiveMax);
    }

    public LocalTime localTimeFromValue(long longAdd, LocalTime effectiveMin) {
        switch (this.precision) {
            case HOURS: {
                return effectiveMin.plusHours(longAdd);
            }
            case MINUTES: {
                return effectiveMin.plusMinutes(longAdd);
            }
            case SECONDS: {
                return effectiveMin.plusSeconds(longAdd);
            }
            case MILLIS: {
                longAdd *= 1000L;
            }
            case MICROS: {
                longAdd *= 1000L;
            }
        }
        return effectiveMin.plusNanos(longAdd);
    }

    public LocalTime effectiveMaxNanos(LocalTime effective) {
        switch (this.precision) {
            case MILLIS: {
                effective = effective.withNano(999000000);
                break;
            }
            case MICROS: {
                effective = effective.withNano(999999000);
                break;
            }
            case NANOS: {
                effective = effective.withNano(999999999);
                break;
            }
            default: {
                effective = effective.withNano(0);
            }
        }
        return effective;
    }

    public Duration minPossibleDuration() {
        switch (this.precision) {
            case HOURS: {
                return Duration.ofSeconds(-9223372036854774000L, 0L);
            }
            case MINUTES: {
                return Duration.ofSeconds(-9223372036854775800L, 0L);
            }
        }
        return Duration.ofSeconds(Long.MIN_VALUE, 0L);
    }

    public Duration durationFromValue(BigInteger bigInteger) {
        BigInteger helperDivide = new BigInteger("1000000000");
        BigInteger helperMultiply1000 = new BigInteger("1000");
        BigInteger helperMultiply60 = new BigInteger("60");
        switch (this.precision) {
            case HOURS: {
                bigInteger = bigInteger.multiply(helperMultiply60);
            }
            case MINUTES: {
                bigInteger = bigInteger.multiply(helperMultiply60);
            }
            case SECONDS: {
                bigInteger = bigInteger.multiply(helperMultiply1000);
            }
            case MILLIS: {
                bigInteger = bigInteger.multiply(helperMultiply1000);
            }
            case MICROS: {
                bigInteger = bigInteger.multiply(helperMultiply1000);
            }
        }
        BigInteger bigIntegerSeconds = bigInteger.divide(helperDivide);
        long seconds = bigIntegerSeconds.longValue();
        int nanos = bigInteger.subtract(bigIntegerSeconds.multiply(helperDivide)).intValue();
        return Duration.ofSeconds(seconds, nanos);
    }
}

