/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.time.api.arbitraries;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.OffsetDateTime;
import java.time.Year;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import net.jqwik.api.Arbitrary;
import org.apiguardian.api.API;

@API(status=API.Status.EXPERIMENTAL, since="1.5.5")
public interface OffsetDateTimeArbitrary
extends Arbitrary<OffsetDateTime> {
    default public OffsetDateTimeArbitrary between(LocalDateTime min, LocalDateTime max) {
        if (min.isAfter(max)) {
            return this.atTheEarliest(max).atTheLatest(min);
        }
        return this.atTheEarliest(min).atTheLatest(max);
    }

    public OffsetDateTimeArbitrary atTheEarliest(LocalDateTime var1);

    public OffsetDateTimeArbitrary atTheLatest(LocalDateTime var1);

    public OffsetDateTimeArbitrary dateBetween(LocalDate var1, LocalDate var2);

    public OffsetDateTimeArbitrary yearBetween(Year var1, Year var2);

    default public OffsetDateTimeArbitrary yearBetween(int min, int max) {
        return this.yearBetween(Year.of(min), Year.of(max));
    }

    public OffsetDateTimeArbitrary monthBetween(Month var1, Month var2);

    default public OffsetDateTimeArbitrary monthBetween(int min, int max) {
        return this.monthBetween(Month.of(min), Month.of(max));
    }

    public OffsetDateTimeArbitrary onlyMonths(Month ... var1);

    public OffsetDateTimeArbitrary dayOfMonthBetween(int var1, int var2);

    public OffsetDateTimeArbitrary onlyDaysOfWeek(DayOfWeek ... var1);

    public OffsetDateTimeArbitrary timeBetween(LocalTime var1, LocalTime var2);

    public OffsetDateTimeArbitrary hourBetween(int var1, int var2);

    public OffsetDateTimeArbitrary minuteBetween(int var1, int var2);

    public OffsetDateTimeArbitrary secondBetween(int var1, int var2);

    public OffsetDateTimeArbitrary offsetBetween(ZoneOffset var1, ZoneOffset var2);

    public OffsetDateTimeArbitrary ofPrecision(ChronoUnit var1);
}

