/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.time.internal.properties.arbitraries;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.OffsetDateTime;
import java.time.Year;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.Combinators;
import net.jqwik.api.arbitraries.ArbitraryDecorator;
import net.jqwik.time.api.DateTimes;
import net.jqwik.time.api.Times;
import net.jqwik.time.api.arbitraries.LocalDateTimeArbitrary;
import net.jqwik.time.api.arbitraries.OffsetDateTimeArbitrary;
import net.jqwik.time.api.arbitraries.ZoneOffsetArbitrary;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL)
public class DefaultOffsetDateTimeArbitrary
extends ArbitraryDecorator<OffsetDateTime>
implements OffsetDateTimeArbitrary {
    private LocalDateTimeArbitrary localDateTimes = DateTimes.dateTimes();
    private ZoneOffsetArbitrary zoneOffsets = Times.zoneOffsets();

    protected Arbitrary<OffsetDateTime> arbitrary() {
        return Combinators.combine((Arbitrary)this.localDateTimes, (Arbitrary)this.zoneOffsets).as(OffsetDateTime::of);
    }

    @Override
    public OffsetDateTimeArbitrary atTheEarliest(LocalDateTime min) {
        DefaultOffsetDateTimeArbitrary clone = (DefaultOffsetDateTimeArbitrary)this.typedClone();
        clone.localDateTimes = clone.localDateTimes.atTheEarliest(min);
        return clone;
    }

    @Override
    public OffsetDateTimeArbitrary atTheLatest(LocalDateTime max) {
        DefaultOffsetDateTimeArbitrary clone = (DefaultOffsetDateTimeArbitrary)this.typedClone();
        clone.localDateTimes = clone.localDateTimes.atTheLatest(max);
        return clone;
    }

    @Override
    public OffsetDateTimeArbitrary dateBetween(LocalDate min, LocalDate max) {
        DefaultOffsetDateTimeArbitrary clone = (DefaultOffsetDateTimeArbitrary)this.typedClone();
        clone.localDateTimes = clone.localDateTimes.dateBetween(min, max);
        return clone;
    }

    @Override
    public OffsetDateTimeArbitrary yearBetween(Year min, Year max) {
        DefaultOffsetDateTimeArbitrary clone = (DefaultOffsetDateTimeArbitrary)this.typedClone();
        clone.localDateTimes = clone.localDateTimes.yearBetween(min, max);
        return clone;
    }

    @Override
    public OffsetDateTimeArbitrary monthBetween(Month min, Month max) {
        DefaultOffsetDateTimeArbitrary clone = (DefaultOffsetDateTimeArbitrary)this.typedClone();
        clone.localDateTimes = clone.localDateTimes.monthBetween(min, max);
        return clone;
    }

    @Override
    public OffsetDateTimeArbitrary onlyMonths(Month ... months) {
        DefaultOffsetDateTimeArbitrary clone = (DefaultOffsetDateTimeArbitrary)this.typedClone();
        clone.localDateTimes = clone.localDateTimes.onlyMonths(months);
        return clone;
    }

    @Override
    public OffsetDateTimeArbitrary dayOfMonthBetween(int min, int max) {
        DefaultOffsetDateTimeArbitrary clone = (DefaultOffsetDateTimeArbitrary)this.typedClone();
        clone.localDateTimes = clone.localDateTimes.dayOfMonthBetween(min, max);
        return clone;
    }

    @Override
    public OffsetDateTimeArbitrary onlyDaysOfWeek(DayOfWeek ... daysOfWeek) {
        DefaultOffsetDateTimeArbitrary clone = (DefaultOffsetDateTimeArbitrary)this.typedClone();
        clone.localDateTimes = clone.localDateTimes.onlyDaysOfWeek(daysOfWeek);
        return clone;
    }

    @Override
    public OffsetDateTimeArbitrary timeBetween(LocalTime min, LocalTime max) {
        DefaultOffsetDateTimeArbitrary clone = (DefaultOffsetDateTimeArbitrary)this.typedClone();
        clone.localDateTimes = clone.localDateTimes.timeBetween(min, max);
        return clone;
    }

    @Override
    public OffsetDateTimeArbitrary hourBetween(int min, int max) {
        DefaultOffsetDateTimeArbitrary clone = (DefaultOffsetDateTimeArbitrary)this.typedClone();
        clone.localDateTimes = clone.localDateTimes.hourBetween(min, max);
        return clone;
    }

    @Override
    public OffsetDateTimeArbitrary minuteBetween(int min, int max) {
        DefaultOffsetDateTimeArbitrary clone = (DefaultOffsetDateTimeArbitrary)this.typedClone();
        clone.localDateTimes = clone.localDateTimes.minuteBetween(min, max);
        return clone;
    }

    @Override
    public OffsetDateTimeArbitrary secondBetween(int min, int max) {
        DefaultOffsetDateTimeArbitrary clone = (DefaultOffsetDateTimeArbitrary)this.typedClone();
        clone.localDateTimes = clone.localDateTimes.secondBetween(min, max);
        return clone;
    }

    @Override
    public OffsetDateTimeArbitrary offsetBetween(ZoneOffset min, ZoneOffset max) {
        DefaultOffsetDateTimeArbitrary clone = (DefaultOffsetDateTimeArbitrary)this.typedClone();
        clone.zoneOffsets = clone.zoneOffsets.between(min, max);
        return clone;
    }

    @Override
    public OffsetDateTimeArbitrary ofPrecision(ChronoUnit ofPrecision) {
        DefaultOffsetDateTimeArbitrary clone = (DefaultOffsetDateTimeArbitrary)this.typedClone();
        clone.localDateTimes = clone.localDateTimes.ofPrecision(ofPrecision);
        return clone;
    }
}

