/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.time.internal.properties.configurators;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.configurators.ArbitraryConfiguratorBase;
import net.jqwik.api.providers.TypeUsage;
import net.jqwik.time.api.arbitraries.InstantArbitrary;
import net.jqwik.time.api.arbitraries.LocalDateTimeArbitrary;
import net.jqwik.time.api.arbitraries.LocalTimeArbitrary;
import net.jqwik.time.api.arbitraries.OffsetDateTimeArbitrary;
import net.jqwik.time.api.arbitraries.OffsetTimeArbitrary;
import net.jqwik.time.api.constraints.TimeRange;
import net.jqwik.time.internal.properties.arbitraries.DefaultInstantArbitrary;

public class TimeRangeConfigurator {
    private static LocalTime stringToLocalTime(String time) {
        return LocalTime.parse(time);
    }

    private static boolean filter(LocalTime time, LocalTime min, LocalTime max) {
        return !time.isBefore(min) && !time.isAfter(max);
    }

    private static boolean filter(LocalDateTime dateTime, LocalTime min, LocalTime max) {
        return TimeRangeConfigurator.filter(dateTime.toLocalTime(), min, max);
    }

    private static boolean filter(Instant instant, LocalTime min, LocalTime max) {
        if (LocalDateTime.MIN.toInstant(ZoneOffset.UTC).isAfter(instant) || LocalDateTime.MAX.toInstant(ZoneOffset.UTC).isBefore(instant)) {
            return false;
        }
        return TimeRangeConfigurator.filter(DefaultInstantArbitrary.instantToLocalDateTime(instant).toLocalTime(), min, max);
    }

    private static boolean filter(OffsetDateTime dateTime, LocalTime min, LocalTime max) {
        return TimeRangeConfigurator.filter(dateTime.toLocalTime(), min, max);
    }

    private static boolean filter(OffsetTime offsetTime, LocalTime min, LocalTime max) {
        return TimeRangeConfigurator.filter(offsetTime.toLocalTime(), min, max);
    }

    public static class ForOffsetTime
    extends ArbitraryConfiguratorBase {
        protected boolean acceptTargetType(TypeUsage targetType) {
            return targetType.isAssignableFrom(OffsetTime.class);
        }

        public Arbitrary<OffsetTime> configure(Arbitrary<OffsetTime> arbitrary, TimeRange range) {
            LocalTime min = TimeRangeConfigurator.stringToLocalTime(range.min());
            LocalTime max = TimeRangeConfigurator.stringToLocalTime(range.max());
            if (arbitrary instanceof OffsetTimeArbitrary) {
                OffsetTimeArbitrary offsetTimeArbitrary = (OffsetTimeArbitrary)arbitrary;
                return offsetTimeArbitrary.between(min, max);
            }
            return arbitrary.filter(v -> TimeRangeConfigurator.filter(v, min, max));
        }
    }

    public static class ForLocalTime
    extends ArbitraryConfiguratorBase {
        protected boolean acceptTargetType(TypeUsage targetType) {
            return targetType.isAssignableFrom(LocalTime.class);
        }

        public Arbitrary<LocalTime> configure(Arbitrary<LocalTime> arbitrary, TimeRange range) {
            LocalTime min = TimeRangeConfigurator.stringToLocalTime(range.min());
            LocalTime max = TimeRangeConfigurator.stringToLocalTime(range.max());
            if (arbitrary instanceof LocalTimeArbitrary) {
                LocalTimeArbitrary localTimeArbitrary = (LocalTimeArbitrary)arbitrary;
                return localTimeArbitrary.between(min, max);
            }
            return arbitrary.filter(v -> TimeRangeConfigurator.filter(v, min, max));
        }
    }

    public static class ForOffsetDateTime
    extends ArbitraryConfiguratorBase {
        protected boolean acceptTargetType(TypeUsage targetType) {
            return targetType.isAssignableFrom(OffsetDateTime.class);
        }

        public Arbitrary<OffsetDateTime> configure(Arbitrary<OffsetDateTime> arbitrary, TimeRange range) {
            LocalTime min = TimeRangeConfigurator.stringToLocalTime(range.min());
            LocalTime max = TimeRangeConfigurator.stringToLocalTime(range.max());
            if (arbitrary instanceof OffsetDateTimeArbitrary) {
                OffsetDateTimeArbitrary offsetDateTimeArbitrary = (OffsetDateTimeArbitrary)arbitrary;
                return offsetDateTimeArbitrary.timeBetween(min, max);
            }
            return arbitrary.filter(v -> TimeRangeConfigurator.filter(v, min, max));
        }
    }

    public static class ForInstant
    extends ArbitraryConfiguratorBase {
        protected boolean acceptTargetType(TypeUsage targetType) {
            return targetType.isAssignableFrom(Instant.class);
        }

        public Arbitrary<Instant> configure(Arbitrary<Instant> arbitrary, TimeRange range) {
            LocalTime min = TimeRangeConfigurator.stringToLocalTime(range.min());
            LocalTime max = TimeRangeConfigurator.stringToLocalTime(range.max());
            if (arbitrary instanceof InstantArbitrary) {
                InstantArbitrary instantArbitrary = (InstantArbitrary)arbitrary;
                return instantArbitrary.timeBetween(min, max);
            }
            return arbitrary.filter(v -> TimeRangeConfigurator.filter(v, min, max));
        }
    }

    public static class ForLocalDateTime
    extends ArbitraryConfiguratorBase {
        protected boolean acceptTargetType(TypeUsage targetType) {
            return targetType.isAssignableFrom(LocalDateTime.class);
        }

        public Arbitrary<LocalDateTime> configure(Arbitrary<LocalDateTime> arbitrary, TimeRange range) {
            LocalTime min = TimeRangeConfigurator.stringToLocalTime(range.min());
            LocalTime max = TimeRangeConfigurator.stringToLocalTime(range.max());
            if (arbitrary instanceof LocalDateTimeArbitrary) {
                LocalDateTimeArbitrary localDateTimeArbitrary = (LocalDateTimeArbitrary)arbitrary;
                return localDateTimeArbitrary.timeBetween(min, max);
            }
            return arbitrary.filter(v -> TimeRangeConfigurator.filter(v, min, max));
        }
    }
}

