/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.time.internal.properties.configurators;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Calendar;
import java.util.Date;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.configurators.ArbitraryConfiguratorBase;
import net.jqwik.api.providers.TypeUsage;
import net.jqwik.time.api.arbitraries.CalendarArbitrary;
import net.jqwik.time.api.arbitraries.DateArbitrary;
import net.jqwik.time.api.arbitraries.InstantArbitrary;
import net.jqwik.time.api.arbitraries.LocalDateArbitrary;
import net.jqwik.time.api.arbitraries.LocalDateTimeArbitrary;
import net.jqwik.time.api.arbitraries.OffsetDateTimeArbitrary;
import net.jqwik.time.api.constraints.DateRange;
import net.jqwik.time.internal.properties.arbitraries.DefaultCalendarArbitrary;
import net.jqwik.time.internal.properties.arbitraries.DefaultInstantArbitrary;

public class DateRangeConfigurator {
    private static boolean filter(LocalDateTime date, LocalDate min, LocalDate max) {
        return DateRangeConfigurator.filter(date.toLocalDate(), min, max);
    }

    private static boolean filter(Instant instant, LocalDate min, LocalDate max) {
        if (LocalDateTime.MIN.toInstant(ZoneOffset.UTC).isAfter(instant) || LocalDateTime.MAX.toInstant(ZoneOffset.UTC).isBefore(instant)) {
            return false;
        }
        return DateRangeConfigurator.filter(DefaultInstantArbitrary.instantToLocalDateTime(instant), min, max);
    }

    private static boolean filter(OffsetDateTime dateTime, LocalDate min, LocalDate max) {
        return DateRangeConfigurator.filter(dateTime.toLocalDate(), min, max);
    }

    private static boolean filter(LocalDate date, LocalDate min, LocalDate max) {
        return !date.isBefore(min) && !date.isAfter(max);
    }

    private static boolean filter(Calendar date, Calendar min, Calendar max) {
        return date.compareTo(min) >= 0 && date.compareTo(max) <= 0;
    }

    private static boolean filter(Date date, Date min, Date max) {
        return date.compareTo(min) >= 0 && date.compareTo(max) <= 0;
    }

    private static LocalDate isoDateToLocalDate(String iso) {
        return LocalDate.parse(iso);
    }

    private static Calendar isoDateToCalendar(String iso, boolean max) {
        LocalDate localDate = DateRangeConfigurator.isoDateToLocalDate(iso);
        Calendar calendar = DefaultCalendarArbitrary.localDateToCalendar(localDate);
        if (max) {
            calendar.set(11, 23);
            calendar.set(12, 59);
            calendar.set(13, 59);
            calendar.set(14, 999);
        }
        return calendar;
    }

    private static Date isoDateToDate(String iso, boolean max) {
        Calendar calendar = DateRangeConfigurator.isoDateToCalendar(iso, max);
        return calendar.getTime();
    }

    public static class ForDate
    extends ArbitraryConfiguratorBase {
        protected boolean acceptTargetType(TypeUsage targetType) {
            return targetType.isAssignableFrom(Date.class);
        }

        public Arbitrary<Date> configure(Arbitrary<Date> arbitrary, DateRange range) {
            Date min = DateRangeConfigurator.isoDateToDate(range.min(), false);
            Date max = DateRangeConfigurator.isoDateToDate(range.max(), true);
            if (arbitrary instanceof DateArbitrary) {
                DateArbitrary dateArbitrary = (DateArbitrary)arbitrary;
                return dateArbitrary.between(min, max);
            }
            return arbitrary.filter(v -> DateRangeConfigurator.filter(v, min, max));
        }
    }

    public static class ForCalendar
    extends ArbitraryConfiguratorBase {
        protected boolean acceptTargetType(TypeUsage targetType) {
            return targetType.isAssignableFrom(Calendar.class);
        }

        public Arbitrary<Calendar> configure(Arbitrary<Calendar> arbitrary, DateRange range) {
            Calendar min = DateRangeConfigurator.isoDateToCalendar(range.min(), false);
            Calendar max = DateRangeConfigurator.isoDateToCalendar(range.max(), true);
            if (arbitrary instanceof CalendarArbitrary) {
                CalendarArbitrary calendarArbitrary = (CalendarArbitrary)arbitrary;
                return calendarArbitrary.between(min, max);
            }
            return arbitrary.filter(v -> DateRangeConfigurator.filter(v, min, max));
        }
    }

    public static class ForLocalDate
    extends ArbitraryConfiguratorBase {
        protected boolean acceptTargetType(TypeUsage targetType) {
            return targetType.isAssignableFrom(LocalDate.class);
        }

        public Arbitrary<LocalDate> configure(Arbitrary<LocalDate> arbitrary, DateRange range) {
            LocalDate min = DateRangeConfigurator.isoDateToLocalDate(range.min());
            LocalDate max = DateRangeConfigurator.isoDateToLocalDate(range.max());
            if (arbitrary instanceof LocalDateArbitrary) {
                LocalDateArbitrary localDateArbitrary = (LocalDateArbitrary)arbitrary;
                return localDateArbitrary.between(min, max);
            }
            return arbitrary.filter(v -> DateRangeConfigurator.filter(v, min, max));
        }
    }

    public static class ForOffsetDateTime
    extends ArbitraryConfiguratorBase {
        protected boolean acceptTargetType(TypeUsage targetType) {
            return targetType.isAssignableFrom(OffsetDateTime.class);
        }

        public Arbitrary<OffsetDateTime> configure(Arbitrary<OffsetDateTime> arbitrary, DateRange range) {
            LocalDate min = DateRangeConfigurator.isoDateToLocalDate(range.min());
            LocalDate max = DateRangeConfigurator.isoDateToLocalDate(range.max());
            if (arbitrary instanceof OffsetDateTimeArbitrary) {
                OffsetDateTimeArbitrary offsetDateTimeArbitrary = (OffsetDateTimeArbitrary)arbitrary;
                return offsetDateTimeArbitrary.dateBetween(min, max);
            }
            return arbitrary.filter(v -> DateRangeConfigurator.filter(v, min, max));
        }
    }

    public static class ForInstant
    extends ArbitraryConfiguratorBase {
        protected boolean acceptTargetType(TypeUsage targetType) {
            return targetType.isAssignableFrom(Instant.class);
        }

        public Arbitrary<Instant> configure(Arbitrary<Instant> arbitrary, DateRange range) {
            LocalDate min = DateRangeConfigurator.isoDateToLocalDate(range.min());
            LocalDate max = DateRangeConfigurator.isoDateToLocalDate(range.max());
            if (arbitrary instanceof InstantArbitrary) {
                InstantArbitrary instantArbitrary = (InstantArbitrary)arbitrary;
                return instantArbitrary.dateBetween(min, max);
            }
            return arbitrary.filter(v -> DateRangeConfigurator.filter(v, min, max));
        }
    }

    public static class ForLocalDateTime
    extends ArbitraryConfiguratorBase {
        protected boolean acceptTargetType(TypeUsage targetType) {
            return targetType.isAssignableFrom(LocalDateTime.class);
        }

        public Arbitrary<LocalDateTime> configure(Arbitrary<LocalDateTime> arbitrary, DateRange range) {
            LocalDate min = DateRangeConfigurator.isoDateToLocalDate(range.min());
            LocalDate max = DateRangeConfigurator.isoDateToLocalDate(range.max());
            if (arbitrary instanceof LocalDateTimeArbitrary) {
                LocalDateTimeArbitrary localDateTimeArbitrary = (LocalDateTimeArbitrary)arbitrary;
                return localDateTimeArbitrary.dateBetween(min, max);
            }
            return arbitrary.filter(v -> DateRangeConfigurator.filter(v, min, max));
        }
    }
}

