/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.time.internal.properties.configurators;

import java.time.Duration;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.configurators.ArbitraryConfiguratorBase;
import net.jqwik.api.providers.TypeUsage;
import net.jqwik.time.api.arbitraries.DurationArbitrary;
import net.jqwik.time.api.constraints.DurationRange;

public class DurationRangeConfigurator
extends ArbitraryConfiguratorBase {
    protected boolean acceptTargetType(TypeUsage targetType) {
        return targetType.isAssignableFrom(Duration.class);
    }

    public Arbitrary<Duration> configure(Arbitrary<Duration> arbitrary, DurationRange range) {
        Duration min = Duration.parse(range.min());
        Duration max = Duration.parse(range.max());
        if (arbitrary instanceof DurationArbitrary) {
            DurationArbitrary durationArbitrary = (DurationArbitrary)arbitrary;
            return durationArbitrary.between(min, max);
        }
        return arbitrary.filter(v -> this.filter((Duration)v, min, max));
    }

    private boolean filter(Duration duration, Duration min, Duration max) {
        return duration.compareTo(min) >= 0 && duration.compareTo(max) <= 0;
    }
}

