/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.time.internal.properties.arbitraries;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.Month;
import java.time.Year;
import java.util.Calendar;
import java.util.TimeZone;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.arbitraries.ArbitraryDecorator;
import net.jqwik.time.api.Dates;
import net.jqwik.time.api.arbitraries.CalendarArbitrary;
import net.jqwik.time.api.arbitraries.LocalDateArbitrary;
import net.jqwik.time.internal.properties.arbitraries.valueRanges.YearBetween;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL)
public class DefaultCalendarArbitrary
extends ArbitraryDecorator<Calendar>
implements CalendarArbitrary {
    private LocalDateArbitrary dates = Dates.dates();

    protected Arbitrary<Calendar> arbitrary() {
        return this.dates.map(DefaultCalendarArbitrary::localDateToCalendar);
    }

    public static Calendar localDateToCalendar(LocalDate date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
        calendar.set(date.getYear(), DefaultCalendarArbitrary.monthToCalendarMonth(date.getMonth()), date.getDayOfMonth(), 0, 0, 0);
        calendar.set(14, 0);
        return calendar;
    }

    private LocalDate calendarToLocalDate(Calendar date) {
        return LocalDate.of(date.get(1), DefaultCalendarArbitrary.calendarMonthToMonth(date.get(2)), date.get(5));
    }

    public static int monthToCalendarMonth(Month month) {
        switch (month) {
            case JANUARY: {
                return 0;
            }
            case FEBRUARY: {
                return 1;
            }
            case MARCH: {
                return 2;
            }
            case APRIL: {
                return 3;
            }
            case MAY: {
                return 4;
            }
            case JUNE: {
                return 5;
            }
            case JULY: {
                return 6;
            }
            case AUGUST: {
                return 7;
            }
            case SEPTEMBER: {
                return 8;
            }
            case OCTOBER: {
                return 9;
            }
            case NOVEMBER: {
                return 10;
            }
        }
        return 11;
    }

    public static Month calendarMonthToMonth(Calendar calendar) {
        return DefaultCalendarArbitrary.calendarMonthToMonth(calendar.get(2));
    }

    public static Month calendarMonthToMonth(int month) {
        switch (month) {
            case 0: {
                return Month.JANUARY;
            }
            case 1: {
                return Month.FEBRUARY;
            }
            case 2: {
                return Month.MARCH;
            }
            case 3: {
                return Month.APRIL;
            }
            case 4: {
                return Month.MAY;
            }
            case 5: {
                return Month.JUNE;
            }
            case 6: {
                return Month.JULY;
            }
            case 7: {
                return Month.AUGUST;
            }
            case 8: {
                return Month.SEPTEMBER;
            }
            case 9: {
                return Month.OCTOBER;
            }
            case 10: {
                return Month.NOVEMBER;
            }
        }
        return Month.DECEMBER;
    }

    public static DayOfWeek calendarDayOfWeekToDayOfWeek(Calendar calendar) {
        return DefaultCalendarArbitrary.calendarDayOfWeekToDayOfWeek(calendar.get(7));
    }

    public static DayOfWeek calendarDayOfWeekToDayOfWeek(int dayOfWeek) {
        switch (dayOfWeek) {
            case 2: {
                return DayOfWeek.MONDAY;
            }
            case 3: {
                return DayOfWeek.TUESDAY;
            }
            case 4: {
                return DayOfWeek.WEDNESDAY;
            }
            case 5: {
                return DayOfWeek.THURSDAY;
            }
            case 6: {
                return DayOfWeek.FRIDAY;
            }
            case 7: {
                return DayOfWeek.SATURDAY;
            }
        }
        return DayOfWeek.SUNDAY;
    }

    @Override
    public CalendarArbitrary atTheEarliest(Calendar min) {
        if (min.get(0) != 1) {
            throw new IllegalArgumentException("Minimum year in a date must be > 0");
        }
        if (min.get(1) > 292278993) {
            throw new IllegalArgumentException("Minimum year in a calendar date must be <= 292278993");
        }
        DefaultCalendarArbitrary clone = (DefaultCalendarArbitrary)this.typedClone();
        clone.dates = clone.dates.atTheEarliest(this.calendarToLocalDate(min));
        return clone;
    }

    @Override
    public CalendarArbitrary atTheLatest(Calendar max) {
        if (max.get(0) != 1) {
            throw new IllegalArgumentException("Maximum year in a date must be > 0");
        }
        if (max.get(1) > 292278993) {
            throw new IllegalArgumentException("Maximum year in a calendar date must be <= 292278993");
        }
        DefaultCalendarArbitrary clone = (DefaultCalendarArbitrary)this.typedClone();
        clone.dates = clone.dates.atTheLatest(this.calendarToLocalDate(max));
        return clone;
    }

    @Override
    public CalendarArbitrary yearBetween(Year min, Year max) {
        YearBetween yearBetween = (YearBetween)new YearBetween().useInCalendar().set(min, max);
        DefaultCalendarArbitrary clone = (DefaultCalendarArbitrary)this.typedClone();
        clone.dates = clone.dates.yearBetween((Year)yearBetween.getMin(), (Year)yearBetween.getMax());
        return clone;
    }

    @Override
    public CalendarArbitrary monthBetween(Month min, Month max) {
        DefaultCalendarArbitrary clone = (DefaultCalendarArbitrary)this.typedClone();
        clone.dates = clone.dates.monthBetween(min, max);
        return clone;
    }

    @Override
    public CalendarArbitrary onlyMonths(Month ... months) {
        DefaultCalendarArbitrary clone = (DefaultCalendarArbitrary)this.typedClone();
        clone.dates = clone.dates.onlyMonths(months);
        return clone;
    }

    @Override
    public CalendarArbitrary dayOfMonthBetween(int min, int max) {
        DefaultCalendarArbitrary clone = (DefaultCalendarArbitrary)this.typedClone();
        clone.dates = clone.dates.dayOfMonthBetween(min, max);
        return clone;
    }

    @Override
    public CalendarArbitrary onlyDaysOfWeek(DayOfWeek ... daysOfWeek) {
        DefaultCalendarArbitrary clone = (DefaultCalendarArbitrary)this.typedClone();
        clone.dates = clone.dates.onlyDaysOfWeek(daysOfWeek);
        return clone;
    }
}

