/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.time.internal.properties.arbitraries;

import java.time.LocalDate;
import java.time.Month;
import java.time.MonthDay;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.arbitraries.ArbitraryDecorator;
import net.jqwik.time.api.Dates;
import net.jqwik.time.api.arbitraries.LocalDateArbitrary;
import net.jqwik.time.api.arbitraries.MonthDayArbitrary;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL)
public class DefaultMonthDayArbitrary
extends ArbitraryDecorator<MonthDay>
implements MonthDayArbitrary {
    private static final int YEAR = 2000;
    private LocalDateArbitrary localDateArbitrary = Dates.dates().yearBetween(2000, 2000);

    protected Arbitrary<MonthDay> arbitrary() {
        return this.localDateArbitrary.map(v -> MonthDay.of(v.getMonth(), v.getDayOfMonth()));
    }

    @Override
    public MonthDayArbitrary atTheEarliest(MonthDay min) {
        DefaultMonthDayArbitrary clone = (DefaultMonthDayArbitrary)this.typedClone();
        LocalDate minDate = LocalDate.of(2000, min.getMonth(), min.getDayOfMonth());
        clone.localDateArbitrary = this.localDateArbitrary.atTheEarliest(minDate);
        return clone;
    }

    @Override
    public MonthDayArbitrary atTheLatest(MonthDay max) {
        DefaultMonthDayArbitrary clone = (DefaultMonthDayArbitrary)this.typedClone();
        LocalDate maxDate = LocalDate.of(2000, max.getMonth(), max.getDayOfMonth());
        clone.localDateArbitrary = this.localDateArbitrary.atTheLatest(maxDate);
        return clone;
    }

    @Override
    public MonthDayArbitrary monthBetween(Month min, Month max) {
        DefaultMonthDayArbitrary clone = (DefaultMonthDayArbitrary)this.typedClone();
        clone.localDateArbitrary = this.localDateArbitrary.monthBetween(min, max);
        return clone;
    }

    @Override
    public MonthDayArbitrary onlyMonths(Month ... months) {
        DefaultMonthDayArbitrary clone = (DefaultMonthDayArbitrary)this.typedClone();
        clone.localDateArbitrary = this.localDateArbitrary.onlyMonths(months);
        return clone;
    }

    @Override
    public MonthDayArbitrary dayOfMonthBetween(int min, int max) {
        DefaultMonthDayArbitrary clone = (DefaultMonthDayArbitrary)this.typedClone();
        clone.localDateArbitrary = this.localDateArbitrary.dayOfMonthBetween(min, max);
        return clone;
    }
}

