/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.time.internal.properties.configurators;

import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.configurators.ArbitraryConfiguratorBase;
import net.jqwik.api.providers.TypeUsage;
import net.jqwik.time.api.arbitraries.CalendarArbitrary;
import net.jqwik.time.api.arbitraries.DateArbitrary;
import net.jqwik.time.api.arbitraries.InstantArbitrary;
import net.jqwik.time.api.arbitraries.LocalDateArbitrary;
import net.jqwik.time.api.arbitraries.LocalDateTimeArbitrary;
import net.jqwik.time.api.arbitraries.OffsetDateTimeArbitrary;
import net.jqwik.time.api.arbitraries.ZonedDateTimeArbitrary;
import net.jqwik.time.api.constraints.DayOfWeekRange;
import net.jqwik.time.internal.properties.arbitraries.DefaultCalendarArbitrary;
import net.jqwik.time.internal.properties.arbitraries.DefaultInstantArbitrary;

public class DayOfWeekRangeConfigurator {
    private static DayOfWeek[] createDayOfWeekArray(DayOfWeekRange range) {
        ArrayList<DayOfWeek> dayOfWeeks = new ArrayList<DayOfWeek>();
        for (int i = range.min().getValue(); i <= range.max().getValue(); ++i) {
            dayOfWeeks.add(DayOfWeek.of(i));
        }
        return dayOfWeeks.toArray(new DayOfWeek[0]);
    }

    private static boolean filter(DayOfWeek dayOfWeek, DayOfWeek[] dayOfWeeks) {
        for (DayOfWeek dow : dayOfWeeks) {
            if (dayOfWeek != dow) continue;
            return true;
        }
        return false;
    }

    private static boolean filter(LocalDateTime dateTime, DayOfWeek[] dayOfWeeks) {
        return DayOfWeekRangeConfigurator.filter(dateTime.getDayOfWeek(), dayOfWeeks);
    }

    private static boolean filter(Instant instant, DayOfWeek[] dayOfWeeks) {
        if (LocalDateTime.MIN.toInstant(ZoneOffset.UTC).isAfter(instant) || LocalDateTime.MAX.toInstant(ZoneOffset.UTC).isBefore(instant)) {
            return false;
        }
        return DayOfWeekRangeConfigurator.filter(DefaultInstantArbitrary.instantToLocalDateTime(instant).getDayOfWeek(), dayOfWeeks);
    }

    private static boolean filter(OffsetDateTime dateTime, DayOfWeek[] dayOfWeeks) {
        return DayOfWeekRangeConfigurator.filter(dateTime.getDayOfWeek(), dayOfWeeks);
    }

    private static boolean filter(ZonedDateTime dateTime, DayOfWeek[] dayOfWeeks) {
        return DayOfWeekRangeConfigurator.filter(dateTime.getDayOfWeek(), dayOfWeeks);
    }

    private static boolean filter(LocalDate date, DayOfWeek[] dayOfWeeks) {
        return DayOfWeekRangeConfigurator.filter(date.getDayOfWeek(), dayOfWeeks);
    }

    private static boolean filter(Calendar date, DayOfWeek[] dayOfWeeks) {
        DayOfWeek dayOfWeek = DefaultCalendarArbitrary.calendarDayOfWeekToDayOfWeek(date.get(7));
        return DayOfWeekRangeConfigurator.filter(dayOfWeek, dayOfWeeks);
    }

    private static boolean filter(Date date, DayOfWeek[] dayOfWeeks) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return DayOfWeekRangeConfigurator.filter(calendar, dayOfWeeks);
    }

    public static class ForDate
    extends ArbitraryConfiguratorBase {
        protected boolean acceptTargetType(TypeUsage targetType) {
            return targetType.isAssignableFrom(Date.class);
        }

        public Arbitrary<Date> configure(Arbitrary<Date> arbitrary, DayOfWeekRange range) {
            DayOfWeek[] dayOfWeeks = DayOfWeekRangeConfigurator.createDayOfWeekArray(range);
            if (arbitrary instanceof DateArbitrary) {
                DateArbitrary dateArbitrary = (DateArbitrary)arbitrary;
                return dateArbitrary.onlyDaysOfWeek(dayOfWeeks);
            }
            return arbitrary.filter(v -> DayOfWeekRangeConfigurator.filter(v, dayOfWeeks));
        }
    }

    public static class ForCalendar
    extends ArbitraryConfiguratorBase {
        protected boolean acceptTargetType(TypeUsage targetType) {
            return targetType.isAssignableFrom(Calendar.class);
        }

        public Arbitrary<Calendar> configure(Arbitrary<Calendar> arbitrary, DayOfWeekRange range) {
            DayOfWeek[] dayOfWeeks = DayOfWeekRangeConfigurator.createDayOfWeekArray(range);
            if (arbitrary instanceof CalendarArbitrary) {
                CalendarArbitrary calendarArbitrary = (CalendarArbitrary)arbitrary;
                return calendarArbitrary.onlyDaysOfWeek(dayOfWeeks);
            }
            return arbitrary.filter(v -> DayOfWeekRangeConfigurator.filter(v, dayOfWeeks));
        }
    }

    public static class ForLocalDate
    extends ArbitraryConfiguratorBase {
        protected boolean acceptTargetType(TypeUsage targetType) {
            return targetType.isAssignableFrom(LocalDate.class);
        }

        public Arbitrary<LocalDate> configure(Arbitrary<LocalDate> arbitrary, DayOfWeekRange range) {
            DayOfWeek[] dayOfWeeks = DayOfWeekRangeConfigurator.createDayOfWeekArray(range);
            if (arbitrary instanceof LocalDateArbitrary) {
                LocalDateArbitrary localDateArbitrary = (LocalDateArbitrary)arbitrary;
                return localDateArbitrary.onlyDaysOfWeek(dayOfWeeks);
            }
            return arbitrary.filter(v -> DayOfWeekRangeConfigurator.filter(v, dayOfWeeks));
        }
    }

    public static class ForZonedDateTime
    extends ArbitraryConfiguratorBase {
        protected boolean acceptTargetType(TypeUsage targetType) {
            return targetType.isAssignableFrom(ZonedDateTime.class);
        }

        public Arbitrary<ZonedDateTime> configure(Arbitrary<ZonedDateTime> arbitrary, DayOfWeekRange range) {
            DayOfWeek[] dayOfWeeks = DayOfWeekRangeConfigurator.createDayOfWeekArray(range);
            if (arbitrary instanceof ZonedDateTimeArbitrary) {
                ZonedDateTimeArbitrary zonedDateTimeArbitrary = (ZonedDateTimeArbitrary)arbitrary;
                return zonedDateTimeArbitrary.onlyDaysOfWeek(dayOfWeeks);
            }
            return arbitrary.filter(v -> DayOfWeekRangeConfigurator.filter(v, dayOfWeeks));
        }
    }

    public static class ForOffsetDateTime
    extends ArbitraryConfiguratorBase {
        protected boolean acceptTargetType(TypeUsage targetType) {
            return targetType.isAssignableFrom(OffsetDateTime.class);
        }

        public Arbitrary<OffsetDateTime> configure(Arbitrary<OffsetDateTime> arbitrary, DayOfWeekRange range) {
            DayOfWeek[] dayOfWeeks = DayOfWeekRangeConfigurator.createDayOfWeekArray(range);
            if (arbitrary instanceof OffsetDateTimeArbitrary) {
                OffsetDateTimeArbitrary offsetDateTimeArbitrary = (OffsetDateTimeArbitrary)arbitrary;
                return offsetDateTimeArbitrary.onlyDaysOfWeek(dayOfWeeks);
            }
            return arbitrary.filter(v -> DayOfWeekRangeConfigurator.filter(v, dayOfWeeks));
        }
    }

    public static class ForInstant
    extends ArbitraryConfiguratorBase {
        protected boolean acceptTargetType(TypeUsage targetType) {
            return targetType.isAssignableFrom(Instant.class);
        }

        public Arbitrary<Instant> configure(Arbitrary<Instant> arbitrary, DayOfWeekRange range) {
            DayOfWeek[] dayOfWeeks = DayOfWeekRangeConfigurator.createDayOfWeekArray(range);
            if (arbitrary instanceof InstantArbitrary) {
                InstantArbitrary instantArbitrary = (InstantArbitrary)arbitrary;
                return instantArbitrary.onlyDaysOfWeek(dayOfWeeks);
            }
            return arbitrary.filter(v -> DayOfWeekRangeConfigurator.filter(v, dayOfWeeks));
        }
    }

    public static class ForLocalDateTime
    extends ArbitraryConfiguratorBase {
        protected boolean acceptTargetType(TypeUsage targetType) {
            return targetType.isAssignableFrom(LocalDateTime.class);
        }

        public Arbitrary<LocalDateTime> configure(Arbitrary<LocalDateTime> arbitrary, DayOfWeekRange range) {
            DayOfWeek[] dayOfWeeks = DayOfWeekRangeConfigurator.createDayOfWeekArray(range);
            if (arbitrary instanceof LocalDateTimeArbitrary) {
                LocalDateTimeArbitrary localDateTimeArbitrary = (LocalDateTimeArbitrary)arbitrary;
                return localDateTimeArbitrary.onlyDaysOfWeek(dayOfWeeks);
            }
            return arbitrary.filter(v -> DayOfWeekRangeConfigurator.filter(v, dayOfWeeks));
        }
    }
}

