/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.time.internal.properties.arbitraries;

import java.time.DayOfWeek;
import java.time.Month;
import java.time.Year;
import java.util.Calendar;
import java.util.Date;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.arbitraries.ArbitraryDecorator;
import net.jqwik.time.api.Dates;
import net.jqwik.time.api.arbitraries.CalendarArbitrary;
import net.jqwik.time.api.arbitraries.DateArbitrary;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL)
public class DefaultDateArbitrary
extends ArbitraryDecorator<Date>
implements DateArbitrary {
    private CalendarArbitrary calendars = Dates.datesAsCalendar();

    protected Arbitrary<Date> arbitrary() {
        return this.calendars.map(Calendar::getTime);
    }

    public static Calendar dateToCalendar(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    @Override
    public DateArbitrary atTheEarliest(Date min) {
        DefaultDateArbitrary clone = (DefaultDateArbitrary)this.typedClone();
        clone.calendars = clone.calendars.atTheEarliest(DefaultDateArbitrary.dateToCalendar(min));
        return clone;
    }

    @Override
    public DateArbitrary atTheLatest(Date max) {
        DefaultDateArbitrary clone = (DefaultDateArbitrary)this.typedClone();
        clone.calendars = clone.calendars.atTheLatest(DefaultDateArbitrary.dateToCalendar(max));
        return clone;
    }

    @Override
    public DateArbitrary yearBetween(Year min, Year max) {
        DefaultDateArbitrary clone = (DefaultDateArbitrary)this.typedClone();
        clone.calendars = clone.calendars.yearBetween(min, max);
        return clone;
    }

    @Override
    public DateArbitrary monthBetween(Month min, Month max) {
        DefaultDateArbitrary clone = (DefaultDateArbitrary)this.typedClone();
        clone.calendars = clone.calendars.monthBetween(min, max);
        return clone;
    }

    @Override
    public DateArbitrary onlyMonths(Month ... months) {
        DefaultDateArbitrary clone = (DefaultDateArbitrary)this.typedClone();
        clone.calendars = clone.calendars.onlyMonths(months);
        return clone;
    }

    @Override
    public DateArbitrary dayOfMonthBetween(int min, int max) {
        DefaultDateArbitrary clone = (DefaultDateArbitrary)this.typedClone();
        clone.calendars = clone.calendars.dayOfMonthBetween(min, max);
        return clone;
    }

    @Override
    public DateArbitrary onlyDaysOfWeek(DayOfWeek ... daysOfWeek) {
        DefaultDateArbitrary clone = (DefaultDateArbitrary)this.typedClone();
        clone.calendars = clone.calendars.onlyDaysOfWeek(daysOfWeek);
        return clone;
    }
}

