/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.time.internal.properties.arbitraries;

import java.time.DateTimeException;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.Year;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.jqwik.api.Arbitraries;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.Combinators;
import net.jqwik.api.arbitraries.ArbitraryDecorator;
import net.jqwik.time.api.DateTimes;
import net.jqwik.time.api.arbitraries.LocalDateTimeArbitrary;
import net.jqwik.time.api.arbitraries.ZonedDateTimeArbitrary;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL)
public class DefaultZonedDateTimeArbitrary
extends ArbitraryDecorator<ZonedDateTime>
implements ZonedDateTimeArbitrary {
    private LocalDateTimeArbitrary localDateTimes = DateTimes.dateTimes();
    private Arbitrary<ZoneId> zoneIds = this.sortedZoneIds();

    protected Arbitrary<ZonedDateTime> arbitrary() {
        return Combinators.combine((Arbitrary)this.localDateTimes, this.zoneIds).as(this::getStrict).ignoreException(DateTimeException.class);
    }

    private ZonedDateTime getStrict(LocalDateTime dateTime, ZoneId zoneId) {
        return ZonedDateTime.ofStrict(dateTime, zoneId.getRules().getOffset(dateTime), zoneId);
    }

    private Arbitrary<ZoneId> sortedZoneIds() {
        LocalDateTime refTime = LocalDateTime.of(2000, 1, 1, 0, 0, 0);
        Comparator<ZoneId> zoneIdComparator = Comparator.comparing(zoneId -> ZonedDateTime.of(refTime, zoneId));
        List sortedZoneIds = ZoneId.getAvailableZoneIds().stream().map(ZoneId::of).sorted(zoneIdComparator).collect(Collectors.toList());
        return Arbitraries.of(sortedZoneIds);
    }

    @Override
    public ZonedDateTimeArbitrary atTheEarliest(LocalDateTime min) {
        DefaultZonedDateTimeArbitrary clone = (DefaultZonedDateTimeArbitrary)this.typedClone();
        clone.localDateTimes = clone.localDateTimes.atTheEarliest(min);
        return clone;
    }

    @Override
    public ZonedDateTimeArbitrary atTheLatest(LocalDateTime max) {
        DefaultZonedDateTimeArbitrary clone = (DefaultZonedDateTimeArbitrary)this.typedClone();
        clone.localDateTimes = clone.localDateTimes.atTheLatest(max);
        return clone;
    }

    @Override
    public ZonedDateTimeArbitrary dateBetween(LocalDate min, LocalDate max) {
        DefaultZonedDateTimeArbitrary clone = (DefaultZonedDateTimeArbitrary)this.typedClone();
        clone.localDateTimes = clone.localDateTimes.dateBetween(min, max);
        return clone;
    }

    @Override
    public ZonedDateTimeArbitrary yearBetween(Year min, Year max) {
        DefaultZonedDateTimeArbitrary clone = (DefaultZonedDateTimeArbitrary)this.typedClone();
        clone.localDateTimes = clone.localDateTimes.yearBetween(min, max);
        return clone;
    }

    @Override
    public ZonedDateTimeArbitrary monthBetween(Month min, Month max) {
        DefaultZonedDateTimeArbitrary clone = (DefaultZonedDateTimeArbitrary)this.typedClone();
        clone.localDateTimes = clone.localDateTimes.monthBetween(min, max);
        return clone;
    }

    @Override
    public ZonedDateTimeArbitrary onlyMonths(Month ... months) {
        DefaultZonedDateTimeArbitrary clone = (DefaultZonedDateTimeArbitrary)this.typedClone();
        clone.localDateTimes = clone.localDateTimes.onlyMonths(months);
        return clone;
    }

    @Override
    public ZonedDateTimeArbitrary dayOfMonthBetween(int min, int max) {
        DefaultZonedDateTimeArbitrary clone = (DefaultZonedDateTimeArbitrary)this.typedClone();
        clone.localDateTimes = clone.localDateTimes.dayOfMonthBetween(min, max);
        return clone;
    }

    @Override
    public ZonedDateTimeArbitrary onlyDaysOfWeek(DayOfWeek ... daysOfWeek) {
        DefaultZonedDateTimeArbitrary clone = (DefaultZonedDateTimeArbitrary)this.typedClone();
        clone.localDateTimes = clone.localDateTimes.onlyDaysOfWeek(daysOfWeek);
        return clone;
    }

    @Override
    public ZonedDateTimeArbitrary timeBetween(LocalTime min, LocalTime max) {
        DefaultZonedDateTimeArbitrary clone = (DefaultZonedDateTimeArbitrary)this.typedClone();
        clone.localDateTimes = clone.localDateTimes.timeBetween(min, max);
        return clone;
    }

    @Override
    public ZonedDateTimeArbitrary hourBetween(int min, int max) {
        DefaultZonedDateTimeArbitrary clone = (DefaultZonedDateTimeArbitrary)this.typedClone();
        clone.localDateTimes = clone.localDateTimes.hourBetween(min, max);
        return clone;
    }

    @Override
    public ZonedDateTimeArbitrary minuteBetween(int min, int max) {
        DefaultZonedDateTimeArbitrary clone = (DefaultZonedDateTimeArbitrary)this.typedClone();
        clone.localDateTimes = clone.localDateTimes.minuteBetween(min, max);
        return clone;
    }

    @Override
    public ZonedDateTimeArbitrary secondBetween(int min, int max) {
        DefaultZonedDateTimeArbitrary clone = (DefaultZonedDateTimeArbitrary)this.typedClone();
        clone.localDateTimes = clone.localDateTimes.secondBetween(min, max);
        return clone;
    }

    @Override
    public ZonedDateTimeArbitrary ofPrecision(ChronoUnit ofPrecision) {
        DefaultZonedDateTimeArbitrary clone = (DefaultZonedDateTimeArbitrary)this.typedClone();
        clone.localDateTimes = clone.localDateTimes.ofPrecision(ofPrecision);
        return clone;
    }
}

