/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.time.internal.properties.configurators;

import java.time.MonthDay;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.configurators.ArbitraryConfiguratorBase;
import net.jqwik.api.providers.TypeUsage;
import net.jqwik.time.api.arbitraries.MonthDayArbitrary;
import net.jqwik.time.api.constraints.MonthDayRange;

public class MonthDayRangeConfigurator
extends ArbitraryConfiguratorBase {
    protected boolean acceptTargetType(TypeUsage targetType) {
        return targetType.isAssignableFrom(MonthDay.class);
    }

    public Arbitrary<MonthDay> configure(Arbitrary<MonthDay> arbitrary, MonthDayRange range) {
        MonthDay min = this.isoDateToMonthDay(range.min());
        MonthDay max = this.isoDateToMonthDay(range.max());
        if (arbitrary instanceof MonthDayArbitrary) {
            MonthDayArbitrary monthDayArbitrary = (MonthDayArbitrary)arbitrary;
            return monthDayArbitrary.between(min, max);
        }
        return arbitrary.filter(v -> this.filter((MonthDay)v, min, max));
    }

    private MonthDay isoDateToMonthDay(String iso) {
        return MonthDay.parse(iso);
    }

    private boolean filter(MonthDay monthDay, MonthDay min, MonthDay max) {
        return !monthDay.isBefore(min) && !monthDay.isAfter(max);
    }
}

