/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.time.internal.properties.arbitraries;

import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.Year;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.arbitraries.ArbitraryDecorator;
import net.jqwik.time.api.DateTimes;
import net.jqwik.time.api.arbitraries.InstantArbitrary;
import net.jqwik.time.api.arbitraries.LocalDateTimeArbitrary;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL)
public class DefaultInstantArbitrary
extends ArbitraryDecorator<Instant>
implements InstantArbitrary {
    private LocalDateTimeArbitrary dateTimeArbitrary = DateTimes.dateTimes();

    protected Arbitrary<Instant> arbitrary() {
        return this.dateTimeArbitrary.map(dateTime -> dateTime.toInstant(ZoneOffset.UTC));
    }

    public static LocalDateTime instantToLocalDateTime(Instant instant) {
        if (instant.isAfter(LocalDateTime.MAX.toInstant(ZoneOffset.UTC))) {
            throw new IllegalArgumentException("Maximum supported year is 999999999 (Year.MAX_VALUE).");
        }
        return LocalDateTime.ofInstant(instant, ZoneOffset.UTC);
    }

    @Override
    public InstantArbitrary atTheEarliest(Instant min) {
        DefaultInstantArbitrary clone = (DefaultInstantArbitrary)this.typedClone();
        clone.dateTimeArbitrary = clone.dateTimeArbitrary.atTheEarliest(DefaultInstantArbitrary.instantToLocalDateTime(min));
        return clone;
    }

    @Override
    public InstantArbitrary atTheLatest(Instant max) {
        DefaultInstantArbitrary clone = (DefaultInstantArbitrary)this.typedClone();
        clone.dateTimeArbitrary = clone.dateTimeArbitrary.atTheLatest(DefaultInstantArbitrary.instantToLocalDateTime(max));
        return clone;
    }

    @Override
    public InstantArbitrary dateBetween(LocalDate min, LocalDate max) {
        DefaultInstantArbitrary clone = (DefaultInstantArbitrary)this.typedClone();
        clone.dateTimeArbitrary = clone.dateTimeArbitrary.dateBetween(min, max);
        return clone;
    }

    @Override
    public InstantArbitrary yearBetween(Year min, Year max) {
        DefaultInstantArbitrary clone = (DefaultInstantArbitrary)this.typedClone();
        clone.dateTimeArbitrary = clone.dateTimeArbitrary.yearBetween(min, max);
        return clone;
    }

    @Override
    public InstantArbitrary monthBetween(Month min, Month max) {
        DefaultInstantArbitrary clone = (DefaultInstantArbitrary)this.typedClone();
        clone.dateTimeArbitrary = clone.dateTimeArbitrary.monthBetween(min, max);
        return clone;
    }

    @Override
    public InstantArbitrary onlyMonths(Month ... months) {
        DefaultInstantArbitrary clone = (DefaultInstantArbitrary)this.typedClone();
        clone.dateTimeArbitrary = clone.dateTimeArbitrary.onlyMonths(months);
        return clone;
    }

    @Override
    public InstantArbitrary dayOfMonthBetween(int min, int max) {
        DefaultInstantArbitrary clone = (DefaultInstantArbitrary)this.typedClone();
        clone.dateTimeArbitrary = clone.dateTimeArbitrary.dayOfMonthBetween(min, max);
        return clone;
    }

    @Override
    public InstantArbitrary onlyDaysOfWeek(DayOfWeek ... daysOfWeek) {
        DefaultInstantArbitrary clone = (DefaultInstantArbitrary)this.typedClone();
        clone.dateTimeArbitrary = clone.dateTimeArbitrary.onlyDaysOfWeek(daysOfWeek);
        return clone;
    }

    @Override
    public InstantArbitrary timeBetween(LocalTime min, LocalTime max) {
        DefaultInstantArbitrary clone = (DefaultInstantArbitrary)this.typedClone();
        clone.dateTimeArbitrary = clone.dateTimeArbitrary.timeBetween(min, max);
        return clone;
    }

    @Override
    public InstantArbitrary hourBetween(int min, int max) {
        DefaultInstantArbitrary clone = (DefaultInstantArbitrary)this.typedClone();
        clone.dateTimeArbitrary = clone.dateTimeArbitrary.hourBetween(min, max);
        return clone;
    }

    @Override
    public InstantArbitrary minuteBetween(int min, int max) {
        DefaultInstantArbitrary clone = (DefaultInstantArbitrary)this.typedClone();
        clone.dateTimeArbitrary = clone.dateTimeArbitrary.minuteBetween(min, max);
        return clone;
    }

    @Override
    public InstantArbitrary secondBetween(int min, int max) {
        DefaultInstantArbitrary clone = (DefaultInstantArbitrary)this.typedClone();
        clone.dateTimeArbitrary = clone.dateTimeArbitrary.secondBetween(min, max);
        return clone;
    }

    @Override
    public InstantArbitrary ofPrecision(ChronoUnit ofPrecision) {
        DefaultInstantArbitrary clone = (DefaultInstantArbitrary)this.typedClone();
        clone.dateTimeArbitrary = clone.dateTimeArbitrary.ofPrecision(ofPrecision);
        return clone;
    }
}

