/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.time.internal.properties.arbitraries;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.Year;
import java.time.temporal.ChronoUnit;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.arbitraries.ArbitraryDecorator;
import net.jqwik.time.api.Dates;
import net.jqwik.time.api.Times;
import net.jqwik.time.api.arbitraries.LocalDateArbitrary;
import net.jqwik.time.api.arbitraries.LocalDateTimeArbitrary;
import net.jqwik.time.api.arbitraries.LocalTimeArbitrary;
import net.jqwik.time.internal.properties.arbitraries.DefaultLocalDateArbitrary;
import net.jqwik.time.internal.properties.arbitraries.DefaultLocalTimeArbitrary;
import net.jqwik.time.internal.properties.arbitraries.valueRanges.AllowedDayOfWeeks;
import net.jqwik.time.internal.properties.arbitraries.valueRanges.AllowedMonths;
import net.jqwik.time.internal.properties.arbitraries.valueRanges.DayOfMonthBetween;
import net.jqwik.time.internal.properties.arbitraries.valueRanges.HourBetween;
import net.jqwik.time.internal.properties.arbitraries.valueRanges.LocalDateBetween;
import net.jqwik.time.internal.properties.arbitraries.valueRanges.LocalDateTimeBetween;
import net.jqwik.time.internal.properties.arbitraries.valueRanges.LocalTimeBetween;
import net.jqwik.time.internal.properties.arbitraries.valueRanges.MinuteBetween;
import net.jqwik.time.internal.properties.arbitraries.valueRanges.MonthBetween;
import net.jqwik.time.internal.properties.arbitraries.valueRanges.OfPrecision;
import net.jqwik.time.internal.properties.arbitraries.valueRanges.SecondBetween;
import net.jqwik.time.internal.properties.arbitraries.valueRanges.YearBetween;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL)
public class DefaultLocalDateTimeArbitrary
extends ArbitraryDecorator<LocalDateTime>
implements LocalDateTimeArbitrary {
    private static final LocalDateTime DEFAULT_MIN = LocalDateTime.of(DefaultLocalDateArbitrary.DEFAULT_MIN_DATE, LocalTime.MIN);
    private static final LocalDateTime DEFAULT_MAX = LocalDateTime.of(DefaultLocalDateArbitrary.DEFAULT_MAX_DATE, LocalTime.MAX);
    private final LocalDateTimeBetween dateTimeBetween = new LocalDateTimeBetween();
    private final LocalDateBetween dateBetween = new LocalDateBetween();
    private final AllowedMonths allowedMonths = new AllowedMonths();
    private final DayOfMonthBetween dayOfMonthBetween = new DayOfMonthBetween();
    private final AllowedDayOfWeeks allowedDayOfWeeks = new AllowedDayOfWeeks();
    private final LocalTimeBetween timeBetween = new LocalTimeBetween();
    private final HourBetween hourBetween = (HourBetween)new HourBetween().set(0, 23);
    private final MinuteBetween minuteBetween = (MinuteBetween)new MinuteBetween().set(0, 59);
    private final SecondBetween secondBetween = (SecondBetween)new SecondBetween().set(0, 59);
    private final OfPrecision ofPrecision = new OfPrecision();

    protected Arbitrary<LocalDateTime> arbitrary() {
        LocalDateTime effectiveMin = this.effectiveMin();
        LocalDateTime effectiveMax = this.effectiveMax(effectiveMin);
        LocalDateArbitrary dates = Dates.dates();
        TimeArbitraries times = this.generateTimeArbitraries(effectiveMin, effectiveMax, this.ofPrecision);
        dates = dates.atTheEarliest(effectiveMin.toLocalDate());
        dates = dates.atTheLatest(effectiveMax.toLocalDate());
        dates = this.setDateParams(dates);
        LocalDate effectiveMinDate = effectiveMin.toLocalDate();
        LocalDate effectiveMaxDate = effectiveMax.toLocalDate();
        return dates.flatMap(date -> this.timesByDate(times, (LocalDate)date, effectiveMinDate, effectiveMaxDate).map(time -> LocalDateTime.of(date, time)));
    }

    private LocalDateArbitrary setDateParams(LocalDateArbitrary dates) {
        dates = dates.onlyMonths(this.allowedMonths.get().toArray(new Month[0]));
        if (this.dayOfMonthBetween.getMin() != null && this.dayOfMonthBetween.getMax() != null) {
            dates = dates.dayOfMonthBetween((Integer)this.dayOfMonthBetween.getMin(), (Integer)this.dayOfMonthBetween.getMax());
        }
        dates = dates.onlyDaysOfWeek(this.allowedDayOfWeeks.get().toArray(new DayOfWeek[0]));
        return dates;
    }

    private LocalTimeArbitrary timesByDate(TimeArbitraries times, LocalDate date, LocalDate effectiveMin, LocalDate effectiveMax) {
        if (date.isEqual(effectiveMin)) {
            return times.firstDay;
        }
        if (date.isEqual(effectiveMax)) {
            return times.lastDay;
        }
        return times.daysBetween;
    }

    private LocalDateTime effectiveMin() {
        LocalDateTime effective = this.effectiveMinDate((LocalDateTime)this.dateTimeBetween.getMin());
        effective = effective != null ? effective : DEFAULT_MIN;
        DefaultLocalTimeArbitrary.checkTimeValueAndPrecision(effective.toLocalTime(), this.ofPrecision, true);
        LocalTime effectiveMinTime = DefaultLocalTimeArbitrary.effectiveMin(this.timeBetween, this.hourBetween, this.minuteBetween, this.secondBetween, this.ofPrecision);
        LocalTime effectiveMaxTime = DefaultLocalTimeArbitrary.effectiveMax(this.timeBetween, this.hourBetween, this.minuteBetween, this.secondBetween, this.ofPrecision);
        if (effectiveMinTime.isAfter(effectiveMaxTime)) {
            throw new IllegalArgumentException("These min/max values cannot be used with these time min/max values");
        }
        effective = this.effectiveMinWithMinTime(effective, effectiveMinTime, effectiveMaxTime);
        return effective;
    }

    private LocalDateTime effectiveMinDate(LocalDateTime effective) {
        if (this.dateBetween.getMin() == null) {
            return effective;
        }
        if (effective == null || ((LocalDate)this.dateBetween.getMin()).isAfter(effective.toLocalDate())) {
            return LocalDateTime.of((LocalDate)this.dateBetween.getMin(), LocalTime.MIN);
        }
        return effective;
    }

    private LocalDateTime effectiveMinWithMinTime(LocalDateTime effective, LocalTime minTime, LocalTime maxTime) {
        if (effective.toLocalTime().isBefore(minTime)) {
            return LocalDateTime.of(effective.toLocalDate(), minTime);
        }
        if (effective.toLocalTime().isAfter(maxTime)) {
            return LocalDateTime.of(effective.toLocalDate().plusDays(1L), minTime);
        }
        return effective;
    }

    private LocalDateTime effectiveMax(LocalDateTime effectiveMin) {
        LocalDateTime effective = this.effectiveMaxDate((LocalDateTime)this.dateTimeBetween.getMax());
        effective = effective != null ? effective : LocalDateTime.of(DEFAULT_MAX.toLocalDate(), this.ofPrecision.maxPossibleLocalTime());
        DefaultLocalTimeArbitrary.checkTimeValueAndPrecision(effective.toLocalTime(), this.ofPrecision, false);
        LocalTime effectiveMinTime = DefaultLocalTimeArbitrary.effectiveMin(this.timeBetween, this.hourBetween, this.minuteBetween, this.secondBetween, this.ofPrecision);
        LocalTime effectiveMaxTime = DefaultLocalTimeArbitrary.effectiveMax(this.timeBetween, this.hourBetween, this.minuteBetween, this.secondBetween, this.ofPrecision);
        effective = this.effectiveMaxWithMaxTime(effective, effectiveMinTime, effectiveMaxTime);
        if (effectiveMin.isAfter(effective)) {
            throw new IllegalArgumentException("These date time min/max values cannot be used with these date min/max values");
        }
        return effective;
    }

    private LocalDateTime effectiveMaxDate(LocalDateTime effective) {
        if (this.dateBetween.getMax() == null) {
            return effective;
        }
        if (effective == null || ((LocalDate)this.dateBetween.getMax()).isBefore(effective.toLocalDate())) {
            return LocalDateTime.of((LocalDate)this.dateBetween.getMax(), this.ofPrecision.maxPossibleLocalTime());
        }
        return effective;
    }

    private LocalDateTime effectiveMaxWithMaxTime(LocalDateTime effective, LocalTime minTime, LocalTime maxTime) {
        if (effective.toLocalTime().isAfter(maxTime)) {
            return LocalDateTime.of(effective.toLocalDate(), maxTime);
        }
        if (effective.toLocalTime().isBefore(minTime)) {
            return LocalDateTime.of(effective.toLocalDate().minusDays(1L), minTime);
        }
        return effective;
    }

    private TimeArbitraries generateTimeArbitraries(LocalDateTime effectiveMin, LocalDateTime effectiveMax, OfPrecision ofPrecision) {
        boolean oneDay = false;
        TimeArbitraries times = new TimeArbitraries();
        if (effectiveMin.toLocalDate().isEqual(effectiveMax.toLocalDate())) {
            oneDay = true;
            times.firstDay = Times.times().between(effectiveMin.toLocalTime(), effectiveMax.toLocalTime()).ofPrecision(ofPrecision.get());
        } else {
            times.firstDay = Times.times().atTheEarliest(effectiveMin.toLocalTime()).ofPrecision(ofPrecision.get());
            times.daysBetween = Times.times().ofPrecision(ofPrecision.get());
            times.lastDay = Times.times().atTheLatest(effectiveMax.toLocalTime()).ofPrecision(ofPrecision.get());
        }
        this.setTimeParams(times, oneDay);
        return times;
    }

    private void setTimeParams(TimeArbitraries times, boolean oneDay) {
        if (this.timeBetween.getMin() != null && this.timeBetween.getMax() != null && !oneDay) {
            times.firstDay = times.firstDay.atTheLatest((LocalTime)this.timeBetween.getMax());
            times.daysBetween = times.daysBetween.between((LocalTime)this.timeBetween.getMin(), (LocalTime)this.timeBetween.getMax());
            times.lastDay = times.lastDay.atTheEarliest((LocalTime)this.timeBetween.getMin());
        }
        times.firstDay = times.firstDay.hourBetween((Integer)this.hourBetween.getMin(), (Integer)this.hourBetween.getMax()).minuteBetween((Integer)this.minuteBetween.getMin(), (Integer)this.minuteBetween.getMax()).secondBetween((Integer)this.secondBetween.getMin(), (Integer)this.secondBetween.getMax());
        if (!oneDay) {
            times.daysBetween = times.daysBetween.hourBetween((Integer)this.hourBetween.getMin(), (Integer)this.hourBetween.getMax()).minuteBetween((Integer)this.minuteBetween.getMin(), (Integer)this.minuteBetween.getMax()).secondBetween((Integer)this.secondBetween.getMin(), (Integer)this.secondBetween.getMax());
            times.lastDay = times.lastDay.hourBetween((Integer)this.hourBetween.getMin(), (Integer)this.hourBetween.getMax()).minuteBetween((Integer)this.minuteBetween.getMin(), (Integer)this.minuteBetween.getMax()).secondBetween((Integer)this.secondBetween.getMin(), (Integer)this.secondBetween.getMax());
        }
    }

    private void setOfPrecisionImplicitly(DefaultLocalDateTimeArbitrary clone, LocalDateTime dateTime) {
        this.setOfPrecisionImplicitly(clone, dateTime.toLocalTime());
    }

    private void setOfPrecisionImplicitly(DefaultLocalDateTimeArbitrary clone, LocalTime time) {
        if (clone.ofPrecision.isSet()) {
            return;
        }
        ChronoUnit ofPrecision = DefaultLocalTimeArbitrary.ofPrecisionFromTime(time);
        if (clone.ofPrecision.isGreatherThan(ofPrecision)) {
            clone.ofPrecision.setProgrammatically(ofPrecision);
        }
    }

    @Override
    public LocalDateTimeArbitrary atTheEarliest(LocalDateTime min) {
        DefaultLocalDateTimeArbitrary clone = (DefaultLocalDateTimeArbitrary)this.typedClone();
        clone.dateTimeBetween.set(min, null);
        this.setOfPrecisionImplicitly(clone, min);
        return clone;
    }

    @Override
    public LocalDateTimeArbitrary atTheLatest(LocalDateTime max) {
        DefaultLocalDateTimeArbitrary clone = (DefaultLocalDateTimeArbitrary)this.typedClone();
        clone.dateTimeBetween.set(null, max);
        this.setOfPrecisionImplicitly(clone, max);
        return clone;
    }

    @Override
    public LocalDateTimeArbitrary dateBetween(LocalDate min, LocalDate max) {
        DefaultLocalDateTimeArbitrary clone = (DefaultLocalDateTimeArbitrary)this.typedClone();
        clone.dateBetween.set(min, max);
        return clone;
    }

    @Override
    public LocalDateTimeArbitrary yearBetween(Year min, Year max) {
        YearBetween yearBetween = (YearBetween)new YearBetween().set(min, max);
        DefaultLocalDateTimeArbitrary clone = (DefaultLocalDateTimeArbitrary)this.typedClone();
        clone.dateBetween.setYearBetween(yearBetween);
        return clone;
    }

    @Override
    public LocalDateTimeArbitrary monthBetween(Month min, Month max) {
        MonthBetween monthBetween = (MonthBetween)new MonthBetween().set(min, max);
        DefaultLocalDateTimeArbitrary clone = (DefaultLocalDateTimeArbitrary)this.typedClone();
        clone.allowedMonths.set(monthBetween);
        return clone;
    }

    @Override
    public LocalDateTimeArbitrary onlyMonths(Month ... months) {
        DefaultLocalDateTimeArbitrary clone = (DefaultLocalDateTimeArbitrary)this.typedClone();
        clone.allowedMonths.set(months);
        return clone;
    }

    @Override
    public LocalDateTimeArbitrary dayOfMonthBetween(int min, int max) {
        DefaultLocalDateTimeArbitrary clone = (DefaultLocalDateTimeArbitrary)this.typedClone();
        clone.dayOfMonthBetween.set(min, max);
        return clone;
    }

    @Override
    public LocalDateTimeArbitrary onlyDaysOfWeek(DayOfWeek ... daysOfWeek) {
        DefaultLocalDateTimeArbitrary clone = (DefaultLocalDateTimeArbitrary)this.typedClone();
        clone.allowedDayOfWeeks.set(daysOfWeek);
        return clone;
    }

    @Override
    public LocalDateTimeArbitrary timeBetween(LocalTime min, LocalTime max) {
        DefaultLocalDateTimeArbitrary clone = (DefaultLocalDateTimeArbitrary)this.typedClone();
        clone.timeBetween.set(min, max);
        clone.setOfPrecisionImplicitly(clone, min);
        clone.setOfPrecisionImplicitly(clone, max);
        return clone;
    }

    @Override
    public LocalDateTimeArbitrary hourBetween(int min, int max) {
        DefaultLocalDateTimeArbitrary clone = (DefaultLocalDateTimeArbitrary)this.typedClone();
        clone.hourBetween.set(min, max);
        return clone;
    }

    @Override
    public LocalDateTimeArbitrary minuteBetween(int min, int max) {
        DefaultLocalDateTimeArbitrary clone = (DefaultLocalDateTimeArbitrary)this.typedClone();
        clone.minuteBetween.set(min, max);
        return clone;
    }

    @Override
    public LocalDateTimeArbitrary secondBetween(int min, int max) {
        DefaultLocalDateTimeArbitrary clone = (DefaultLocalDateTimeArbitrary)this.typedClone();
        clone.secondBetween.set(min, max);
        return clone;
    }

    @Override
    public LocalDateTimeArbitrary ofPrecision(ChronoUnit ofPrecision) {
        DefaultLocalDateTimeArbitrary clone = (DefaultLocalDateTimeArbitrary)this.typedClone();
        clone.ofPrecision.set(ofPrecision);
        return clone;
    }

    private static class TimeArbitraries {
        private LocalTimeArbitrary firstDay;
        private LocalTimeArbitrary daysBetween;
        private LocalTimeArbitrary lastDay;

        private TimeArbitraries() {
        }
    }
}

