/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.time.internal.properties.arbitraries;

import java.time.Period;
import net.jqwik.api.Arbitraries;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.arbitraries.ArbitraryDecorator;
import net.jqwik.time.api.arbitraries.PeriodArbitrary;
import net.jqwik.time.internal.properties.arbitraries.valueRanges.PeriodBetween;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL)
public class DefaultPeriodArbitrary
extends ArbitraryDecorator<Period>
implements PeriodArbitrary {
    private static final Period DEFAULT_MIN = Period.ofYears(-1000);
    private static final Period DEFAULT_MAX = Period.ofYears(1000);
    private final PeriodBetween periodBetween = new PeriodBetween();

    protected Arbitrary<Period> arbitrary() {
        Period min = this.periodBetween.getMin() != null ? (Period)this.periodBetween.getMin() : DEFAULT_MIN;
        Period max = this.periodBetween.getMax() != null ? (Period)this.periodBetween.getMax() : DEFAULT_MAX;
        long minInDays = PeriodBetween.inDays(min);
        long maxInDays = PeriodBetween.inDays(max);
        Arbitrary days = Arbitraries.longs().between(minInDays, maxInDays).edgeCases(edgeCases -> edgeCases.includeOnly((Object[])new Long[]{minInDays, 0L, maxInDays}));
        return days.map(DefaultPeriodArbitrary::periodFromValue);
    }

    private static Period periodFromValue(long periodInDays) {
        int years = Math.toIntExact(periodInDays / 372L);
        int months = Math.toIntExact((periodInDays %= 372L) / 31L);
        int days = Math.toIntExact(periodInDays % 31L);
        return Period.of(years, months, days);
    }

    @Override
    public PeriodArbitrary between(Period min, Period max) {
        DefaultPeriodArbitrary clone = (DefaultPeriodArbitrary)this.typedClone();
        clone.periodBetween.set(min, max);
        return clone;
    }
}

