/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.web;

import net.jqwik.api.Arbitraries;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.Combinators;
import net.jqwik.api.Tuple;
import net.jqwik.api.arbitraries.ArbitraryDecorator;
import net.jqwik.api.arbitraries.IntegerArbitrary;
import net.jqwik.api.arbitraries.ListArbitrary;
import net.jqwik.api.arbitraries.StringArbitrary;
import net.jqwik.web.api.EmailArbitrary;
import net.jqwik.web.api.Web;

public class DefaultEmailArbitrary
extends ArbitraryDecorator<String>
implements EmailArbitrary {
    private boolean allowQuotedLocalPart = false;
    private boolean allowIPv4Host = false;
    private boolean allowIPv6Host = false;

    protected Arbitrary<String> arbitrary() {
        Arbitrary<String> arbitraryLocalPart = this.localPart();
        Arbitrary<String> arbitraryHost = this.host();
        return Combinators.combine(arbitraryLocalPart, arbitraryHost).as((localPart, domain) -> localPart + "@" + domain);
    }

    private Arbitrary<String> localPart() {
        Arbitrary<String> unquoted = this.localPartUnquoted();
        Arbitrary<String> quoted = this.localPartQuoted();
        int frequencyUnquoted = 4;
        int frequencyQuoted = this.allowQuotedLocalPart ? 1 : 0;
        return Arbitraries.frequencyOf((Tuple.Tuple2[])new Tuple.Tuple2[]{Tuple.of((Object)frequencyUnquoted, unquoted), Tuple.of((Object)frequencyQuoted, quoted)});
    }

    private Arbitrary<String> localPartUnquoted() {
        StringArbitrary unquoted = Arbitraries.strings().withChars((CharSequence)"abcdefghijklmnopqrstuvwxyz").withChars((CharSequence)"ABCDEFGHIJKLMNOPQRSTUVWXYZ").withChars((CharSequence)"0123456789!#$%&'*+-/=?^_`{|}~.").ofMinLength(1).ofMaxLength(64);
        unquoted = unquoted.filter(v -> !v.contains(".."));
        unquoted = unquoted.filter(v -> v.charAt(0) != '.');
        unquoted = unquoted.filter(v -> v.charAt(v.length() - 1) != '.');
        return unquoted.edgeCases(stringConfig -> stringConfig.includeOnly((Object[])new String[]{"A", "a", "0"}));
    }

    private Arbitrary<String> localPartQuoted() {
        StringArbitrary quoted = Arbitraries.strings().withChars((CharSequence)"abcdefghijklmnopqrstuvwxyz").withChars((CharSequence)"ABCDEFGHIJKLMNOPQRSTUVWXYZ").withChars((CharSequence)"0123456789 !#$%&'*+-/=?^_`{|}~.\"(),:;<>@[\\]").ofMinLength(1).ofMaxLength(62);
        quoted = quoted.map(v -> "\"" + v.replace("\\", "\\\\").replace("\"", "\\\"") + "\"");
        quoted = quoted.filter(v -> v.length() <= 64);
        return quoted.edgeCases(stringConfig -> stringConfig.includeOnly((Object[])new String[]{"\"a\""}).add((Object[])new String[]{"\" \""}));
    }

    private Arbitrary<String> host() {
        int frequencyDomain = 4;
        int frequencyIPv4Addresses = this.allowIPv4Host ? 1 : 0;
        int frequencyIPv6Addresses = this.allowIPv6Host ? 1 : 0;
        return Arbitraries.frequencyOf((Tuple.Tuple2[])new Tuple.Tuple2[]{Tuple.of((Object)frequencyDomain, this.webDomain()), Tuple.of((Object)frequencyIPv4Addresses, this.hostIpv4()), Tuple.of((Object)frequencyIPv6Addresses, this.hostIpv6())});
    }

    private Arbitrary<String> hostIpv4() {
        Arbitrary addressPart = Arbitraries.integers().between(0, 255).edgeCases(c -> c.includeOnly((Object[])new Integer[]{0, 255}));
        return Combinators.combine((Arbitrary)addressPart, (Arbitrary)addressPart, (Arbitrary)addressPart, (Arbitrary)addressPart).as((a, b, c, d) -> "[" + a + "." + b + "." + c + "." + d + "]").edgeCases(stringConfig -> stringConfig.includeOnly((Object[])new String[]{"[0.0.0.0]", "[255.255.255.255]"}).add((Object[])new String[]{"[127.0.0.1]"}));
    }

    private Arbitrary<String> hostIpv6() {
        ListArbitrary addressParts = this.ipv6Part().list().ofSize(8);
        Arbitrary plainAddress = addressParts.map(parts -> String.join((CharSequence)":", parts));
        return plainAddress.map(this::removeThreeOrMoreColons).filter(this::validUseOfColonInIPv6Address).map(plain -> "[" + plain + "]").edgeCases(stringConfig -> stringConfig.includeOnly((Object[])new String[]{"[::]", "[0:0:0:0:0:0:0:0]", "[ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff]", "[FFFF:FFFF:FFFF:FFFF:FFFF:FFFF:FFFF:FFFF]"}));
    }

    private boolean validUseOfColonInIPv6Address(String ip) {
        if (DefaultEmailArbitrary.hasSingleColonAtStartOrEnd(ip)) {
            return false;
        }
        return !DefaultEmailArbitrary.notOnlyFirstColonClusterHasDoubleColon(ip);
    }

    private static boolean notOnlyFirstColonClusterHasDoubleColon(String ip) {
        boolean first = true;
        boolean inCheck = false;
        for (int i = 0; i < ip.length() - 1; ++i) {
            boolean ipContainsTwoColonsAtI;
            boolean bl = ipContainsTwoColonsAtI = ip.charAt(i) == ':' && ip.charAt(i + 1) == ':';
            if (first) {
                if (!ipContainsTwoColonsAtI) continue;
                first = false;
                inCheck = true;
                continue;
            }
            if (ipContainsTwoColonsAtI && !inCheck) {
                return true;
            }
            if (ipContainsTwoColonsAtI) continue;
            inCheck = false;
        }
        return false;
    }

    private static boolean hasSingleColonAtStartOrEnd(String ip) {
        boolean startsWithOnlyOneColon = ip.charAt(0) == ':' && ip.charAt(1) != ':';
        boolean endsWithOnlyOneColon = ip.charAt(ip.length() - 1) == ':' && ip.charAt(ip.length() - 2) != ':';
        return startsWithOnlyOneColon || endsWithOnlyOneColon;
    }

    private Arbitrary<String> ipv6Part() {
        IntegerArbitrary ipv6PartNumber = Arbitraries.integers().between(0, 65535);
        return Arbitraries.frequencyOf((Tuple.Tuple2[])new Tuple.Tuple2[]{Tuple.of((Object)1, (Object)Arbitraries.just((Object)"")), Tuple.of((Object)8, (Object)ipv6PartNumber.map(this::toLowerHex)), Tuple.of((Object)1, (Object)ipv6PartNumber.map(this::toUpperHex))});
    }

    private String toLowerHex(int ipv6Part) {
        return Integer.toHexString(ipv6Part);
    }

    private String toUpperHex(int ipv6Part) {
        return this.toLowerHex(ipv6Part).toUpperCase();
    }

    private String removeThreeOrMoreColons(String address) {
        while (address.contains(":::")) {
            address = address.replace(":::", "::");
        }
        return address;
    }

    private Arbitrary<String> webDomain() {
        return Web.webDomains();
    }

    @Override
    public EmailArbitrary allowQuotedLocalPart() {
        DefaultEmailArbitrary clone = (DefaultEmailArbitrary)this.typedClone();
        clone.allowQuotedLocalPart = true;
        return clone;
    }

    @Override
    public EmailArbitrary allowIpv4Host() {
        DefaultEmailArbitrary clone = (DefaultEmailArbitrary)this.typedClone();
        clone.allowIPv4Host = true;
        return clone;
    }

    @Override
    public EmailArbitrary allowIpv6Host() {
        DefaultEmailArbitrary clone = (DefaultEmailArbitrary)this.typedClone();
        clone.allowIPv6Host = true;
        return clone;
    }
}

