/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.web;

import net.jqwik.api.Arbitraries;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.Combinators;
import net.jqwik.api.arbitraries.ArbitraryDecorator;

public class DefaultWebDomainArbitrary
extends ArbitraryDecorator<String>
implements Arbitrary<String> {
    protected Arbitrary<String> arbitrary() {
        Arbitrary<String> topLevelDomain = this.topLevelDomain();
        Arbitrary subDomains = this.domainPart(1, 63).list().ofMinSize(1).ofMaxSize(10).map(list -> String.join((CharSequence)".", list));
        return Combinators.combine((Arbitrary)subDomains, topLevelDomain).as((sd, tld) -> sd + "." + tld).filter(v -> v.length() < 253).edgeCases(stringConfig -> stringConfig.includeOnly((Object[])new String[]{"a.aa", "0.aa"}));
    }

    private Arbitrary<String> topLevelDomain() {
        return this.domainPart(2, 10).filter(this::notAllNumeric);
    }

    private boolean notAllNumeric(String tld) {
        for (char c : tld.toCharArray()) {
            if (c >= '0' && c <= '9') continue;
            return true;
        }
        return false;
    }

    private Arbitrary<String> domainPart(int minLength, int maxLength) {
        return Arbitraries.strings().withChars((CharSequence)"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ").withChars((CharSequence)"0123456789-").ofMinLength(minLength).ofMaxLength(maxLength).filter(this::validUseOfHyphensInDomainPart);
    }

    private boolean validUseOfHyphensInDomainPart(String domainPart) {
        boolean firstSignNotAHyphen = domainPart.charAt(0) != '-';
        boolean lastSignNotAHyphen = domainPart.charAt(domainPart.length() - 1) != '-';
        return firstSignNotAHyphen && lastSignNotAHyphen;
    }
}

