/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.handler;

import net.jradius.exception.RadiusException;
import net.jradius.handler.RadiusSessionHandler;
import net.jradius.log.JRadiusLogEntry;
import net.jradius.packet.RadiusPacket;
import net.jradius.server.JRadiusRequest;
import net.jradius.session.JRadiusSession;

public class SessionLogHandler
extends RadiusSessionHandler {
    private boolean isReply = false;
    private boolean isOutbound = false;

    public boolean handle(JRadiusRequest request) throws RadiusException {
        JRadiusSession session = request.getSession();
        if (session == null) {
            return this.noSessionFound(request);
        }
        RadiusPacket p = null;
        JRadiusLogEntry logEntry = session.getLogEntry(request);
        p = this.isReply ? request.getReplyPacket() : request.getRequestPacket();
        if (!this.isReply) {
            if (!this.isOutbound) {
                if (logEntry.getInboundRequest() == null) {
                    logEntry.setInboundRequest(p.toString(false, true));
                }
            } else if (logEntry.getOutboundRequest() == null) {
                logEntry.setOutboundRequest(p.toString(false, true));
            }
        } else if (!this.isOutbound) {
            if (logEntry.getInboundReply() == null) {
                logEntry.setInboundReply(p.toString(false, true));
            }
        } else if (logEntry.getOutboundReply() == null) {
            logEntry.setOutboundReply(p.toString(false, true));
        }
        request.setReturnValue(8);
        return false;
    }

    public String getDirection() {
        return this.isOutbound ? "outbound" : "inbound";
    }

    public void setDirection(String direction) {
        this.isOutbound = "outbound".equals(direction);
    }

    public String getPacketType() {
        return this.isReply ? "reply" : "request";
    }

    public void setPacketType(String packetType) {
        this.isReply = "reply".equals(packetType) || "response".equals(packetType);
    }
}

