/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.log;

import java.net.InetAddress;
import java.util.Date;
import net.jradius.exception.RadiusException;
import net.jradius.log.JRadiusLogEntry;
import net.jradius.packet.AccountingRequest;
import net.jradius.packet.RadiusPacket;
import net.jradius.server.JRadiusRequest;
import net.jradius.session.JRadiusSession;

public class RadiusLogEntry
implements JRadiusLogEntry {
    private static final long serialVersionUID = 1L;
    protected transient JRadiusSession session;
    protected Integer code;
    protected String type;
    protected String message;
    protected String packetId;
    protected String clientIPAddress;
    protected String nasIdentifier;
    protected String userName;
    protected String realm;
    protected Integer userId;
    protected String inboundRequest;
    protected String outboundRequest;
    protected String inboundReply;
    protected String outboundReply;
    protected boolean finished = true;
    protected boolean committed = false;
    protected Date lastUpdate;

    public RadiusLogEntry() {
    }

    public RadiusLogEntry(JRadiusSession session, String packetId) {
        this.session = session;
        this.setPacketId(packetId);
    }

    public void init(JRadiusRequest request, JRadiusSession session) throws RadiusException {
        InetAddress clientAddress;
        RadiusPacket req = request.getRequestPacket();
        this.setType(request);
        if (this.getClientIPAddress() == null && (clientAddress = (InetAddress)req.getAttributeValue(1052L)) != null) {
            this.setClientIPAddress(clientAddress.getHostAddress());
        }
        if (this.getNasIdentifier() == null) {
            String nasId = (String)req.getAttributeValue(32L);
            this.setNasIdentifier(nasId);
        }
        if (this.getUserName() == null) {
            this.setUserName(session.getUsername());
        }
        if (this.getRealm() == null) {
            this.setRealm(session.getRealm());
        }
        if (this.getInboundRequest() == null) {
            this.setInboundRequest(req.toString(false, true));
        }
    }

    protected Object setValue(Object n, Object o) {
        if (o == null || !o.equals(n)) {
            this.committed = false;
            return n;
        }
        return o;
    }

    public String getSessionKey() {
        return this.session.getSessionKey();
    }

    public Integer getCode() {
        return this.code;
    }

    public void setCode(Integer code) {
        this.code = (Integer)this.setValue(code, this.code);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = (String)this.setValue(type, this.type);
    }

    public void setType(JRadiusRequest request) throws RadiusException {
        block0 : switch (request.getType()) {
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 3: 
            case 4: {
                AccountingRequest req = (AccountingRequest)request.getRequestPacket();
                switch (req.getAccountingStatusType()) {
                    case 1: 
                    case 7: {
                        this.setType("start");
                        break block0;
                    }
                    case 2: 
                    case 8: {
                        this.setType("stop");
                        break block0;
                    }
                    case 3: {
                        this.setType("interim");
                        break block0;
                    }
                }
                this.setType("accounting");
                break;
            }
            default: {
                this.setType(request.getTypeString());
            }
        }
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = (String)this.setValue(message, this.message);
    }

    public void addMessage(String message) {
        StringBuffer sb = new StringBuffer();
        if (this.message != null) {
            sb.append(this.message).append(", ");
        }
        sb.append(message);
        this.setMessage(sb.toString());
    }

    public String getClientIPAddress() {
        return this.clientIPAddress;
    }

    public void setClientIPAddress(String clientIP) {
        this.clientIPAddress = (String)this.setValue(clientIP, this.clientIPAddress);
    }

    public String getNasIdentifier() {
        return this.nasIdentifier;
    }

    public void setNasIdentifier(String nasId) {
        this.nasIdentifier = (String)this.setValue(nasId, this.nasIdentifier);
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public Integer getUserId() {
        return this.userId;
    }

    public void setUserId(Integer userId) {
        this.userId = (Integer)this.setValue(userId, this.userId);
    }

    public String getPacketId() {
        return this.packetId;
    }

    public void setPacketId(String packetId) {
        this.packetId = packetId;
    }

    public String getInboundReply() {
        return this.inboundReply;
    }

    public void setInboundReply(String inboundReply) {
        this.inboundReply = (String)this.setValue(inboundReply, this.inboundReply);
    }

    public String getInboundRequest() {
        return this.inboundRequest;
    }

    public void setInboundRequest(String inboundRequest) {
        this.inboundRequest = (String)this.setValue(inboundRequest, this.inboundRequest);
    }

    public String getOutboundReply() {
        return this.outboundReply;
    }

    public void setOutboundReply(String outboundReply) {
        this.outboundReply = (String)this.setValue(outboundReply, this.outboundReply);
    }

    public String getOutboundRequest() {
        return this.outboundRequest;
    }

    public void setOutboundRequest(String outboundRequest) {
        this.outboundRequest = (String)this.setValue(outboundRequest, this.outboundRequest);
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setFinished(boolean finished) {
        this.finished = finished;
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public void setCommitted(boolean committed) {
        this.committed = committed;
    }

    public String toString() {
        return "RadiusLogEntry: { type = " + this.type + ", packetId = " + this.packetId + " }: " + this.getMessage();
    }

    public Date getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(Date lastUpdate) {
        this.lastUpdate = lastUpdate;
    }
}

