/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.webservice;

import java.io.Serializable;
import java.net.URLDecoder;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import net.jradius.handler.EventHandlerBase;
import net.jradius.log.RadiusLog;
import net.jradius.server.JRadiusEvent;
import net.jradius.session.JRadiusSession;
import net.jradius.session.JRadiusSessionManager;
import net.jradius.util.Base64;
import net.jradius.webservice.WebServiceException;
import net.jradius.webservice.WebServiceRequest;
import net.jradius.webservice.WebServiceResponse;

public class SSOProxyService
extends EventHandlerBase {
    private String defaultURL = "http://jradius.net/";
    private String cipherType = "Blowfish";
    private String cipherKey = "changeme";

    public boolean doesHandle(JRadiusEvent event) {
        WebServiceRequest request = (WebServiceRequest)event;
        String path = request.getUri().getPath();
        return path.startsWith("/sso/");
    }

    public boolean handle(JRadiusEvent event) throws Exception {
        WebServiceRequest request = (WebServiceRequest)event;
        String path = request.getUri().getRawPath();
        RadiusLog.debug((String)("SSO Proxy Request: " + path));
        String[] parts = path.split("/", 3);
        if (parts.length != 3) {
            throw new WebServiceException("invalid request");
        }
        String command = parts[1];
        String payload = parts[2];
        if (!"sso".equals(command)) {
            throw new WebServiceException("invalid command");
        }
        if (payload == null) {
            throw new WebServiceException("invalid security");
        }
        byte[] KeyData = this.cipherKey.getBytes();
        SecretKeySpec KS = new SecretKeySpec(KeyData, this.cipherType);
        Cipher cipher = Cipher.getInstance(this.cipherType);
        cipher.init(2, KS);
        byte[] data = Base64.decode((String)payload);
        byte[] plaintext = cipher.doFinal(data);
        String scommand = URLDecoder.decode(new String(plaintext).trim(), "US-ASCII");
        RadiusLog.debug((String)("Secure command: " + scommand));
        String session = scommand.substring("session=".length());
        JRadiusSession radiusSession = JRadiusSessionManager.getManager((Object)request.getSender()).getSession(null, (Serializable)((Object)session));
        WebServiceResponse response = new WebServiceResponse();
        Map<String, String> headers = response.getHeaders();
        String url = radiusSession.getRedirectURL();
        if (url == null) {
            url = this.defaultURL;
        }
        headers.put("Location", url);
        request.setResponse(response);
        return false;
    }

    public String getCipherKey() {
        return this.cipherKey;
    }

    public void setCipherKey(String cipherKey) {
        this.cipherKey = cipherKey;
    }

    public String getCipherType() {
        return this.cipherType;
    }

    public void setCipherType(String cipherType) {
        this.cipherType = cipherType;
    }

    public String getDefaultURL() {
        return this.defaultURL;
    }

    public void setDefaultURL(String defaultURL) {
        this.defaultURL = defaultURL;
    }
}

