/*
 * Decompiled with CFR 0.152.
 */
package net.jsign;

import java.io.Closeable;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import net.jsign.DigestAlgorithm;
import net.jsign.Signable;
import net.jsign.asn1.authenticode.AuthenticodeDigestCalculatorProvider;
import net.jsign.asn1.authenticode.AuthenticodeObjectIdentifiers;
import net.jsign.asn1.authenticode.AuthenticodeSignedDataGenerator;
import net.jsign.asn1.authenticode.FilteredAttributeTableGenerator;
import net.jsign.asn1.authenticode.SpcSpOpusInfo;
import net.jsign.asn1.authenticode.SpcStatementType;
import net.jsign.msi.MSIFile;
import net.jsign.pe.DataDirectory;
import net.jsign.pe.DataDirectoryType;
import net.jsign.pe.PEFile;
import net.jsign.timestamp.Timestamper;
import net.jsign.timestamp.TimestampingMode;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.cms.CMSAttributeTableGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.DefaultSignedAttributeTableGenerator;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.cms.SignerInfoGeneratorBuilder;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.cms.jcajce.JcaSignerInfoVerifierBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.util.Store;

public class AuthenticodeSigner {
    protected Certificate[] chain;
    protected PrivateKey privateKey;
    protected DigestAlgorithm digestAlgorithm = DigestAlgorithm.getDefault();
    protected String signatureAlgorithm;
    protected Provider signatureProvider;
    protected String programName;
    protected String programURL;
    protected boolean replace;
    protected boolean timestamping = true;
    protected TimestampingMode tsmode = TimestampingMode.AUTHENTICODE;
    protected String[] tsaurlOverride;
    protected Timestamper timestamper;
    protected int timestampingRetries = -1;
    protected int timestampingRetryWait = -1;

    public AuthenticodeSigner(Certificate[] chain, PrivateKey privateKey) {
        this.chain = chain;
        this.privateKey = privateKey;
        if (chain == null || chain.length == 0) {
            throw new IllegalArgumentException("The certificate chain is empty");
        }
    }

    public AuthenticodeSigner(KeyStore keystore, String alias, String password) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException {
        Certificate[] chain = keystore.getCertificateChain(alias);
        if (chain == null) {
            throw new IllegalArgumentException("No certificate found in the keystore with the alias '" + alias + "'");
        }
        this.chain = chain;
        this.privateKey = (PrivateKey)keystore.getKey(alias, password.toCharArray());
    }

    public AuthenticodeSigner withProgramName(String programName) {
        this.programName = programName;
        return this;
    }

    public AuthenticodeSigner withProgramURL(String programURL) {
        this.programURL = programURL;
        return this;
    }

    public AuthenticodeSigner withSignaturesReplaced(boolean replace) {
        this.replace = replace;
        return this;
    }

    public AuthenticodeSigner withTimestamping(boolean timestamping) {
        this.timestamping = timestamping;
        return this;
    }

    public AuthenticodeSigner withTimestampingMode(TimestampingMode tsmode) {
        this.tsmode = tsmode;
        return this;
    }

    public AuthenticodeSigner withTimestampingAuthority(String url) {
        return this.withTimestampingAuthority(new String[]{url});
    }

    public AuthenticodeSigner withTimestampingAuthority(String ... urls) {
        this.tsaurlOverride = urls;
        return this;
    }

    public AuthenticodeSigner withTimestamper(Timestamper timestamper) {
        this.timestamper = timestamper;
        return this;
    }

    public AuthenticodeSigner withTimestampingRetries(int timestampingRetries) {
        this.timestampingRetries = timestampingRetries;
        return this;
    }

    public AuthenticodeSigner withTimestampingRetryWait(int timestampingRetryWait) {
        this.timestampingRetryWait = timestampingRetryWait;
        return this;
    }

    public AuthenticodeSigner withDigestAlgorithm(DigestAlgorithm algorithm) {
        if (algorithm != null) {
            this.digestAlgorithm = algorithm;
        }
        return this;
    }

    public AuthenticodeSigner withSignatureAlgorithm(String signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
        return this;
    }

    public AuthenticodeSigner withSignatureAlgorithm(String signatureAlgorithm, String signatureProvider) {
        return this.withSignatureAlgorithm(signatureAlgorithm, Security.getProvider(signatureProvider));
    }

    public AuthenticodeSigner withSignatureAlgorithm(String signatureAlgorithm, Provider signatureProvider) {
        this.signatureAlgorithm = signatureAlgorithm;
        this.signatureProvider = signatureProvider;
        return this;
    }

    public AuthenticodeSigner withSignatureProvider(Provider signatureProvider) {
        this.signatureProvider = signatureProvider;
        return this;
    }

    public void sign(Signable file) throws Exception {
        List<CMSSignedData> signatures;
        if (file instanceof PEFile) {
            DataDirectory certificateTable;
            PEFile pefile = (PEFile)file;
            pefile.pad(8);
            if (this.replace && (certificateTable = pefile.getDataDirectory(DataDirectoryType.CERTIFICATE_TABLE)) != null && !certificateTable.isTrailing()) {
                certificateTable.erase();
                certificateTable.write(0L, 0);
            }
        } else if (file instanceof MSIFile) {
            MSIFile msi = (MSIFile)file;
            if (!this.replace && msi.hasExtendedSignature()) {
                throw new UnsupportedOperationException("The file has an extended signature which isn't supported by Jsign, it can't be signed without replacing the existing signature");
            }
        }
        CMSSignedData sigData = this.createSignedData(file);
        if (!this.replace && !(signatures = file.getSignatures()).isEmpty()) {
            sigData = this.addNestedSignature(signatures.get(0), sigData);
        }
        file.setSignature(sigData);
        file.save();
        if (file instanceof Closeable) {
            ((Closeable)((Object)file)).close();
        }
    }

    protected CMSSignedData createSignedData(Signable file) throws Exception {
        AuthenticodeSignedDataGenerator generator = this.createSignedDataGenerator();
        CMSSignedData sigData = generator.generate(AuthenticodeObjectIdentifiers.SPC_INDIRECT_DATA_OBJID, (ASN1Encodable)file.createIndirectData(this.digestAlgorithm));
        AuthenticodeDigestCalculatorProvider digestCalculatorProvider = new AuthenticodeDigestCalculatorProvider();
        SignerInformationVerifier verifier = new JcaSignerInfoVerifierBuilder((DigestCalculatorProvider)digestCalculatorProvider).build(this.chain[0].getPublicKey());
        ((SignerInformation)sigData.getSignerInfos().iterator().next()).verify(verifier);
        if (this.timestamping) {
            Timestamper ts = this.timestamper;
            if (ts == null) {
                ts = Timestamper.create(this.tsmode);
            }
            if (this.tsaurlOverride != null) {
                ts.setURLs(this.tsaurlOverride);
            }
            if (this.timestampingRetries != -1) {
                ts.setRetries(this.timestampingRetries);
            }
            if (this.timestampingRetryWait != -1) {
                ts.setRetryWait(this.timestampingRetryWait);
            }
            sigData = ts.timestamp(this.digestAlgorithm, sigData);
        }
        return sigData;
    }

    private AuthenticodeSignedDataGenerator createSignedDataGenerator() throws CMSException, OperatorCreationException, CertificateEncodingException {
        String sigAlg = this.signatureAlgorithm == null ? (Object)((Object)this.digestAlgorithm) + "with" + this.privateKey.getAlgorithm() : this.signatureAlgorithm;
        JcaContentSignerBuilder contentSignerBuilder = new JcaContentSignerBuilder(sigAlg);
        if (this.signatureProvider != null) {
            contentSignerBuilder.setProvider(this.signatureProvider);
        }
        ContentSigner shaSigner = contentSignerBuilder.build(this.privateKey);
        AuthenticodeDigestCalculatorProvider digestCalculatorProvider = new AuthenticodeDigestCalculatorProvider();
        Object attributeTableGenerator = new DefaultSignedAttributeTableGenerator(this.createAuthenticatedAttributes());
        attributeTableGenerator = new FilteredAttributeTableGenerator((CMSAttributeTableGenerator)attributeTableGenerator, CMSAttributes.signingTime);
        JcaX509CertificateHolder certificate = new JcaX509CertificateHolder((X509Certificate)this.chain[0]);
        SignerInfoGeneratorBuilder signerInfoGeneratorBuilder = new SignerInfoGeneratorBuilder((DigestCalculatorProvider)digestCalculatorProvider);
        signerInfoGeneratorBuilder.setSignedAttributeGenerator((CMSAttributeTableGenerator)attributeTableGenerator);
        SignerInfoGenerator signerInfoGenerator = signerInfoGeneratorBuilder.build(shaSigner, (X509CertificateHolder)certificate);
        AuthenticodeSignedDataGenerator generator = new AuthenticodeSignedDataGenerator();
        generator.addCertificates((Store)new JcaCertStore(this.removeRoot(this.chain)));
        generator.addSignerInfoGenerator(signerInfoGenerator);
        return generator;
    }

    private List<Certificate> removeRoot(Certificate[] certificates) {
        ArrayList<Certificate> list = new ArrayList<Certificate>();
        if (certificates.length == 1) {
            list.add(certificates[0]);
        } else {
            for (Certificate certificate : certificates) {
                if (this.isSelfSigned((X509Certificate)certificate)) continue;
                list.add(certificate);
            }
        }
        return list;
    }

    private boolean isSelfSigned(X509Certificate certificate) {
        return certificate.getSubjectDN().equals(certificate.getIssuerDN());
    }

    private AttributeTable createAuthenticatedAttributes() {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        SpcStatementType spcStatementType = new SpcStatementType(AuthenticodeObjectIdentifiers.SPC_INDIVIDUAL_SP_KEY_PURPOSE_OBJID);
        attributes.add(new Attribute(AuthenticodeObjectIdentifiers.SPC_STATEMENT_TYPE_OBJID, (ASN1Set)new DERSet((ASN1Encodable)spcStatementType)));
        SpcSpOpusInfo spcSpOpusInfo = new SpcSpOpusInfo(this.programName, this.programURL);
        attributes.add(new Attribute(AuthenticodeObjectIdentifiers.SPC_SP_OPUS_INFO_OBJID, (ASN1Set)new DERSet((ASN1Encodable)spcSpOpusInfo)));
        return new AttributeTable((ASN1Set)new DERSet(attributes.toArray(new ASN1Encodable[0])));
    }

    protected CMSSignedData addNestedSignature(CMSSignedData primary, CMSSignedData secondary) {
        Attribute nestedSignaturesAttribute;
        SignerInformation signerInformation = (SignerInformation)primary.getSignerInfos().getSigners().iterator().next();
        AttributeTable unsignedAttributes = signerInformation.getUnsignedAttributes();
        if (unsignedAttributes == null) {
            unsignedAttributes = new AttributeTable((ASN1Set)new DERSet());
        }
        if ((nestedSignaturesAttribute = unsignedAttributes.get(AuthenticodeObjectIdentifiers.SPC_NESTED_SIGNATURE_OBJID)) == null) {
            unsignedAttributes = unsignedAttributes.add(AuthenticodeObjectIdentifiers.SPC_NESTED_SIGNATURE_OBJID, (ASN1Encodable)secondary.toASN1Structure());
        } else {
            ASN1EncodableVector nestedSignatures = new ASN1EncodableVector();
            for (ASN1Encodable nestedSignature : nestedSignaturesAttribute.getAttrValues()) {
                nestedSignatures.add(nestedSignature);
            }
            nestedSignatures.add((ASN1Encodable)secondary.toASN1Structure());
            ASN1EncodableVector attributes = unsignedAttributes.remove(AuthenticodeObjectIdentifiers.SPC_NESTED_SIGNATURE_OBJID).toASN1EncodableVector();
            attributes.add((ASN1Encodable)new Attribute(AuthenticodeObjectIdentifiers.SPC_NESTED_SIGNATURE_OBJID, (ASN1Set)new DERSet(nestedSignatures)));
            unsignedAttributes = new AttributeTable(attributes);
        }
        signerInformation = SignerInformation.replaceUnsignedAttributes((SignerInformation)signerInformation, (AttributeTable)unsignedAttributes);
        return CMSSignedData.replaceSigners((CMSSignedData)primary, (SignerInformationStore)new SignerInformationStore(signerInformation));
    }
}

