/*
 * Decompiled with CFR 0.152.
 */
package net.jsign;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Provider;

public class KeyStoreUtils {
    private KeyStoreUtils() {
    }

    public static KeyStore load(File keystore, String storetype, String storepass, Provider provider) throws KeyStoreException {
        return KeyStoreUtils.load(keystore != null ? keystore.getPath() : null, storetype, storepass, provider);
    }

    public static KeyStore load(String keystore, String storetype, String storepass, Provider provider) throws KeyStoreException {
        boolean filebased;
        KeyStore ks;
        if (keystore != null && storetype == null) {
            storetype = KeyStoreUtils.getType(keystore);
        }
        try {
            ks = provider != null ? KeyStore.getInstance(storetype, provider) : KeyStore.getInstance(storetype);
        }
        catch (KeyStoreException e) {
            throw new KeyStoreException("keystore type '" + storetype + "' is not supported", e);
        }
        boolean bl = filebased = "JKS".equals(storetype) || "JCEKS".equals(storetype) || "PKCS12".equals(storetype);
        if (filebased && (keystore == null || !new File(keystore).exists())) {
            throw new KeyStoreException("The keystore " + keystore + " couldn't be found");
        }
        try (FileInputStream in = !filebased ? null : new FileInputStream(keystore);){
            ks.load(in, storepass != null ? storepass.toCharArray() : null);
        }
        catch (Exception e) {
            throw new KeyStoreException("Unable to load the keystore " + keystore, e);
        }
        return ks;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String getType(String keystore) throws KeyStoreException {
        String filename;
        if (keystore == null) {
            return null;
        }
        File file = new File(keystore);
        if (file.exists()) {
            try (FileInputStream in = new FileInputStream(file);){
                byte[] header = new byte[4];
                in.read(header);
                ByteBuffer buffer = ByteBuffer.wrap(header);
                if (buffer.get(0) == 48) {
                    String string = "PKCS12";
                    return string;
                }
                if (((long)buffer.getInt(0) & 0xFFFFFFFFL) == 0xCECECECEL) {
                    String string = "JCEKS";
                    return string;
                }
                if (((long)buffer.getInt(0) & 0xFFFFFFFFL) == 0xFEEDFEEDL) {
                    String string = "JKS";
                    return string;
                }
            }
            catch (IOException e) {
                throw new KeyStoreException("Unable to load the keystore " + keystore, e);
            }
        }
        if ((filename = keystore.toLowerCase()).endsWith(".p12")) return "PKCS12";
        if (filename.endsWith(".pfx")) {
            return "PKCS12";
        }
        if (filename.endsWith(".jceks")) {
            return "JCEKS";
        }
        if (!filename.endsWith(".jks")) return null;
        return "JKS";
    }
}

