/*
 * Decompiled with CFR 0.152.
 */
package net.jsign;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import net.jsign.AuthenticodeSigner;
import net.jsign.Console;
import net.jsign.DigestAlgorithm;
import net.jsign.KeyStoreUtils;
import net.jsign.PrivateKeyUtils;
import net.jsign.ProviderUtils;
import net.jsign.Signable;
import net.jsign.SignerException;
import net.jsign.YubiKey;
import net.jsign.jca.AzureKeyVaultSigningService;
import net.jsign.jca.DigiCertOneSigningService;
import net.jsign.jca.ESignerSigningService;
import net.jsign.jca.GoogleCloudSigningService;
import net.jsign.jca.SigningServiceJcaProvider;
import net.jsign.timestamp.TimestampingMode;
import org.apache.commons.io.FileUtils;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSSignedData;

class SignerHelper {
    public static final String PARAM_KEYSTORE = "keystore";
    public static final String PARAM_STOREPASS = "storepass";
    public static final String PARAM_STORETYPE = "storetype";
    public static final String PARAM_ALIAS = "alias";
    public static final String PARAM_KEYPASS = "keypass";
    public static final String PARAM_KEYFILE = "keyfile";
    public static final String PARAM_CERTFILE = "certfile";
    public static final String PARAM_ALG = "alg";
    public static final String PARAM_TSAURL = "tsaurl";
    public static final String PARAM_TSMODE = "tsmode";
    public static final String PARAM_TSRETRIES = "tsretries";
    public static final String PARAM_TSRETRY_WAIT = "tsretrywait";
    public static final String PARAM_NAME = "name";
    public static final String PARAM_URL = "url";
    public static final String PARAM_PROXY_URL = "proxyUrl";
    public static final String PARAM_PROXY_USER = "proxyUser";
    public static final String PARAM_PROXY_PASS = "proxyPass";
    public static final String PARAM_REPLACE = "replace";
    public static final String PARAM_ENCODING = "encoding";
    public static final String PARAM_DETACHED = "detached";
    private final Console console;
    private final String parameterName;
    private String keystore;
    private String storepass;
    private String storetype;
    private String alias;
    private String keypass;
    private File keyfile;
    private File certfile;
    private String tsaurl;
    private String tsmode;
    private int tsretries = -1;
    private int tsretrywait = -1;
    private String alg;
    private String name;
    private String url;
    private String proxyUrl;
    private String proxyUser;
    private String proxyPass;
    private boolean replace;
    private Charset encoding;
    private boolean detached;
    private AuthenticodeSigner signer;

    public SignerHelper(Console console, String parameterName) {
        this.console = console;
        this.parameterName = parameterName;
    }

    public SignerHelper keystore(String keystore) {
        this.keystore = keystore;
        return this;
    }

    public SignerHelper keystore(File keystore) {
        this.keystore = keystore != null ? keystore.getPath() : null;
        return this;
    }

    public SignerHelper storepass(String storepass) {
        this.storepass = storepass;
        return this;
    }

    public SignerHelper storetype(String storetype) {
        this.storetype = storetype;
        return this;
    }

    public SignerHelper alias(String alias) {
        this.alias = alias;
        return this;
    }

    public SignerHelper keypass(String keypass) {
        this.keypass = keypass;
        return this;
    }

    public SignerHelper keyfile(String keyfile) {
        this.keyfile(this.createFile(keyfile));
        return this;
    }

    public SignerHelper keyfile(File keyfile) {
        this.keyfile = keyfile;
        return this;
    }

    public SignerHelper certfile(String certfile) {
        this.certfile(this.createFile(certfile));
        return this;
    }

    public SignerHelper certfile(File certfile) {
        this.certfile = certfile;
        return this;
    }

    public SignerHelper alg(String alg) {
        this.alg = alg;
        return this;
    }

    public SignerHelper tsaurl(String tsaurl) {
        this.tsaurl = tsaurl;
        return this;
    }

    public SignerHelper tsmode(String tsmode) {
        this.tsmode = tsmode;
        return this;
    }

    public SignerHelper tsretries(int tsretries) {
        this.tsretries = tsretries;
        return this;
    }

    public SignerHelper tsretrywait(int tsretrywait) {
        this.tsretrywait = tsretrywait;
        return this;
    }

    public SignerHelper name(String name) {
        this.name = name;
        return this;
    }

    public SignerHelper url(String url) {
        this.url = url;
        return this;
    }

    public SignerHelper proxyUrl(String proxyUrl) {
        this.proxyUrl = proxyUrl;
        return this;
    }

    public SignerHelper proxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
        return this;
    }

    public SignerHelper proxyPass(String proxyPass) {
        this.proxyPass = proxyPass;
        return this;
    }

    public SignerHelper replace(boolean replace) {
        this.replace = replace;
        return this;
    }

    public SignerHelper encoding(String encoding) {
        this.encoding = Charset.forName(encoding);
        return this;
    }

    public SignerHelper detached(boolean detached) {
        this.detached = detached;
        return this;
    }

    public SignerHelper param(String key, String value) {
        if (value == null) {
            return this;
        }
        switch (key) {
            case "keystore": {
                return this.keystore(value);
            }
            case "storepass": {
                return this.storepass(value);
            }
            case "storetype": {
                return this.storetype(value);
            }
            case "alias": {
                return this.alias(value);
            }
            case "keypass": {
                return this.keypass(value);
            }
            case "keyfile": {
                return this.keyfile(value);
            }
            case "certfile": {
                return this.certfile(value);
            }
            case "alg": {
                return this.alg(value);
            }
            case "tsaurl": {
                return this.tsaurl(value);
            }
            case "tsmode": {
                return this.tsmode(value);
            }
            case "tsretries": {
                return this.tsretries(Integer.parseInt(value));
            }
            case "tsretrywait": {
                return this.tsretrywait(Integer.parseInt(value));
            }
            case "name": {
                return this.name(value);
            }
            case "url": {
                return this.url(value);
            }
            case "proxyUrl": {
                return this.proxyUrl(value);
            }
            case "proxyUser": {
                return this.proxyUser(value);
            }
            case "proxyPass": {
                return this.proxyPass(value);
            }
            case "replace": {
                return this.replace("true".equalsIgnoreCase(value));
            }
            case "encoding": {
                return this.encoding(value);
            }
            case "detached": {
                return this.detached("true".equalsIgnoreCase(value));
            }
        }
        throw new IllegalArgumentException("Unknown " + this.parameterName + ": " + key);
    }

    private File createFile(String file) {
        return file == null ? null : new File(file);
    }

    private String readPassword(String name, String value) throws SignerException {
        if (value != null) {
            if (value.startsWith("file:")) {
                String filename = value.substring("file:".length());
                Path path = new File(filename).toPath();
                try {
                    value = String.join((CharSequence)"\n", Files.readAllLines(path, StandardCharsets.UTF_8)).trim();
                }
                catch (IOException e) {
                    throw new SignerException("Failed to read the " + name + " " + this.parameterName + " from the file '" + filename + "'", e);
                }
            } else if (value.startsWith("env:")) {
                String variable = value.substring("env:".length());
                if (!System.getenv().containsKey(variable)) {
                    throw new SignerException("Failed to read the " + name + " " + this.parameterName + ", the '" + variable + "' environment variable is not defined");
                }
                value = System.getenv(variable);
            }
        }
        return value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private AuthenticodeSigner build() throws SignerException {
        PrivateKey privateKey;
        Certificate[] chain;
        String[] elements;
        String storepass = this.readPassword(PARAM_STOREPASS, this.storepass);
        String keypass = this.readPassword(PARAM_KEYPASS, this.keypass);
        if (!(this.keystore != null || this.keyfile != null || this.certfile != null || "YUBIKEY".equals(this.storetype) || "DIGICERTONE".equals(this.storetype) || "ESIGNER".equals(this.storetype))) {
            throw new SignerException("keystore " + this.parameterName + ", or keyfile and certfile " + this.parameterName + "s must be set");
        }
        if (this.keystore != null && this.keyfile != null) {
            throw new SignerException("keystore " + this.parameterName + " can't be mixed with keyfile");
        }
        if ("AZUREKEYVAULT".equals(this.storetype)) {
            if (this.keystore == null) {
                throw new SignerException("keystore " + this.parameterName + " must specify the Azure vault name");
            }
            if (storepass == null) {
                throw new SignerException("storepass " + this.parameterName + " must specify the Azure API access token");
            }
        } else if ("DIGICERTONE".equals(this.storetype)) {
            if (storepass == null || storepass.split("\\|").length != 3) {
                throw new SignerException("storepass " + this.parameterName + " must specify the DigiCert ONE API key and the client certificate: <apikey>|<keystore>|<password>");
            }
        } else if ("GOOGLECLOUD".equals(this.storetype)) {
            if (this.keystore == null) {
                throw new SignerException("keystore " + this.parameterName + " must specify the Goole Cloud keyring");
            }
            if (storepass == null) {
                throw new SignerException("storepass " + this.parameterName + " must specify the Goole Cloud API access token");
            }
            if (this.certfile == null) {
                throw new SignerException("certfile " + this.parameterName + " must be set");
            }
        } else if ("ESIGNER".equals(this.storetype) && (storepass == null || !storepass.contains("|"))) {
            throw new SignerException("storepass " + this.parameterName + " must specify the SSL.com username and password: <username>|<password>");
        }
        Provider provider = null;
        if ("PKCS11".equals(this.storetype)) {
            if (this.keystore != null && new File(this.keystore).exists()) {
                provider = ProviderUtils.createSunPKCS11Provider(this.keystore);
            } else {
                if (this.keystore == null || !this.keystore.startsWith("SunPKCS11-")) throw new SignerException("keystore " + this.parameterName + " should either refer to the SunPKCS11 configuration file or to the name of the provider configured in jre/lib/security/java.security");
                provider = Security.getProvider(this.keystore);
                if (provider == null) {
                    throw new SignerException("Security provider " + this.keystore + " not found");
                }
            }
        } else if ("YUBIKEY".equals(this.storetype)) {
            provider = YubiKey.getProvider();
        } else if ("AZUREKEYVAULT".equals(this.storetype)) {
            provider = new SigningServiceJcaProvider(new AzureKeyVaultSigningService(this.keystore, storepass));
        } else if ("DIGICERTONE".equals(this.storetype)) {
            elements = storepass.split("\\|");
            provider = new SigningServiceJcaProvider(new DigiCertOneSigningService(elements[0], new File(elements[1]), elements[2]));
        } else if ("GOOGLECLOUD".equals(this.storetype)) {
            provider = new SigningServiceJcaProvider(new GoogleCloudSigningService(this.keystore, storepass, alias -> {
                try {
                    return this.loadCertificateChain(this.certfile);
                }
                catch (IOException | CertificateException e) {
                    throw new RuntimeException("Failed to load the certificate from " + this.certfile, e);
                }
            }));
        } else if ("ESIGNER".equals(this.storetype)) {
            elements = storepass.split("\\|", 2);
            String endpoint = this.keystore != null ? this.keystore : "https://cs.ssl.com";
            try {
                provider = new SigningServiceJcaProvider(new ESignerSigningService(endpoint, elements[0], elements[1]));
            }
            catch (IOException e) {
                throw new SignerException("Authentication failed with SSL.com", e);
            }
        }
        if (this.keystore != null || "YUBIKEY".equals(this.storetype) || "DIGICERTONE".equals(this.storetype)) {
            char[] password;
            KeyStore ks;
            try {
                ks = KeyStoreUtils.load(this.keystore, "YUBIKEY".equals(this.storetype) ? "PKCS11" : this.storetype, storepass, provider);
            }
            catch (KeyStoreException e) {
                throw new SignerException("Failed to load the keystore " + this.keystore, e);
            }
            LinkedHashSet<String> aliases = null;
            if (this.alias == null) {
                if ("YUBIKEY".equals(this.storetype)) {
                    this.alias = "X.509 Certificate for Digital Signature";
                } else {
                    try {
                        aliases = new LinkedHashSet<String>(Collections.list(ks.aliases()));
                    }
                    catch (KeyStoreException e) {
                        throw new SignerException(e.getMessage(), e);
                    }
                    if (aliases.isEmpty()) {
                        throw new SignerException("No certificate found in the keystore " + (provider != null ? provider.getName() : this.keystore));
                    }
                    if (aliases.size() != 1) throw new SignerException("alias " + this.parameterName + " must be set to select a certificate (available aliases: " + String.join((CharSequence)", ", aliases) + ")");
                    this.alias = (String)aliases.iterator().next();
                }
            }
            try {
                chain = ks.getCertificateChain(this.alias);
            }
            catch (KeyStoreException e) {
                throw new SignerException(e.getMessage(), e);
            }
            if (chain == null) {
                String message = "No certificate found under the alias '" + this.alias + "' in the keystore " + (provider != null ? provider.getName() : this.keystore);
                if (aliases != null) throw new SignerException(message);
                try {
                    aliases = new LinkedHashSet<String>(Collections.list(ks.aliases()));
                    message = aliases.isEmpty() ? "No certificate found in the keystore " + (provider != null ? provider.getName() : this.keystore) : message + " (available aliases: " + String.join((CharSequence)", ", aliases) + ")";
                    throw new SignerException(message);
                }
                catch (KeyStoreException e) {
                    message = message + " (couldn't load the list of available aliases: " + e.getMessage() + ")";
                }
                throw new SignerException(message);
            }
            if (this.certfile != null && !"GOOGLECLOUD".equals(this.storetype) && !"ESIGNER".equals(this.storetype)) {
                if (chain.length != 1) {
                    throw new SignerException("certfile " + this.parameterName + " can only be specified if the certificate from the keystore contains only one entry");
                }
                try {
                    Certificate[] chainFromFile = this.loadCertificateChain(this.certfile);
                    if (!chainFromFile[0].equals(chain[0])) {
                        throw new SignerException("The certificate chain in " + this.certfile + " does not match the chain from the keystore");
                    }
                    chain = chainFromFile;
                }
                catch (SignerException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new SignerException("Failed to load the certificate from " + this.certfile, e);
                }
            }
            char[] cArray = password = keypass != null ? keypass.toCharArray() : null;
            if (password == null && storepass != null && !"ESIGNER".equals(this.storetype)) {
                password = storepass.toCharArray();
            }
            try {
                privateKey = (PrivateKey)ks.getKey(this.alias, password);
            }
            catch (Exception e) {
                throw new SignerException("Failed to retrieve the private key from the keystore", e);
            }
        }
        if (this.keyfile == null) {
            throw new SignerException("keyfile " + this.parameterName + " must be set");
        }
        if (!this.keyfile.exists()) {
            throw new SignerException("The keyfile " + this.keyfile + " couldn't be found");
        }
        if (this.certfile == null) {
            throw new SignerException("certfile " + this.parameterName + " must be set");
        }
        if (!this.certfile.exists()) {
            throw new SignerException("The certfile " + this.certfile + " couldn't be found");
        }
        try {
            chain = this.loadCertificateChain(this.certfile);
        }
        catch (Exception e) {
            throw new SignerException("Failed to load the certificate from " + this.certfile, e);
        }
        try {
            privateKey = PrivateKeyUtils.load(this.keyfile, keypass != null ? keypass : storepass);
        }
        catch (Exception e) {
            throw new SignerException("Failed to load the private key from " + this.keyfile, e);
        }
        if (this.alg != null && DigestAlgorithm.of(this.alg) == null) {
            throw new SignerException("The digest algorithm " + this.alg + " is not supported");
        }
        try {
            this.initializeProxy(this.proxyUrl, this.proxyUser, this.proxyPass);
            return new AuthenticodeSigner(chain, privateKey).withProgramName(this.name).withProgramURL(this.url).withDigestAlgorithm(DigestAlgorithm.of(this.alg)).withSignatureProvider(provider).withSignaturesReplaced(this.replace).withTimestamping(this.tsaurl != null || this.tsmode != null).withTimestampingMode(this.tsmode != null ? TimestampingMode.of(this.tsmode) : TimestampingMode.AUTHENTICODE).withTimestampingRetries(this.tsretries).withTimestampingRetryWait(this.tsretrywait).withTimestampingAuthority(this.tsaurl != null ? this.tsaurl.split(",") : null);
        }
        catch (Exception e) {
            throw new SignerException("Couldn't initialize proxy", e);
        }
    }

    public void sign(File file) throws SignerException {
        Signable signable;
        if (file == null) {
            throw new SignerException("file must be set");
        }
        if (!file.exists()) {
            throw new SignerException("The file " + file + " couldn't be found");
        }
        try {
            signable = Signable.of(file, this.encoding);
        }
        catch (UnsupportedOperationException e) {
            throw new SignerException(e.getMessage());
        }
        catch (IOException e) {
            throw new SignerException("Couldn't open the file " + file, e);
        }
        if (this.detached && this.getDetachedSignature(file).exists()) {
            try {
                if (this.console != null) {
                    this.console.info("Attaching Authenticode signature to " + file);
                }
                this.attach(file);
                return;
            }
            catch (Exception e) {
                throw new SignerException("Couldn't attach the signature to " + file, e);
            }
            finally {
                try {
                    if (signable instanceof Closeable) {
                        ((Closeable)((Object)signable)).close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        try {
            if (this.signer == null) {
                this.signer = this.build();
            }
            if (this.console != null) {
                this.console.info("Adding Authenticode signature to " + file);
            }
            this.signer.sign(signable);
            if (this.detached) {
                this.detach(file);
            }
        }
        catch (SignerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SignerException("Couldn't sign " + file, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attach(File file) throws IOException, CMSException {
        File detachedSignature = this.getDetachedSignature(file);
        byte[] signatureBytes = FileUtils.readFileToByteArray((File)detachedSignature);
        CMSSignedData signedData = new CMSSignedData((CMSProcessable)null, ContentInfo.getInstance((Object)new ASN1InputStream(signatureBytes).readObject()));
        Signable signable = Signable.of(file, this.encoding);
        try {
            signable.setSignature(signedData);
            signable.save();
        }
        finally {
            if (signable instanceof Closeable) {
                ((Closeable)((Object)signable)).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void detach(File file) throws IOException {
        Signable signable = Signable.of(file, this.encoding);
        try {
            CMSSignedData signedData = signable.getSignatures().get(0);
            File detachedSignature = this.getDetachedSignature(file);
            byte[] content = signedData.toASN1Structure().getEncoded("DER");
            FileUtils.writeByteArrayToFile((File)detachedSignature, (byte[])content);
        }
        finally {
            if (signable instanceof Closeable) {
                ((Closeable)((Object)signable)).close();
            }
        }
    }

    private File getDetachedSignature(File file) {
        return new File(file.getParentFile(), file.getName() + ".sig");
    }

    private Certificate[] loadCertificateChain(File file) throws IOException, CertificateException {
        try (FileInputStream in = new FileInputStream(file);){
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            Collection<? extends Certificate> certificates = certificateFactory.generateCertificates(in);
            Certificate[] certificateArray = certificates.toArray(new Certificate[0]);
            return certificateArray;
        }
    }

    private void initializeProxy(String proxyUrl, final String proxyUser, final String proxyPassword) throws MalformedURLException {
        if (proxyUrl != null && proxyUrl.trim().length() > 0) {
            URL url;
            if (!proxyUrl.trim().startsWith("http")) {
                proxyUrl = "http://" + proxyUrl.trim();
            }
            final int port = (url = new URL(proxyUrl)).getPort() < 0 ? 80 : url.getPort();
            ProxySelector.setDefault(new ProxySelector(){

                @Override
                public List<Proxy> select(URI uri) {
                    Proxy proxy = uri.getScheme().equals("socket") ? new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(url.getHost(), port)) : new Proxy(Proxy.Type.HTTP, new InetSocketAddress(url.getHost(), port));
                    if (SignerHelper.this.console != null) {
                        SignerHelper.this.console.debug("Proxy selected for " + uri + " : " + proxy);
                    }
                    return Collections.singletonList(proxy);
                }

                @Override
                public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
                }
            });
            if (proxyUser != null && proxyUser.length() > 0 && proxyPassword != null) {
                Authenticator.setDefault(new Authenticator(){

                    @Override
                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(proxyUser, proxyPassword.toCharArray());
                    }
                });
            }
        }
    }
}

