/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.asn1.authenticode;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;

public class AuthenticodeDigestCalculatorProvider
implements DigestCalculatorProvider {
    public DigestCalculator get(final AlgorithmIdentifier digestAlgorithmIdentifier) throws OperatorCreationException {
        final DigestCalculator delegate = new JcaDigestCalculatorProviderBuilder().build().get(digestAlgorithmIdentifier);
        return new DigestCalculator(){
            private final ByteArrayOutputStream out = new ByteArrayOutputStream();

            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return digestAlgorithmIdentifier;
            }

            public OutputStream getOutputStream() {
                return this.out;
            }

            public byte[] getDigest() {
                try {
                    ASN1InputStream in = new ASN1InputStream(this.out.toByteArray());
                    ASN1Sequence sequence = (ASN1Sequence)in.readObject();
                    for (ASN1Encodable element : sequence) {
                        delegate.getOutputStream().write(element.toASN1Primitive().getEncoded());
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return delegate.getDigest();
            }
        };
    }
}

