/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.jca;

import java.security.AccessController;
import java.security.Provider;
import java.util.Collections;
import net.jsign.DigestAlgorithm;
import net.jsign.jca.SigningService;
import net.jsign.jca.SigningServiceKeyStore;
import net.jsign.jca.SigningServiceSignature;

public class SigningServiceJcaProvider
extends Provider {
    private final SigningService service;

    public SigningServiceJcaProvider(SigningService service) {
        super(service.getName(), 1.0, service.getName() + " signing service provider");
        this.service = service;
        AccessController.doPrivileged(() -> {
            this.putService(new KeyStoreProviderService());
            for (String alg : new String[]{"RSA", "ECDSA"}) {
                for (DigestAlgorithm digest : DigestAlgorithm.values()) {
                    if (digest == DigestAlgorithm.MD5) continue;
                    this.putService(new SignatureProviderService(digest.name() + "with" + alg));
                }
            }
            return null;
        });
    }

    private class SignatureProviderService
    extends Provider.Service {
        private final String signingAlgorithm;

        public SignatureProviderService(String signingAlgorithm) {
            super(SigningServiceJcaProvider.this, "Signature", signingAlgorithm, SigningServiceSignature.class.getName(), Collections.emptyList(), Collections.emptyMap());
            this.signingAlgorithm = signingAlgorithm;
        }

        @Override
        public Object newInstance(Object constructorParameter) {
            return new SigningServiceSignature(SigningServiceJcaProvider.this.service, this.signingAlgorithm);
        }
    }

    private class KeyStoreProviderService
    extends Provider.Service {
        public KeyStoreProviderService() {
            super(SigningServiceJcaProvider.this, "KeyStore", SigningServiceJcaProvider.this.service.getName().toUpperCase(), SigningServiceKeyStore.class.getName(), Collections.emptyList(), null);
        }

        @Override
        public Object newInstance(Object constructorParameter) {
            return new SigningServiceKeyStore(SigningServiceJcaProvider.this.service);
        }
    }
}

