/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.msi;

import java.io.ByteArrayOutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

class MSIStreamName
implements Comparable<MSIStreamName> {
    private static final char[] ALPHABET = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz._".toCharArray();
    private static final byte MASK = 63;
    private final String name;
    private final byte[] nameUTF16;

    public MSIStreamName(String name) {
        this.name = name;
        this.nameUTF16 = name.getBytes(StandardCharsets.UTF_16LE);
    }

    public String decode() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        for (char c : this.name.toCharArray()) {
            if (c >= '\u3800' && c < '\u4840') {
                if (c < '\u4800') {
                    c = (char)(c - 14336);
                    out.write(ALPHABET[c & 0x3F]);
                    out.write(ALPHABET[c >> 6 & 0x3F]);
                    continue;
                }
                out.write(ALPHABET[c - 18432]);
                continue;
            }
            out.write(c);
        }
        return new String(out.toByteArray(), Charset.forName("UTF-8"));
    }

    public String toString() {
        return this.decode();
    }

    @Override
    public int compareTo(MSIStreamName other) {
        byte[] a = this.nameUTF16;
        byte[] b = other.nameUTF16;
        int size = Math.min(a.length, b.length);
        for (int i = 0; i < size; ++i) {
            if (a[i] == b[i]) continue;
            return (a[i] & 0xFF) - (b[i] & 0xFF);
        }
        return a.length - b.length;
    }
}

