/*
 * Decompiled with CFR 0.152.
 */
package net.jsign;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.UnknownServiceException;
import java.nio.ByteBuffer;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Function;
import javax.smartcardio.CardException;
import net.jsign.CertificateUtils;
import net.jsign.KeyStoreBuilder;
import net.jsign.OpenSC;
import net.jsign.PrivateKeyUtils;
import net.jsign.ProviderUtils;
import net.jsign.YubiKey;
import net.jsign.jca.AmazonCredentials;
import net.jsign.jca.AmazonSigningService;
import net.jsign.jca.AzureKeyVaultSigningService;
import net.jsign.jca.DigiCertOneSigningService;
import net.jsign.jca.ESignerSigningService;
import net.jsign.jca.GoogleCloudSigningService;
import net.jsign.jca.HashiCorpVaultSigningService;
import net.jsign.jca.OpenPGPCardSigningService;
import net.jsign.jca.SigningServiceJcaProvider;

public enum KeyStoreType {
    NONE(true, false, false){

        @Override
        void validate(KeyStoreBuilder params) {
            if (params.keyfile() == null) {
                throw new IllegalArgumentException("keyfile " + params.parameterName() + " must be set");
            }
            if (!params.keyfile().exists()) {
                throw new IllegalArgumentException("The keyfile " + params.keyfile() + " couldn't be found");
            }
            if (params.certfile() == null) {
                throw new IllegalArgumentException("certfile " + params.parameterName() + " must be set");
            }
            if (!params.certfile().exists()) {
                throw new IllegalArgumentException("The certfile " + params.certfile() + " couldn't be found");
            }
        }

        @Override
        KeyStore getKeystore(KeyStoreBuilder params, Provider provider) throws KeyStoreException {
            PrivateKey privateKey;
            Certificate[] chain;
            try {
                chain = CertificateUtils.loadCertificateChain(params.certfile());
            }
            catch (Exception e) {
                throw new KeyStoreException("Failed to load the certificate from " + params.certfile(), e);
            }
            try {
                privateKey = PrivateKeyUtils.load(params.keyfile(), params.keypass() != null ? params.keypass() : params.storepass());
            }
            catch (Exception e) {
                throw new KeyStoreException("Failed to load the private key from " + params.keyfile(), e);
            }
            KeyStore ks = KeyStore.getInstance("JKS");
            try {
                ks.load(null, null);
                String keypass = params.keypass();
                if (keypass == null) {
                    keypass = params.storepass();
                }
                ks.setKeyEntry("jsign", privateKey, keypass != null ? keypass.toCharArray() : new char[]{}, chain);
            }
            catch (Exception e) {
                throw new KeyStoreException(e);
            }
            return ks;
        }
    }
    ,
    JKS(true, true, false){

        @Override
        void validate(KeyStoreBuilder params) {
            if (params.keystore() == null) {
                throw new IllegalArgumentException("keystore " + params.parameterName() + " must be set");
            }
        }
    }
    ,
    JCEKS(true, true, false){

        @Override
        void validate(KeyStoreBuilder params) {
            if (params.keystore() == null) {
                throw new IllegalArgumentException("keystore " + params.parameterName() + " must be set");
            }
        }
    }
    ,
    PKCS12(true, true, false){

        @Override
        void validate(KeyStoreBuilder params) {
            if (params.keystore() == null) {
                throw new IllegalArgumentException("keystore " + params.parameterName() + " must be set");
            }
        }
    }
    ,
    PKCS11(false, true, true){

        @Override
        void validate(KeyStoreBuilder params) {
            if (params.keystore() == null) {
                throw new IllegalArgumentException("keystore " + params.parameterName() + " must be set");
            }
        }

        @Override
        Provider getProvider(KeyStoreBuilder params) {
            if (params.createFile(params.keystore()).exists()) {
                return ProviderUtils.createSunPKCS11Provider(params.keystore());
            }
            if (params.keystore().startsWith("SunPKCS11-")) {
                Provider provider = Security.getProvider(params.keystore());
                if (provider == null) {
                    throw new IllegalArgumentException("Security provider " + params.keystore() + " not found");
                }
                return provider;
            }
            throw new IllegalArgumentException("keystore " + params.parameterName() + " should either refer to the SunPKCS11 configuration file or to the name of the provider configured in jre/lib/security/java.security");
        }
    }
    ,
    OPENPGP(false, false, false){

        @Override
        void validate(KeyStoreBuilder params) {
            if (params.storepass() == null) {
                throw new IllegalArgumentException("storepass " + params.parameterName() + " must specify the PIN");
            }
        }

        @Override
        Provider getProvider(KeyStoreBuilder params) {
            try {
                Function<String, Certificate[]> certificateStore = alias -> {
                    try {
                        return CertificateUtils.loadCertificateChain(params.certfile());
                    }
                    catch (IOException | CertificateException e) {
                        throw new RuntimeException("Failed to load the certificate from " + params.certfile(), e);
                    }
                };
                return new SigningServiceJcaProvider(new OpenPGPCardSigningService(params.storepass(), params.certfile() != null ? certificateStore : null));
            }
            catch (CardException e) {
                throw new IllegalStateException("Failed to initialize the OpenPGP card", e);
            }
        }
    }
    ,
    OPENSC(false, true, true){

        @Override
        Provider getProvider(KeyStoreBuilder params) {
            return OpenSC.getProvider(params.keystore());
        }
    }
    ,
    NITROKEY(false, true, true){

        @Override
        Provider getProvider(KeyStoreBuilder params) {
            return OpenSC.getProvider(params.keystore() != null ? params.keystore() : "Nitrokey");
        }
    }
    ,
    YUBIKEY(false, true, true){

        @Override
        Provider getProvider(KeyStoreBuilder params) {
            return YubiKey.getProvider();
        }

        @Override
        Set<String> getAliases(KeyStore keystore) throws KeyStoreException {
            Set<String> aliases = super.getAliases(keystore);
            aliases.remove("X.509 Certificate for PIV Attestation");
            return aliases;
        }
    }
    ,
    AWS(false, false, false){

        @Override
        void validate(KeyStoreBuilder params) {
            if (params.keystore() == null) {
                throw new IllegalArgumentException("keystore " + params.parameterName() + " must specify the AWS region");
            }
            if (params.certfile() == null) {
                throw new IllegalArgumentException("certfile " + params.parameterName() + " must be set");
            }
        }

        @Override
        Provider getProvider(KeyStoreBuilder params) {
            AmazonCredentials credentials;
            if (params.storepass() != null) {
                credentials = AmazonCredentials.parse(params.storepass());
            } else {
                try {
                    credentials = AmazonCredentials.getDefault();
                }
                catch (UnknownServiceException e) {
                    throw new IllegalArgumentException("storepass " + params.parameterName() + " must specify the AWS credentials: <accessKey>|<secretKey>[|<sessionToken>], when not running from an EC2 instance (" + e.getMessage() + ")", e);
                }
                catch (IOException e) {
                    throw new RuntimeException("An error occurred while fetching temporary credentials from IMDSv2 service", e);
                }
            }
            return new SigningServiceJcaProvider(new AmazonSigningService(params.keystore(), credentials, alias -> {
                try {
                    return CertificateUtils.loadCertificateChain(params.certfile());
                }
                catch (IOException | CertificateException e) {
                    throw new RuntimeException("Failed to load the certificate from " + params.certfile(), e);
                }
            }));
        }
    }
    ,
    AZUREKEYVAULT(false, true, false){

        @Override
        void validate(KeyStoreBuilder params) {
            if (params.keystore() == null) {
                throw new IllegalArgumentException("keystore " + params.parameterName() + " must specify the Azure vault name");
            }
            if (params.storepass() == null) {
                throw new IllegalArgumentException("storepass " + params.parameterName() + " must specify the Azure API access token");
            }
        }

        @Override
        Provider getProvider(KeyStoreBuilder params) {
            return new SigningServiceJcaProvider(new AzureKeyVaultSigningService(params.keystore(), params.storepass()));
        }
    }
    ,
    DIGICERTONE(false, true, false){

        @Override
        void validate(KeyStoreBuilder params) {
            if (params.storepass() == null || params.storepass().split("\\|").length != 3) {
                throw new IllegalArgumentException("storepass " + params.parameterName() + " must specify the DigiCert ONE API key and the client certificate: <apikey>|<keystore>|<password>");
            }
        }

        @Override
        Provider getProvider(KeyStoreBuilder params) {
            String[] elements = params.storepass().split("\\|");
            return new SigningServiceJcaProvider(new DigiCertOneSigningService(elements[0], params.createFile(elements[1]), elements[2]));
        }
    }
    ,
    ESIGNER(false, true, false){

        @Override
        void validate(KeyStoreBuilder params) {
            if (params.storepass() == null || !params.storepass().contains("|")) {
                throw new IllegalArgumentException("storepass " + params.parameterName() + " must specify the SSL.com username and password: <username>|<password>");
            }
        }

        @Override
        Provider getProvider(KeyStoreBuilder params) {
            String[] elements = params.storepass().split("\\|", 2);
            String endpoint = params.keystore() != null ? params.keystore() : "https://cs.ssl.com";
            try {
                return new SigningServiceJcaProvider(new ESignerSigningService(endpoint, elements[0], elements[1]));
            }
            catch (IOException e) {
                throw new IllegalStateException("Authentication failed with SSL.com", e);
            }
        }

        @Override
        boolean reuseKeyStorePassword() {
            return false;
        }
    }
    ,
    GOOGLECLOUD(false, false, false){

        @Override
        void validate(KeyStoreBuilder params) {
            if (params.keystore() == null) {
                throw new IllegalArgumentException("keystore " + params.parameterName() + " must specify the Goole Cloud keyring");
            }
            if (params.storepass() == null) {
                throw new IllegalArgumentException("storepass " + params.parameterName() + " must specify the Goole Cloud API access token");
            }
            if (params.certfile() == null) {
                throw new IllegalArgumentException("certfile " + params.parameterName() + " must be set");
            }
        }

        @Override
        Provider getProvider(KeyStoreBuilder params) {
            return new SigningServiceJcaProvider(new GoogleCloudSigningService(params.keystore(), params.storepass(), alias -> {
                try {
                    return CertificateUtils.loadCertificateChain(params.certfile());
                }
                catch (IOException | CertificateException e) {
                    throw new RuntimeException("Failed to load the certificate from " + params.certfile(), e);
                }
            }));
        }
    }
    ,
    HASHICORPVAULT(false, false, false){

        @Override
        void validate(KeyStoreBuilder params) {
            if (params.keystore() == null) {
                throw new IllegalArgumentException("keystore " + params.parameterName() + " must specify the HashiCorp Vault secrets engine URL");
            }
            if (params.storepass() == null) {
                throw new IllegalArgumentException("storepass " + params.parameterName() + " must specify the HashiCorp Vault token");
            }
            if (params.certfile() == null) {
                throw new IllegalArgumentException("certfile " + params.parameterName() + " must be set");
            }
        }

        @Override
        Provider getProvider(KeyStoreBuilder params) {
            return new SigningServiceJcaProvider(new HashiCorpVaultSigningService(params.keystore(), params.storepass(), alias -> {
                try {
                    return CertificateUtils.loadCertificateChain(params.certfile());
                }
                catch (IOException | CertificateException e) {
                    throw new RuntimeException("Failed to load the certificate from " + params.certfile(), e);
                }
            }));
        }
    };

    private final boolean fileBased;
    private final boolean certificate;
    private final boolean pkcs11;

    private KeyStoreType(boolean fileBased, boolean certificate, boolean pkcs11) {
        this.fileBased = fileBased;
        this.certificate = certificate;
        this.pkcs11 = pkcs11;
    }

    boolean hasCertificate() {
        return this.certificate;
    }

    void validate(KeyStoreBuilder params) throws IllegalArgumentException {
    }

    Provider getProvider(KeyStoreBuilder params) {
        return null;
    }

    KeyStore getKeystore(KeyStoreBuilder params, Provider provider) throws KeyStoreException {
        KeyStore ks;
        try {
            KeyStoreType storetype;
            KeyStoreType keyStoreType = storetype = this.pkcs11 ? PKCS11 : this;
            ks = provider != null ? KeyStore.getInstance(storetype.name(), provider) : KeyStore.getInstance(storetype.name());
        }
        catch (KeyStoreException e) {
            throw new KeyStoreException("keystore type '" + this.name() + "' is not supported" + (provider != null ? " with security provider " + provider.getName() : ""), e);
        }
        if (this.fileBased && (params.keystore() == null || !params.createFile(params.keystore()).exists())) {
            throw new KeyStoreException("The keystore " + params.keystore() + " couldn't be found");
        }
        try (FileInputStream in = this.fileBased ? new FileInputStream(params.createFile(params.keystore())) : null;){
            ks.load(in, params.storepass() != null ? params.storepass().toCharArray() : null);
        }
        catch (Exception e) {
            throw new KeyStoreException("Unable to load the keystore " + params.keystore(), e);
        }
        return ks;
    }

    Set<String> getAliases(KeyStore keystore) throws KeyStoreException {
        return new LinkedHashSet<String>(Collections.list(keystore.aliases()));
    }

    boolean reuseKeyStorePassword() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static KeyStoreType of(File path) {
        String filename;
        if (path.exists()) {
            try (FileInputStream in = new FileInputStream(path);){
                byte[] header = new byte[4];
                in.read(header);
                ByteBuffer buffer = ByteBuffer.wrap(header);
                if (buffer.get(0) == 48) {
                    KeyStoreType keyStoreType = PKCS12;
                    return keyStoreType;
                }
                if (((long)buffer.getInt(0) & 0xFFFFFFFFL) == 0xCECECECEL) {
                    KeyStoreType keyStoreType = JCEKS;
                    return keyStoreType;
                }
                if (((long)buffer.getInt(0) & 0xFFFFFFFFL) == 0xFEEDFEEDL) {
                    KeyStoreType keyStoreType = JKS;
                    return keyStoreType;
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to load the keystore " + path, e);
            }
        }
        if ((filename = path.getName().toLowerCase()).endsWith(".p12")) return PKCS12;
        if (filename.endsWith(".pfx")) {
            return PKCS12;
        }
        if (filename.endsWith(".jceks")) {
            return JCEKS;
        }
        if (!filename.endsWith(".jks")) return null;
        return JKS;
    }
}

