/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.jca;

import java.io.IOException;
import net.jsign.jca.AmazonIMDS2Client;

public class AmazonCredentials {
    private final String accessKey;
    private final String secretKey;
    private final String sessionToken;

    public AmazonCredentials(String accessKey, String secretKey, String sessionToken) {
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.sessionToken = sessionToken;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    public static AmazonCredentials parse(String credentials) throws IllegalArgumentException {
        String[] elements = credentials.split("\\|", 3);
        if (elements.length < 2) {
            throw new IllegalArgumentException("Invalid AWS credentials: " + credentials);
        }
        String accessKey = elements[0];
        String secretKey = elements[1];
        String sessionToken = elements.length > 2 ? elements[2] : null;
        return new AmazonCredentials(accessKey, secretKey, sessionToken);
    }

    public static AmazonCredentials getDefault() throws IOException {
        if (System.getenv("AWS_ACCESS_KEY_ID") != null || System.getenv("AWS_ACCESS_KEY") != null) {
            String secretKey;
            String accesKey = System.getenv("AWS_ACCESS_KEY_ID");
            if (accesKey == null) {
                accesKey = System.getenv("AWS_ACCESS_KEY");
            }
            if ((secretKey = System.getenv("AWS_SECRET_KEY")) == null) {
                secretKey = System.getenv("AWS_SECRET_ACCESS_KEY");
            }
            String sessionToken = System.getenv("AWS_SESSION_TOKEN");
            return new AmazonCredentials(accesKey, secretKey, sessionToken);
        }
        return new AmazonIMDS2Client().getCredentials();
    }
}

