/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.jca;

import com.cedarsoftware.util.io.JsonReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.HttpURLConnection;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownServiceException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import net.jsign.jca.AmazonCredentials;
import org.apache.commons.io.IOUtils;

class AmazonIMDS2Client {
    private static final String ROLE_PATTERN = "[-\\w+=,.@]{1,64}";
    private static final String IMDS_ENDPOINT = "http://169.254.169.254";
    private static final int TOKEN_TTL_SECONDS = 21600;

    AmazonIMDS2Client() {
    }

    public String getInstanceProfileName() throws IOException {
        String response = this.getMetaData("iam/security-credentials", 404);
        if (response == null) {
            return null;
        }
        String[] roles = response.trim().split("\n");
        if (roles.length == 0 || !roles[0].matches(ROLE_PATTERN)) {
            throw new RuntimeException("Unable to read the instance profile name");
        }
        return roles[0];
    }

    public AmazonCredentials getCredentials() throws IOException {
        String role = this.getInstanceProfileName();
        if (role == null) {
            throw new RuntimeException("This EC2 instance seems not to be associated with an instance profile");
        }
        return this.getCredentials(role);
    }

    public AmazonCredentials getCredentials(String role) throws IOException {
        String response = this.getMetaData("iam/security-credentials/" + role);
        Map credentials = JsonReader.jsonToMaps((String)response);
        return new AmazonCredentials((String)credentials.get("AccessKeyId"), (String)credentials.get("SecretAccessKey"), (String)credentials.get("Token"));
    }

    private String getApiToken() throws IOException {
        URL url = new URL("http://169.254.169.254/latest/api/token");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setConnectTimeout(3000);
        conn.setRequestMethod("PUT");
        conn.setRequestProperty("X-aws-ec2-metadata-token-ttl-seconds", String.valueOf(21600));
        try {
            int responseCode = conn.getResponseCode();
            if (responseCode == 404 || responseCode == 411) {
                throw new UnknownServiceException("IMDSv2 host did not respond as expected; are you in AWS cloud?");
            }
            if (responseCode == 403) {
                throw new UnknownServiceException("IMDSv2 is possibly disabled on this host");
            }
            if (responseCode >= 400) {
                throw this.handleError(conn);
            }
        }
        catch (InterruptedIOException | SocketException e) {
            throw (IOException)new UnknownServiceException("IMDSv2 host was unreachable; check the hop limit if containerized").initCause(e);
        }
        String apiToken = IOUtils.toString((InputStream)conn.getInputStream(), (Charset)StandardCharsets.UTF_8);
        if (apiToken == null) {
            throw new RuntimeException("Unable to obtain an API token to query the IMDS v2 service");
        }
        return apiToken;
    }

    private String getMetaData(String path, int noThrowErrorCode) throws IOException {
        URL url = new URL("http://169.254.169.254/latest/meta-data/" + path);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setConnectTimeout(10000);
        conn.setRequestProperty("X-aws-ec2-metadata-token", this.getApiToken());
        int responseCode = conn.getResponseCode();
        if (responseCode >= 400) {
            if (noThrowErrorCode > 0 && responseCode == noThrowErrorCode) {
                return null;
            }
            throw this.handleError(conn);
        }
        return IOUtils.toString((InputStream)conn.getInputStream(), (Charset)StandardCharsets.UTF_8);
    }

    private String getMetaData(String path) throws IOException {
        return this.getMetaData(path, -1);
    }

    private IOException handleError(HttpURLConnection conn) throws IOException {
        return new IOException("HTTP Error " + conn.getResponseCode() + (conn.getResponseMessage() != null ? " - " + conn.getResponseMessage() : "") + " (" + conn.getURL() + ")");
    }
}

