/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.jca;

import com.cedarsoftware.util.io.JsonWriter;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStoreException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.jsign.DigestAlgorithm;
import net.jsign.jca.RESTClient;
import net.jsign.jca.SigningService;
import net.jsign.jca.SigningServicePrivateKey;

public class HashiCorpVaultSigningService
implements SigningService {
    private final Function<String, Certificate[]> certificateStore;
    private final Map<String, SigningServicePrivateKey> keys = new HashMap<String, SigningServicePrivateKey>();
    private final RESTClient client;

    public HashiCorpVaultSigningService(String engineURL, String token, Function<String, Certificate[]> certificateStore) {
        this.certificateStore = certificateStore;
        this.client = new RESTClient(engineURL.endsWith("/") ? engineURL : engineURL + "/", conn -> conn.setRequestProperty("Authorization", "Bearer " + token));
    }

    @Override
    public String getName() {
        return "HashiCorpVault";
    }

    @Override
    public List<String> aliases() throws KeyStoreException {
        List<String> aliases;
        try {
            Map<String, ?> response = this.client.get("keys?list=true");
            String[] keys = (String[])((Map)response.get("data")).get("keys");
            aliases = Arrays.asList(keys);
        }
        catch (IOException e) {
            throw new KeyStoreException(e);
        }
        return aliases;
    }

    @Override
    public Certificate[] getCertificateChain(String alias) throws KeyStoreException {
        return this.certificateStore.apply(alias);
    }

    @Override
    public SigningServicePrivateKey getPrivateKey(String alias, char[] password) throws UnrecoverableKeyException {
        String algorithm;
        if (this.keys.containsKey(alias)) {
            return this.keys.get(alias);
        }
        if (!alias.contains(":")) {
            throw new UnrecoverableKeyException("Unable to fetch HashiCorp Vault Google Cloud private key '" + alias + "' (missing key version)");
        }
        try {
            Map<String, ?> response = this.client.get("keys/" + alias.substring(0, alias.indexOf(":")));
            algorithm = (String)((Map)response.get("data")).get("algorithm");
        }
        catch (IOException e) {
            throw (UnrecoverableKeyException)new UnrecoverableKeyException("Unable to fetch HashiCorp Vault Google Cloud private key '" + alias + "'").initCause(e);
        }
        algorithm = algorithm.substring(0, algorithm.indexOf("_")).toUpperCase();
        SigningServicePrivateKey key = new SigningServicePrivateKey(alias, algorithm);
        this.keys.put(alias, key);
        return key;
    }

    @Override
    public byte[] sign(SigningServicePrivateKey privateKey, String algorithm, byte[] data) throws GeneralSecurityException {
        DigestAlgorithm digestAlgorithm = DigestAlgorithm.of(algorithm.substring(0, algorithm.toLowerCase().indexOf("with")));
        data = digestAlgorithm.getMessageDigest().digest(data);
        String alias = privateKey.getId();
        String keyName = alias.substring(0, alias.indexOf(":"));
        String keyVersion = alias.substring(alias.indexOf(":") + 1);
        HashMap<String, String> request = new HashMap<String, String>();
        request.put("key_version", keyVersion);
        request.put("digest", Base64.getEncoder().encodeToString(data));
        try {
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("TYPE", "false");
            Map<String, ?> response = this.client.post("sign/" + keyName, JsonWriter.objectToJson(request, args));
            String signature = (String)((Map)response.get("data")).get("signature");
            return Base64.getDecoder().decode(signature);
        }
        catch (IOException e) {
            throw new GeneralSecurityException(e);
        }
    }
}

