/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.jca;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CardTerminals;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import javax.smartcardio.TerminalFactory;
import net.jsign.jca.TLV;
import org.apache.commons.io.HexDump;

class OpenPGPCard {
    private final CardChannel channel;
    private String pin;
    private final Map<Integer, byte[]> dataObjectCache = new HashMap<Integer, byte[]>();
    private byte[] extendedCapabilities;
    private KeyInfo[] keyInfos;
    private boolean debug;

    private OpenPGPCard(CardChannel channel) throws CardException {
        this.channel = channel;
        this.select();
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    private void handleError(ResponseAPDU response) throws CardException {
        switch (response.getSW()) {
            case 36864: {
                return;
            }
            case 25536: 
            case 25537: 
            case 25538: 
            case 25539: {
                throw new CardException("PIN verification failed, " + (response.getSW() & 0xF) + " tries left");
            }
            case 26368: {
                throw new CardException("Wrong length");
            }
            case 27010: {
                throw new CardException("PIN verification required");
            }
            case 27264: {
                throw new CardException("The parameters in the data field are incorrect");
            }
            case 27266: {
                throw new CardException("Incorrect P1 or P2 parameter");
            }
            case 27904: {
                throw new CardException("Instruction code not supported or invalid");
            }
        }
        throw new CardException("Error " + Integer.toHexString(response.getSW()));
    }

    private void select() throws CardException {
        ResponseAPDU response = this.transmit(new CommandAPDU(0, 164, 4, 0, new byte[]{-46, 118, 0, 1, 36, 1}));
        switch (response.getSW()) {
            case 27266: 
            case 27270: {
                throw new CardException("OpenPGP application not found on the card/token");
            }
        }
        this.handleError(response);
    }

    public void verify(String pin) {
        this.pin = pin;
    }

    public void verify(int p1, int p2, String pin) throws CardException {
        if (pin == null) {
            pin = "";
        }
        ResponseAPDU response = this.transmit(new CommandAPDU(0, 32, p1, p2, p1 == 0 ? pin.getBytes() : new byte[]{}));
        this.handleError(response);
    }

    public void selectData(int tag, int index) throws CardException {
        byte[] data = new byte[]{96, 4, 92, 2, (byte)((tag & 0xFF00) >> 8), (byte)(tag & 0xFF)};
        ResponseAPDU response = this.transmit(new CommandAPDU(0, 165, index, 4, data));
        this.handleError(response);
    }

    public byte[] getData(int tag) throws CardException {
        if (this.dataObjectCache.containsKey(tag)) {
            return this.dataObjectCache.get(tag);
        }
        ResponseAPDU response = this.transmit(new CommandAPDU(0, 202, (tag & 0xFF00) >> 8, tag & 0xFF, 65536));
        if (response.getSW() == 27272) {
            throw new CardException("Data object 0x" + Integer.toHexString(tag).toUpperCase() + " not found");
        }
        this.handleError(response);
        if (tag != 32545) {
            this.dataObjectCache.put(tag, response.getData());
        }
        return response.getData();
    }

    public byte[] getAID() throws CardException {
        return this.getData(79);
    }

    public float getVersion() throws CardException {
        byte[] aid = this.getAID();
        byte major = aid[6];
        byte minor = aid[7];
        return (float)major + (float)minor / 10.0f;
    }

    public Set<Key> getAvailableKeys() throws CardException {
        LinkedHashSet<Key> keys = new LinkedHashSet<Key>();
        for (Key key : Key.values()) {
            if (!this.getKeyInfo(key).isPresent() || key == Key.ENCRYPTION && !this.supportsManageSecurityEnvironment()) continue;
            keys.add(key);
        }
        return keys;
    }

    public byte[] getCertificate(Key key) throws CardException {
        if (key == Key.AUTHENTICATION) {
            return this.getData(32545);
        }
        if (this.getVersion() < 3.0f) {
            return new byte[0];
        }
        int position = 0;
        if (key == Key.ENCRYPTION) {
            position = 1;
        } else if (key == Key.SIGNATURE) {
            position = 2;
        }
        this.selectData(32545, position);
        return this.getData(32545);
    }

    public KeyInfo getKeyInfo(Key key) throws CardException {
        if (this.keyInfos == null) {
            this.keyInfos = this.getKeyInfo();
        }
        return this.keyInfos[key.ordinal()];
    }

    private KeyInfo[] getKeyInfo() throws CardException {
        KeyInfo[] keyInfos = new KeyInfo[]{new KeyInfo(), new KeyInfo(), new KeyInfo()};
        TLV relatedData = TLV.parse(ByteBuffer.wrap(this.getData(110)));
        TLV fingerprints = relatedData.find("73", "C5");
        if (fingerprints != null) {
            byte[] data = fingerprints.value();
            Key[] keyArray = Key.values();
            int n = keyArray.length;
            for (int i = 0; i < n; ++i) {
                Key key = keyArray[i];
                byte[] fingerprint = new byte[20];
                System.arraycopy(data, 20 * key.ordinal(), fingerprint, 0, 20);
                keyInfos[key.ordinal()].fingerprint = fingerprint;
            }
        }
        for (Key key : Key.values()) {
            TLV algorithmAttributes = relatedData.find("73", "C" + (key.ordinal() + 1));
            ByteBuffer buffer = ByteBuffer.wrap(algorithmAttributes.value());
            keyInfos[key.ordinal()].algorithm = buffer.get();
            if (!keyInfos[key.ordinal()].isRSA()) continue;
            keyInfos[key.ordinal()].size = buffer.getShort() & 0xFFFF;
        }
        this.extendedCapabilities = relatedData.find("73", "C0").value();
        return keyInfos;
    }

    private byte[] getExtendedCapabilities() throws CardException {
        if (this.extendedCapabilities == null) {
            TLV relatedData = TLV.parse(ByteBuffer.wrap(this.getData(110)));
            System.out.println(relatedData);
            this.extendedCapabilities = relatedData.find("73", "C0").value();
        }
        return this.extendedCapabilities;
    }

    protected boolean supportsManageSecurityEnvironment() throws CardException {
        return this.getVersion() > 3.0f && (this.getExtendedCapabilities()[9] & 1) != 0;
    }

    public void putData(int tag, byte[] data) throws CardException {
        ResponseAPDU response = this.transmit(new CommandAPDU(0, 218, (tag & 0xFF00) >> 8, tag & 0xFF, data));
        this.handleError(response);
        this.dataObjectCache.clear();
    }

    public byte[] sign(Key key, byte[] data) throws CardException {
        if (key == Key.SIGNATURE) {
            this.verify(0, 129, this.pin);
            return this.computeDigitalSignature(data);
        }
        this.verify(0, 130, this.pin);
        if (key == Key.ENCRYPTION) {
            this.manageSecurityEnvironment(164, (byte)2);
        }
        return this.authenticate(data);
    }

    public byte[] computeDigitalSignature(byte[] data) throws CardException {
        ResponseAPDU response = this.transmit(new CommandAPDU(0, 42, 158, 154, data));
        if (response.getSW() == 27272) {
            throw new CardException("Signature key not found");
        }
        this.handleError(response);
        return response.getData();
    }

    public byte[] authenticate(byte[] data) throws CardException {
        ResponseAPDU response = this.transmit(new CommandAPDU(0, 136, 0, 0, data));
        if (response.getSW() == 27272) {
            throw new CardException("Authentication key not found");
        }
        this.handleError(response);
        return response.getData();
    }

    public void manageSecurityEnvironment(int p2, byte keyRef) throws CardException {
        ResponseAPDU response = this.transmit(new CommandAPDU(0, 34, 65, p2, new byte[]{-125, 1, keyRef}));
        this.handleError(response);
    }

    private ResponseAPDU transmit(CommandAPDU command) throws CardException {
        if (this.debug) {
            System.out.println(command);
            try {
                HexDump.dump((byte[])command.getBytes(), (long)0L, (OutputStream)System.out, (int)0);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        long t1 = System.nanoTime();
        ResponseAPDU response = this.channel.transmit(command);
        long t2 = System.nanoTime();
        if (this.debug) {
            System.out.println(response + " (" + (t2 - t1) / 1000000L + " ms)");
            if (response.getData().length > 0) {
                try {
                    HexDump.dump((byte[])response.getData(), (long)0L, (OutputStream)System.out, (int)0);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            System.out.println();
        }
        return response;
    }

    public static OpenPGPCard getCard() throws CardException {
        OpenPGPCard.killSmartCardDaemon();
        CardTerminals terminals = TerminalFactory.getDefault().terminals();
        for (CardTerminal terminal : terminals.list(CardTerminals.State.CARD_PRESENT)) {
            try {
                Card card = terminal.connect("T=1");
                CardChannel channel = card.getBasicChannel();
                return new OpenPGPCard(channel);
            }
            catch (CardException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private static void killSmartCardDaemon() {
        try {
            new ProcessBuilder("gpgconf", "--kill", "scdaemon").start().waitFor(5L, TimeUnit.SECONDS);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class KeyInfo {
        public byte[] fingerprint;
        public int algorithm;
        public int size;

        public boolean isRSA() {
            return this.algorithm == 1 || this.algorithm == 2 || this.algorithm == 3;
        }

        public boolean isEC() {
            return this.algorithm == 18 || this.algorithm == 19;
        }

        public boolean isPresent() {
            return !Arrays.equals(this.fingerprint, new byte[20]);
        }
    }

    public static enum Key {
        SIGNATURE,
        ENCRYPTION,
        AUTHENTICATION;

    }
}

