/*
 * Decompiled with CFR 0.152.
 */
package net.jsign;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import javax.security.auth.x500.X500Principal;

class CertificateUtils {
    private CertificateUtils() {
    }

    public static Certificate[] loadCertificateChain(File file) throws IOException, CertificateException {
        try (FileInputStream in = new FileInputStream(file);){
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            Collection<? extends Certificate> certificates = certificateFactory.generateCertificates(in);
            ArrayList<? extends Certificate> list = new ArrayList<Certificate>(certificates);
            list.sort(CertificateUtils.getChainComparator());
            Certificate[] certificateArray = list.toArray(new Certificate[0]);
            return certificateArray;
        }
    }

    public static Comparator<X509Certificate> getChainComparator() {
        return Comparator.comparing(X509Certificate::getBasicConstraints).thenComparing(X509Certificate::getNotBefore, Comparator.reverseOrder()).thenComparing(X509Certificate::getSubjectX500Principal, Comparator.comparing(X500Principal::getName));
    }
}

