/*
 * Decompiled with CFR 0.152.
 */
package net.jsign;

import java.io.File;
import java.io.IOException;
import java.security.Provider;
import java.security.ProviderException;
import java.util.ArrayList;
import net.jsign.ProviderUtils;
import sun.security.pkcs11.wrapper.CK_SLOT_INFO;
import sun.security.pkcs11.wrapper.CK_TOKEN_INFO;
import sun.security.pkcs11.wrapper.PKCS11;
import sun.security.pkcs11.wrapper.PKCS11Exception;

class OpenSC {
    OpenSC() {
    }

    static Provider getProvider(String name) {
        return ProviderUtils.createSunPKCS11Provider(OpenSC.getSunPKCS11Configuration(name));
    }

    static String getSunPKCS11Configuration(String name) {
        File library = OpenSC.getOpenSCLibrary();
        if (!library.exists()) {
            throw new ProviderException("OpenSC PKCS11 module is not installed (" + library + " is missing)");
        }
        String configuration = "--name=opensc\nlibrary = \"" + library.getAbsolutePath().replace("\\", "\\\\") + "\"\n";
        try {
            long slot;
            try {
                slot = Integer.parseInt(name);
            }
            catch (Exception e) {
                slot = OpenSC.getTokenSlot(library, name);
            }
            if (slot >= 0L) {
                configuration = configuration + "slot=" + slot;
            }
        }
        catch (Exception e) {
            throw new ProviderException(e);
        }
        return configuration;
    }

    static long getTokenSlot(File libraryPath, String name) throws PKCS11Exception, IOException {
        PKCS11 pkcs11 = PKCS11.getInstance(libraryPath.getAbsolutePath(), "C_GetFunctionList", null, false);
        long[] slots = pkcs11.C_GetSlotList(true);
        ArrayList<String> descriptions = new ArrayList<String>();
        ArrayList<Long> matches = new ArrayList<Long>();
        for (long slot : slots) {
            CK_SLOT_INFO info = pkcs11.C_GetSlotInfo(slot);
            String description = new String(info.slotDescription).trim();
            if (name == null || description.toLowerCase().contains(name.toLowerCase())) {
                CK_TOKEN_INFO tokenInfo = pkcs11.C_GetTokenInfo(slot);
                String label = new String(tokenInfo.label).trim();
                if (label.equals("OpenPGP card (User PIN (sig))")) continue;
                matches.add(slot);
            }
            descriptions.add(description);
        }
        if (matches.size() == 1) {
            return (Long)matches.get(0);
        }
        if (matches.isEmpty()) {
            throw new RuntimeException(descriptions.isEmpty() ? "No PKCS11 token found" : "No PKCS11 token found matching '" + name + "' (available tokens: " + String.join((CharSequence)", ", descriptions) + ")");
        }
        throw new RuntimeException("Multiple PKCS11 tokens found" + (name != null ? " matching '" + name + "'" : "") + ", please specify the name of the token to use (available tokens: " + String.join((CharSequence)", ", descriptions) + ")");
    }

    static File getOpenSCLibrary() {
        String osname = System.getProperty("os.name");
        String arch = System.getProperty("sun.arch.data.model");
        if (osname.contains("Windows")) {
            String programfiles = "32".equals(arch) && System.getenv("ProgramFiles(x86)") != null ? System.getenv("ProgramFiles(x86)") : System.getenv("ProgramFiles");
            return new File(programfiles + "/OpenSC Project/OpenSC/pkcs11/opensc-pkcs11.dll");
        }
        if (osname.contains("Mac")) {
            return new File("/Library/OpenSC/lib/opensc-pkcs11.so");
        }
        ArrayList<String> paths = new ArrayList<String>();
        if ("32".equals(arch)) {
            paths.add("/usr/lib/opensc-pkcs11.so");
            paths.add("/usr/lib/i386-linux-gnu/opensc-pkcs11.so");
            paths.add("/usr/lib/arm-linux-gnueabi/opensc-pkcs11.so");
            paths.add("/usr/lib/arm-linux-gnueabihf/opensc-pkcs11.so");
        } else {
            paths.add("/usr/lib64/opensc-pkcs11.so");
            paths.add("/usr/lib/x86_64-linux-gnu/opensc-pkcs11.so");
            paths.add("/usr/lib/aarch64-linux-gnu/opensc-pkcs11.so");
            paths.add("/usr/lib/mips64el-linux-gnuabi64/opensc-pkcs11.so");
            paths.add("/usr/lib/riscv64-linux-gnu/opensc-pkcs11.so");
        }
        for (String path : paths) {
            File library = new File(path);
            if (!library.exists()) continue;
            return library;
        }
        return new File("/usr/local/lib/opensc-pkcs11.so");
    }
}

