/*
 * Decompiled with CFR 0.152.
 */
package net.jsign;

import java.io.File;
import java.io.IOException;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.jsign.AuthenticodeSigner;
import net.jsign.CertificateUtils;
import net.jsign.Console;
import net.jsign.DigestAlgorithm;
import net.jsign.KeyStoreBuilder;
import net.jsign.KeyStoreType;
import net.jsign.Signable;
import net.jsign.SignerException;
import net.jsign.timestamp.TimestampingMode;
import org.apache.commons.io.FileUtils;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSSignedData;

class SignerHelper {
    public static final String PARAM_KEYSTORE = "keystore";
    public static final String PARAM_STOREPASS = "storepass";
    public static final String PARAM_STORETYPE = "storetype";
    public static final String PARAM_ALIAS = "alias";
    public static final String PARAM_KEYPASS = "keypass";
    public static final String PARAM_KEYFILE = "keyfile";
    public static final String PARAM_CERTFILE = "certfile";
    public static final String PARAM_ALG = "alg";
    public static final String PARAM_TSAURL = "tsaurl";
    public static final String PARAM_TSMODE = "tsmode";
    public static final String PARAM_TSRETRIES = "tsretries";
    public static final String PARAM_TSRETRY_WAIT = "tsretrywait";
    public static final String PARAM_NAME = "name";
    public static final String PARAM_URL = "url";
    public static final String PARAM_PROXY_URL = "proxyUrl";
    public static final String PARAM_PROXY_USER = "proxyUser";
    public static final String PARAM_PROXY_PASS = "proxyPass";
    public static final String PARAM_REPLACE = "replace";
    public static final String PARAM_ENCODING = "encoding";
    public static final String PARAM_DETACHED = "detached";
    private final Console console;
    private final String parameterName;
    private final KeyStoreBuilder ksparams;
    private String alias;
    private String tsaurl;
    private String tsmode;
    private int tsretries = -1;
    private int tsretrywait = -1;
    private String alg;
    private String name;
    private String url;
    private String proxyUrl;
    private String proxyUser;
    private String proxyPass;
    private boolean replace;
    private Charset encoding;
    private boolean detached;
    private AuthenticodeSigner signer;

    public SignerHelper(Console console, String parameterName) {
        this.console = console;
        this.parameterName = parameterName;
        this.ksparams = new KeyStoreBuilder(parameterName);
    }

    public SignerHelper keystore(String keystore) {
        this.ksparams.keystore(keystore);
        return this;
    }

    public SignerHelper storepass(String storepass) {
        this.ksparams.storepass(storepass);
        return this;
    }

    public SignerHelper storetype(String storetype) {
        this.ksparams.storetype(storetype);
        return this;
    }

    public SignerHelper alias(String alias) {
        this.alias = alias;
        return this;
    }

    public SignerHelper keypass(String keypass) {
        this.ksparams.keypass(keypass);
        return this;
    }

    public SignerHelper keyfile(String keyfile) {
        this.ksparams.keyfile(keyfile);
        return this;
    }

    public SignerHelper keyfile(File keyfile) {
        this.ksparams.keyfile(keyfile);
        return this;
    }

    public SignerHelper certfile(String certfile) {
        this.ksparams.certfile(certfile);
        return this;
    }

    public SignerHelper certfile(File certfile) {
        this.ksparams.certfile(certfile);
        return this;
    }

    public SignerHelper alg(String alg) {
        this.alg = alg;
        return this;
    }

    public SignerHelper tsaurl(String tsaurl) {
        this.tsaurl = tsaurl;
        return this;
    }

    public SignerHelper tsmode(String tsmode) {
        this.tsmode = tsmode;
        return this;
    }

    public SignerHelper tsretries(int tsretries) {
        this.tsretries = tsretries;
        return this;
    }

    public SignerHelper tsretrywait(int tsretrywait) {
        this.tsretrywait = tsretrywait;
        return this;
    }

    public SignerHelper name(String name) {
        this.name = name;
        return this;
    }

    public SignerHelper url(String url) {
        this.url = url;
        return this;
    }

    public SignerHelper proxyUrl(String proxyUrl) {
        this.proxyUrl = proxyUrl;
        return this;
    }

    public SignerHelper proxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
        return this;
    }

    public SignerHelper proxyPass(String proxyPass) {
        this.proxyPass = proxyPass;
        return this;
    }

    public SignerHelper replace(boolean replace) {
        this.replace = replace;
        return this;
    }

    public SignerHelper encoding(String encoding) {
        this.encoding = Charset.forName(encoding);
        return this;
    }

    public SignerHelper detached(boolean detached) {
        this.detached = detached;
        return this;
    }

    public SignerHelper param(String key, String value) {
        if (value == null) {
            return this;
        }
        switch (key) {
            case "keystore": {
                return this.keystore(value);
            }
            case "storepass": {
                return this.storepass(value);
            }
            case "storetype": {
                return this.storetype(value);
            }
            case "alias": {
                return this.alias(value);
            }
            case "keypass": {
                return this.keypass(value);
            }
            case "keyfile": {
                return this.keyfile(value);
            }
            case "certfile": {
                return this.certfile(value);
            }
            case "alg": {
                return this.alg(value);
            }
            case "tsaurl": {
                return this.tsaurl(value);
            }
            case "tsmode": {
                return this.tsmode(value);
            }
            case "tsretries": {
                return this.tsretries(Integer.parseInt(value));
            }
            case "tsretrywait": {
                return this.tsretrywait(Integer.parseInt(value));
            }
            case "name": {
                return this.name(value);
            }
            case "url": {
                return this.url(value);
            }
            case "proxyUrl": {
                return this.proxyUrl(value);
            }
            case "proxyUser": {
                return this.proxyUser(value);
            }
            case "proxyPass": {
                return this.proxyPass(value);
            }
            case "replace": {
                return this.replace("true".equalsIgnoreCase(value));
            }
            case "encoding": {
                return this.encoding(value);
            }
            case "detached": {
                return this.detached("true".equalsIgnoreCase(value));
            }
        }
        throw new IllegalArgumentException("Unknown " + this.parameterName + ": " + key);
    }

    void setBaseDir(File basedir) {
        this.ksparams.setBaseDir(basedir);
    }

    private AuthenticodeSigner build() throws SignerException {
        PrivateKey privateKey;
        char[] password;
        Certificate[] chain;
        KeyStore ks;
        try {
            ks = this.ksparams.build();
        }
        catch (KeyStoreException e) {
            throw new SignerException("Failed to load the keystore " + (this.ksparams.keystore() != null ? this.ksparams.keystore() : ""), e);
        }
        KeyStoreType storetype = this.ksparams.storetype();
        Provider provider = this.ksparams.provider();
        Set<String> aliases = null;
        if (this.alias == null) {
            try {
                aliases = storetype.getAliases(ks);
            }
            catch (KeyStoreException e) {
                throw new SignerException(e.getMessage(), e);
            }
            if (aliases.isEmpty()) {
                throw new SignerException("No certificate found in the keystore " + (provider != null ? provider.getName() : this.ksparams.keystore()));
            }
            if (aliases.size() == 1) {
                this.alias = aliases.iterator().next();
            } else {
                throw new SignerException("alias " + this.parameterName + " must be set to select a certificate (available aliases: " + String.join((CharSequence)", ", aliases) + ")");
            }
        }
        try {
            chain = ks.getCertificateChain(this.alias);
        }
        catch (KeyStoreException e) {
            throw new SignerException(e.getMessage(), e);
        }
        if (chain == null) {
            String message = "No certificate found under the alias '" + this.alias + "' in the keystore " + (provider != null ? provider.getName() : this.ksparams.keystore());
            if (aliases == null) {
                try {
                    aliases = new LinkedHashSet<String>(Collections.list(ks.aliases()));
                    message = aliases.isEmpty() ? "No certificate found in the keystore " + (provider != null ? provider.getName() : this.ksparams.keystore()) : message + " (available aliases: " + String.join((CharSequence)", ", aliases) + ")";
                }
                catch (KeyStoreException e) {
                    message = message + " (couldn't load the list of available aliases: " + e.getMessage() + ")";
                }
            }
            throw new SignerException(message);
        }
        if (this.ksparams.certfile() != null && storetype.hasCertificate()) {
            if (chain.length != 1) {
                throw new SignerException("certfile " + this.parameterName + " can only be specified if the certificate from the keystore contains only one entry");
            }
            try {
                Certificate[] chainFromFile = CertificateUtils.loadCertificateChain(this.ksparams.certfile());
                if (!chainFromFile[0].equals(chain[0])) {
                    throw new SignerException("The certificate chain in " + this.ksparams.certfile() + " does not match the chain from the keystore");
                }
                chain = chainFromFile;
            }
            catch (SignerException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SignerException("Failed to load the certificate from " + this.ksparams.certfile(), e);
            }
        }
        String storepass = this.ksparams.storepass();
        String keypass = this.ksparams.keypass();
        char[] cArray = password = keypass != null ? keypass.toCharArray() : null;
        if (password == null && storepass != null && storetype.reuseKeyStorePassword()) {
            password = storepass.toCharArray();
        }
        try {
            privateKey = (PrivateKey)ks.getKey(this.alias, password);
        }
        catch (Exception e) {
            throw new SignerException("Failed to retrieve the private key from the keystore", e);
        }
        if (this.alg != null && DigestAlgorithm.of(this.alg) == null) {
            throw new SignerException("The digest algorithm " + this.alg + " is not supported");
        }
        try {
            this.initializeProxy(this.proxyUrl, this.proxyUser, this.proxyPass);
        }
        catch (Exception e) {
            throw new SignerException("Couldn't initialize proxy", e);
        }
        return new AuthenticodeSigner(chain, privateKey).withProgramName(this.name).withProgramURL(this.url).withDigestAlgorithm(DigestAlgorithm.of(this.alg)).withSignatureProvider(provider).withSignaturesReplaced(this.replace).withTimestamping(this.tsaurl != null || this.tsmode != null).withTimestampingMode(this.tsmode != null ? TimestampingMode.of(this.tsmode) : TimestampingMode.AUTHENTICODE).withTimestampingRetries(this.tsretries).withTimestampingRetryWait(this.tsretrywait).withTimestampingAuthority(this.tsaurl != null ? this.tsaurl.split(",") : null);
    }

    public void sign(String file) throws SignerException {
        this.sign(this.ksparams.createFile(file));
    }

    public void sign(File file) throws SignerException {
        block25: {
            if (file == null) {
                throw new SignerException("file must be set");
            }
            if (!file.exists()) {
                throw new SignerException("The file " + file + " couldn't be found");
            }
            try (Signable signable = Signable.of(file, this.encoding);){
                File detachedSignature = this.getDetachedSignature(file);
                if (this.detached && detachedSignature.exists()) {
                    try {
                        if (this.console != null) {
                            this.console.info("Attaching Authenticode signature to " + file);
                        }
                        this.attach(signable, detachedSignature);
                        break block25;
                    }
                    catch (Exception e) {
                        throw new SignerException("Couldn't attach the signature to " + file, e);
                    }
                }
                if (this.signer == null) {
                    this.signer = this.build();
                }
                if (this.console != null) {
                    this.console.info("Adding Authenticode signature to " + file);
                }
                this.signer.sign(signable);
                if (this.detached) {
                    this.detach(signable, detachedSignature);
                }
            }
            catch (IllegalArgumentException | UnsupportedOperationException e) {
                throw new SignerException(e.getMessage());
            }
            catch (SignerException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SignerException("Couldn't sign " + file, e);
            }
        }
    }

    private void attach(Signable signable, File detachedSignature) throws IOException, CMSException {
        byte[] signatureBytes = FileUtils.readFileToByteArray((File)detachedSignature);
        CMSSignedData signedData = new CMSSignedData((CMSProcessable)null, ContentInfo.getInstance((Object)new ASN1InputStream(signatureBytes).readObject()));
        signable.setSignature(signedData);
        signable.save();
    }

    private void detach(Signable signable, File detachedSignature) throws IOException {
        CMSSignedData signedData = signable.getSignatures().get(0);
        byte[] content = signedData.toASN1Structure().getEncoded("DER");
        FileUtils.writeByteArrayToFile((File)detachedSignature, (byte[])content);
    }

    private File getDetachedSignature(File file) {
        return new File(file.getParentFile(), file.getName() + ".sig");
    }

    private void initializeProxy(String proxyUrl, final String proxyUser, final String proxyPassword) throws MalformedURLException {
        if (proxyUrl != null && proxyUrl.trim().length() > 0) {
            URL url;
            if (!proxyUrl.trim().startsWith("http")) {
                proxyUrl = "http://" + proxyUrl.trim();
            }
            final int port = (url = new URL(proxyUrl)).getPort() < 0 ? 80 : url.getPort();
            ProxySelector.setDefault(new ProxySelector(){

                @Override
                public List<Proxy> select(URI uri) {
                    Proxy proxy = uri.getScheme().equals("socket") ? new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(url.getHost(), port)) : new Proxy(Proxy.Type.HTTP, new InetSocketAddress(url.getHost(), port));
                    if (SignerHelper.this.console != null) {
                        SignerHelper.this.console.debug("Proxy selected for " + uri + " : " + proxy);
                    }
                    return Collections.singletonList(proxy);
                }

                @Override
                public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
                }
            });
            if (proxyUser != null && proxyUser.length() > 0 && proxyPassword != null) {
                Authenticator.setDefault(new Authenticator(){

                    @Override
                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(proxyUser, proxyPassword.toCharArray());
                    }
                });
            }
        }
    }
}

