/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.jca;

import com.cedarsoftware.util.io.JsonWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStoreException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.jsign.DigestAlgorithm;
import net.jsign.jca.RESTClient;
import net.jsign.jca.SigningService;
import net.jsign.jca.SigningServicePrivateKey;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DigestInfo;

public class AzureKeyVaultSigningService
implements SigningService {
    private final Map<String, Map<String, ?>> certificates = new HashMap();
    private final RESTClient client;
    private final Map<String, String> algorithmMapping = new HashMap<String, String>();

    public AzureKeyVaultSigningService(String vault, String token) {
        this.algorithmMapping.put("SHA1withRSA", "RSNULL");
        this.algorithmMapping.put("SHA256withRSA", "RS256");
        this.algorithmMapping.put("SHA384withRSA", "RS384");
        this.algorithmMapping.put("SHA512withRSA", "RS512");
        this.algorithmMapping.put("SHA256withECDSA", "ES256");
        this.algorithmMapping.put("SHA384withECDSA", "ES384");
        this.algorithmMapping.put("SHA512withECDSA", "ES512");
        this.algorithmMapping.put("SHA256withRSA/PSS", "PS256");
        this.algorithmMapping.put("SHA384withRSA/PSS", "PS384");
        this.algorithmMapping.put("SHA512withRSA/PSS", "PS512");
        if (!vault.startsWith("http")) {
            vault = "https://" + vault + ".vault.azure.net";
        }
        this.client = new RESTClient(vault, conn -> conn.setRequestProperty("Authorization", "Bearer " + token));
    }

    @Override
    public String getName() {
        return "AzureKeyVault";
    }

    private Map<String, ?> getCertificateInfo(String alias) throws IOException {
        if (!this.certificates.containsKey(alias)) {
            Map<String, ?> response = this.client.get("/certificates/" + alias + "?api-version=7.2");
            this.certificates.put(alias, response);
        }
        return this.certificates.get(alias);
    }

    @Override
    public List<String> aliases() throws KeyStoreException {
        ArrayList<String> aliases = new ArrayList<String>();
        try {
            Object[] certificates;
            Map<String, ?> response = this.client.get("/certificates?api-version=7.2");
            for (Object certificate : certificates = (Object[])response.get("value")) {
                String id = (String)((Map)certificate).get("id");
                aliases.add(id.substring(id.lastIndexOf(47) + 1));
            }
        }
        catch (IOException e) {
            throw new KeyStoreException("Unable to retrieve Azure Key Vault certificate aliases", e);
        }
        return aliases;
    }

    @Override
    public Certificate[] getCertificateChain(String alias) throws KeyStoreException {
        try {
            Map<String, ?> response = this.getCertificateInfo(alias);
            String pem = (String)response.get("cer");
            Certificate certificate = CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(Base64.getDecoder().decode(pem)));
            return new Certificate[]{certificate};
        }
        catch (IOException | CertificateException e) {
            throw new KeyStoreException("Unable to retrieve Azure Key Vault certificate '" + alias + "'", e);
        }
    }

    @Override
    public SigningServicePrivateKey getPrivateKey(String alias, char[] password) throws UnrecoverableKeyException {
        try {
            Map<String, ?> response = this.getCertificateInfo(alias);
            String kid = (String)response.get("kid");
            Map policy = (Map)response.get("policy");
            Map keyprops = (Map)policy.get("key_props");
            String algorithm = ((String)keyprops.get("kty")).replace("-HSM", "");
            return new SigningServicePrivateKey(kid, algorithm, this);
        }
        catch (IOException e) {
            throw (UnrecoverableKeyException)new UnrecoverableKeyException("Unable to fetch Azure Key Vault private key for the certificate '" + alias + "'").initCause(e);
        }
    }

    @Override
    public byte[] sign(SigningServicePrivateKey privateKey, String algorithm, byte[] data) throws GeneralSecurityException {
        String alg = this.algorithmMapping.get(algorithm);
        if (alg == null) {
            throw new InvalidAlgorithmParameterException("Unsupported signing algorithm: " + algorithm);
        }
        DigestAlgorithm digestAlgorithm = DigestAlgorithm.of(algorithm.substring(0, algorithm.toLowerCase().indexOf("with")));
        data = digestAlgorithm.getMessageDigest().digest(data);
        if (alg.equals("RSNULL")) {
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(digestAlgorithm.oid, (ASN1Encodable)DERNull.INSTANCE);
            DigestInfo digestInfo = new DigestInfo(algorithmIdentifier, data);
            try {
                data = digestInfo.getEncoded("DER");
            }
            catch (IOException e) {
                throw new GeneralSecurityException(e);
            }
        }
        HashMap<String, String> request = new HashMap<String, String>();
        request.put("alg", alg);
        request.put("value", Base64.getEncoder().encodeToString(data));
        try {
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("TYPE", "false");
            Map<String, ?> response = this.client.post(privateKey.getId() + "/sign?api-version=7.2", JsonWriter.objectToJson(request, args));
            String value = (String)response.get("value");
            return Base64.getUrlDecoder().decode(value);
        }
        catch (IOException e) {
            throw new GeneralSecurityException(e);
        }
    }
}

