/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.jca;

import com.cedarsoftware.util.io.JsonWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import net.jsign.DigestAlgorithm;
import net.jsign.jca.RESTClient;
import net.jsign.jca.SigningService;
import net.jsign.jca.SigningServicePrivateKey;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;

public class ESignerSigningService
implements SigningService {
    private final Map<String, Map<String, ?>> certificates = new HashMap();
    private final RESTClient client;

    public ESignerSigningService(String endpoint, String username, String password) throws IOException {
        this(endpoint, ESignerSigningService.getAccessToken(endpoint.contains("-try.ssl.com") ? "https://oauth-sandbox.ssl.com" : "https://login.ssl.com", endpoint.contains("-try.ssl.com") ? "qOUeZCCzSqgA93acB3LYq6lBNjgZdiOxQc-KayC3UMw" : "kaXTRACNijSWsFdRKg_KAfD3fqrBlzMbWs6TwWHwAn8", username, password));
    }

    public ESignerSigningService(String endpoint, String accessToken) {
        this.client = new RESTClient(endpoint, conn -> conn.setRequestProperty("Authorization", "Bearer " + accessToken));
    }

    private static String getAccessToken(String endpoint, String clientId, String username, String password) throws IOException {
        LinkedHashMap<String, String> request = new LinkedHashMap<String, String>();
        request.put("client_id", clientId);
        request.put("grant_type", "password");
        request.put("username", username);
        request.put("password", password);
        RESTClient client = new RESTClient(endpoint);
        Map<String, ?> response = client.post("/oauth2/token", JsonWriter.objectToJson(request));
        return (String)response.get("access_token");
    }

    @Override
    public String getName() {
        return "ESIGNER";
    }

    @Override
    public List<String> aliases() throws KeyStoreException {
        try {
            HashMap<String, String> request = new HashMap<String, String>();
            request.put("clientData", "EVCS");
            Map<String, ?> response = this.client.post("/csc/v0/credentials/list", JsonWriter.objectToJson(request));
            Object[] credentials = (Object[])response.get("credentialIDs");
            return Stream.of(credentials).map(Object::toString).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new KeyStoreException("Unable to retrieve SSL.com certificate aliases", e);
        }
    }

    private Map<String, ?> getCertificateInfo(String alias) throws IOException {
        if (!this.certificates.containsKey(alias)) {
            HashMap<String, String> request = new HashMap<String, String>();
            request.put("credentialID", alias);
            request.put("certificates", "chain");
            Map<String, ?> response = this.client.post("/csc/v0/credentials/info", JsonWriter.objectToJson(request));
            this.certificates.put(alias, (Map)response.get("cert"));
        }
        return this.certificates.get(alias);
    }

    @Override
    public Certificate[] getCertificateChain(String alias) throws KeyStoreException {
        try {
            Map<String, ?> cert = this.getCertificateInfo(alias);
            Object[] encodedChain = (Object[])cert.get("certificates");
            ArrayList<Certificate> chain = new ArrayList<Certificate>();
            for (Object encodedCertificate : encodedChain) {
                chain.add(CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(Base64.getDecoder().decode(encodedCertificate.toString()))));
            }
            return chain.toArray(new Certificate[0]);
        }
        catch (IOException | CertificateException e) {
            throw new KeyStoreException("Unable to retrieve SSL.com certificate '" + alias + "'", e);
        }
    }

    @Override
    public SigningServicePrivateKey getPrivateKey(String alias, char[] password) throws UnrecoverableKeyException {
        try {
            Certificate[] chain = this.getCertificateChain(alias);
            String algorithm = chain[0].getPublicKey().getAlgorithm();
            SigningServicePrivateKey key = new SigningServicePrivateKey(alias, algorithm, this);
            if (password != null) {
                key.getProperties().put("totpsecret", new String(password));
            }
            return key;
        }
        catch (KeyStoreException e) {
            throw (UnrecoverableKeyException)new UnrecoverableKeyException().initCause(e);
        }
    }

    private void scan(SigningServicePrivateKey privateKey, String hashToSign, String hashToScan) {
        boolean malwareScanEnabled;
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("TYPE", "false");
        LinkedHashMap<String, String> request = new LinkedHashMap<String, String>();
        request.put("credential_id", privateKey.getId());
        try {
            Map<String, ?> response = this.client.post("/scan/settings", JsonWriter.objectToJson(request, args));
            malwareScanEnabled = Boolean.TRUE.equals(response.get("malware_scan_enabled"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (malwareScanEnabled) {
            request = new LinkedHashMap();
            request.put("credential_id", privateKey.getId());
            request.put("hash_to_scan", hashToScan);
            request.put("hash_to_sign", hashToSign);
            try {
                this.client.post("/scan/hash", JsonWriter.objectToJson(request, args));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public byte[] sign(SigningServicePrivateKey privateKey, String algorithm, byte[] data) throws GeneralSecurityException {
        MessageDigest digest = DigestAlgorithm.of(algorithm.substring(0, algorithm.toLowerCase().indexOf("with"))).getMessageDigest();
        data = digest.digest(data);
        String hash = Base64.getEncoder().encodeToString(data);
        this.scan(privateKey, hash, Base64.getEncoder().encodeToString(DigestAlgorithm.SHA256.getMessageDigest().digest(data)));
        LinkedHashMap<String, Object> request = new LinkedHashMap<String, Object>();
        request.put("credentialID", privateKey.getId());
        request.put("SAD", this.getSignatureActivationData(privateKey, hash));
        request.put("hash", new String[]{hash});
        request.put("signAlgo", new DefaultSignatureAlgorithmIdentifierFinder().find(algorithm).getAlgorithm().getId());
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("TYPE", "false");
        try {
            Map<String, ?> response = this.client.post("/csc/v0/signatures/signHash", JsonWriter.objectToJson(request, args));
            Object[] signatures = (Object[])response.get("signatures");
            return Base64.getDecoder().decode(signatures[0].toString());
        }
        catch (IOException e) {
            throw new GeneralSecurityException(e);
        }
    }

    private String getSignatureActivationData(SigningServicePrivateKey privateKey, String hash) throws GeneralSecurityException {
        LinkedHashMap<String, Object> request = new LinkedHashMap<String, Object>();
        request.put("credentialID", privateKey.getId());
        request.put("numSignatures", 1);
        request.put("hash", new String[]{hash});
        String totpsecret = (String)privateKey.getProperties().get("totpsecret");
        if (totpsecret != null) {
            request.put("OTP", this.generateOTP(totpsecret));
        }
        try {
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("TYPE", "false");
            Map<String, ?> response = this.client.post("/csc/v0/credentials/authorize", JsonWriter.objectToJson(request, args));
            return (String)response.get("SAD");
        }
        catch (IOException e) {
            throw new GeneralSecurityException("Couldn't get signing authorization for SSL.com certificate " + privateKey.getId(), e);
        }
    }

    private String generateOTP(String secret) throws GeneralSecurityException {
        Mac mac = Mac.getInstance("HmacSHA1");
        byte[] counter = new byte[8];
        ByteBuffer.wrap(counter).putLong(System.currentTimeMillis() / 30000L);
        mac.init(new SecretKeySpec(Base64.getDecoder().decode(secret), "RAW"));
        mac.update(counter);
        ByteBuffer hash = ByteBuffer.wrap(mac.doFinal());
        int offset = hash.get(hash.capacity() - 1) & 0xF;
        long value = (hash.getInt(offset) & Integer.MAX_VALUE) % 1000000;
        return String.format("%06d", value);
    }
}

