/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.jca;

import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.SignatureException;
import net.jsign.jca.AbstractSignatureSpi;
import net.jsign.jca.SigningServicePrivateKey;

class SigningServiceSignature
extends AbstractSignatureSpi {
    private SigningServicePrivateKey privateKey;
    private byte[] data;

    public SigningServiceSignature(String signingAlgorithm) {
        super(signingAlgorithm);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) {
        this.privateKey = (SigningServicePrivateKey)privateKey;
    }

    @Override
    protected void engineUpdate(byte[] b, int off, int len) {
        this.data = new byte[len];
        System.arraycopy(b, off, this.data, 0, len);
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        try {
            return this.privateKey.getService().sign(this.privateKey, this.signingAlgorithm, this.data);
        }
        catch (GeneralSecurityException e) {
            throw new SignatureException(e);
        }
    }
}

