/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.mscab;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SeekableByteChannel;
import java.security.MessageDigest;
import net.jsign.mscab.CABSignature;

class CFHeader {
    public static final int SIGNATURE = 1178817357;
    public long csumHeader;
    public long cbCabinet;
    public long csumFolders;
    public long coffFiles;
    public long csumFiles;
    public byte versionMinor;
    public byte versionMajor;
    public int cFolders;
    public int cFiles;
    public int flags;
    public int setID;
    public int iCabinet;
    public int cbCFHeader;
    public short cbCFFolder;
    public short cbCFData;
    public byte[] abReserved;
    public static final int FLAG_PREV_CABINET = 1;
    public static final int FLAG_NEXT_CABINET = 2;
    public static final int FLAG_RESERVE_PRESENT = 4;
    public static final int BASE_SIZE = 36;

    public CFHeader() {
    }

    public CFHeader(CFHeader header) {
        this.csumHeader = header.csumHeader;
        this.cbCabinet = header.cbCabinet;
        this.csumFolders = header.csumFolders;
        this.coffFiles = header.coffFiles;
        this.csumFiles = header.csumFiles;
        this.versionMinor = header.versionMinor;
        this.versionMajor = header.versionMajor;
        this.cFolders = header.cFolders;
        this.cFiles = header.cFiles;
        this.flags = header.flags;
        this.setID = header.setID;
        this.iCabinet = header.iCabinet;
        this.cbCFHeader = header.cbCFHeader;
        this.cbCFFolder = header.cbCFFolder;
        this.cbCFData = header.cbCFData;
        this.abReserved = header.abReserved != null ? (byte[])header.abReserved.clone() : null;
    }

    public void read(SeekableByteChannel channel) throws IOException {
        if (channel.size() < 44L) {
            throw new IOException("MSCabinet file too short");
        }
        ByteBuffer buffer = ByteBuffer.allocate(36).order(ByteOrder.LITTLE_ENDIAN);
        channel.read(buffer);
        buffer.flip();
        int signature = buffer.getInt();
        if (signature != 1178817357) {
            throw new IOException("Invalid MSCabinet header signature " + String.format("0x%04x", (long)signature & 0xFFFFFFFFL));
        }
        this.csumHeader = (long)buffer.getInt() & 0xFFFFFFFFL;
        this.cbCabinet = (long)buffer.getInt() & 0xFFFFFFFFL;
        this.csumFolders = (long)buffer.getInt() & 0xFFFFFFFFL;
        this.coffFiles = (long)buffer.getInt() & 0xFFFFFFFFL;
        this.csumFiles = (long)buffer.getInt() & 0xFFFFFFFFL;
        this.versionMinor = buffer.get();
        this.versionMajor = buffer.get();
        this.cFolders = buffer.getShort() & 0xFFFF;
        this.cFiles = buffer.getShort() & 0xFFFF;
        this.flags = buffer.getShort() & 0xFFFF;
        this.setID = buffer.getShort();
        this.iCabinet = buffer.getShort() & 0xFFFF;
        this.abReserved = null;
        if (this.isReservePresent()) {
            buffer.clear();
            buffer.limit(4);
            channel.read(buffer);
            buffer.flip();
            this.cbCFHeader = buffer.getShort() & 0xFFFF;
            this.cbCFFolder = (short)(buffer.get() & 0xFF);
            this.cbCFData = (short)(buffer.get() & 0xFF);
            if (this.cbCFHeader > 0) {
                this.abReserved = new byte[this.cbCFHeader];
                channel.read(ByteBuffer.wrap(this.abReserved));
            }
        }
    }

    public void write(ByteBuffer buffer) {
        buffer.putInt(1178817357);
        buffer.putInt((int)this.csumHeader);
        buffer.putInt((int)this.cbCabinet);
        buffer.putInt((int)this.csumFolders);
        buffer.putInt((int)this.coffFiles);
        buffer.putInt((int)this.csumFiles);
        buffer.put(this.versionMinor);
        buffer.put(this.versionMajor);
        buffer.putShort((short)this.cFolders);
        buffer.putShort((short)this.cFiles);
        buffer.putShort((short)this.flags);
        buffer.putShort((short)this.setID);
        buffer.putShort((short)this.iCabinet);
        if (this.isReservePresent()) {
            buffer.putShort((short)this.cbCFHeader);
            buffer.put((byte)this.cbCFFolder);
            buffer.put((byte)this.cbCFData);
            if (this.cbCFHeader > 0) {
                buffer.put(this.abReserved);
            }
        }
    }

    public int getHeaderSize() {
        if (this.isReservePresent()) {
            return 40 + this.cbCFHeader;
        }
        return 36;
    }

    public void headerDigestUpdate(MessageDigest digest) {
        ByteBuffer buffer = ByteBuffer.allocate(36).order(ByteOrder.LITTLE_ENDIAN);
        buffer.putInt(1178817357);
        buffer.putInt((int)this.cbCabinet);
        buffer.putInt((int)this.csumFolders);
        buffer.putInt((int)this.coffFiles);
        buffer.putInt((int)this.csumFiles);
        buffer.put(this.versionMinor);
        buffer.put(this.versionMajor);
        buffer.putShort((short)this.cFolders);
        buffer.putShort((short)this.cFiles);
        buffer.putShort((short)this.flags);
        buffer.putShort((short)this.setID);
        buffer.putShort((short)this.iCabinet);
        buffer.flip();
        digest.update(buffer);
        if (this.abReserved != null) {
            digest.update(this.abReserved, 0, 2);
        }
    }

    public boolean hasPreviousCabinet() {
        return (1 & this.flags) != 0;
    }

    public boolean hasNextCabinet() {
        return (2 & this.flags) != 0;
    }

    public boolean isReservePresent() {
        return (4 & this.flags) != 0;
    }

    public boolean hasSignature() {
        return this.abReserved != null;
    }

    public CABSignature getSignature() {
        return this.abReserved != null ? new CABSignature(this.abReserved) : null;
    }
}

