/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.pe;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.jsign.pe.CertificateType;
import net.jsign.pe.PEFile;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSSignedData;

public class CertificateTableEntry {
    private int size;
    private int revision;
    private int type;
    private byte[] content;
    private CMSSignedData signature;

    CertificateTableEntry(PEFile peFile, long index) throws IOException {
        this.size = (int)peFile.readDWord(index, 0);
        if (this.size < 8 || (long)this.size > peFile.channel.size() - index) {
            throw new IOException("Invalid certificate table size: " + this.size);
        }
        this.revision = peFile.readWord(index, 4);
        this.type = peFile.readWord(index, 6);
        this.content = new byte[this.size - 8];
        peFile.read(this.content, index, 8);
    }

    public CertificateTableEntry(CMSSignedData signature) throws IOException {
        this.setSignature(signature);
    }

    public int getSize() {
        return this.size;
    }

    public CMSSignedData getSignature() throws CMSException {
        if (this.type != CertificateType.PKCS_SIGNED_DATA.getValue()) {
            throw new UnsupportedOperationException("Unsupported certificate type: " + this.type);
        }
        if (this.revision != 512) {
            throw new UnsupportedOperationException("Unsupported certificate revision: " + this.revision);
        }
        if (this.signature == null) {
            try {
                this.signature = new CMSSignedData((CMSProcessable)null, ContentInfo.getInstance((Object)new ASN1InputStream(this.content).readObject()));
            }
            catch (IOException | StackOverflowError e) {
                throw new IllegalArgumentException("Failed to construct ContentInfo from byte[]: ", e);
            }
        }
        return this.signature;
    }

    public void setSignature(CMSSignedData signature) throws IOException {
        this.signature = signature;
        byte[] content = signature.toASN1Structure().getEncoded("DER");
        this.content = this.pad(content, 8);
        this.size = this.content.length + 8;
        this.type = CertificateType.PKCS_SIGNED_DATA.getValue();
    }

    private byte[] pad(byte[] data, int multiple) {
        if (data.length % multiple == 0) {
            return data;
        }
        byte[] copy = new byte[data.length + (multiple - data.length % multiple)];
        System.arraycopy(data, 0, copy, 0, data.length);
        return copy;
    }

    public byte[] toBytes() {
        ByteBuffer buffer = ByteBuffer.allocate(this.size);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.putInt(buffer.limit());
        buffer.putShort((short)512);
        buffer.putShort(CertificateType.PKCS_SIGNED_DATA.getValue());
        buffer.put(this.content);
        return buffer.array();
    }
}

