/*
 * Decompiled with CFR 0.152.
 */
package net.jsign;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Logger;
import net.jsign.AuthenticodeSigner;
import net.jsign.CertificateUtils;
import net.jsign.DigestAlgorithm;
import net.jsign.KeyStoreBuilder;
import net.jsign.KeyStoreType;
import net.jsign.Signable;
import net.jsign.SignatureUtils;
import net.jsign.SignerException;
import net.jsign.asn1.authenticode.AuthenticodeObjectIdentifiers;
import net.jsign.timestamp.Timestamper;
import net.jsign.timestamp.TimestampingMode;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.operator.DefaultAlgorithmNameFinder;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.encoders.Hex;

class SignerHelper {
    public static final String PARAM_COMMAND = "command";
    public static final String PARAM_KEYSTORE = "keystore";
    public static final String PARAM_STOREPASS = "storepass";
    public static final String PARAM_STORETYPE = "storetype";
    public static final String PARAM_ALIAS = "alias";
    public static final String PARAM_KEYPASS = "keypass";
    public static final String PARAM_KEYFILE = "keyfile";
    public static final String PARAM_CERTFILE = "certfile";
    public static final String PARAM_ALG = "alg";
    public static final String PARAM_TSAURL = "tsaurl";
    public static final String PARAM_TSMODE = "tsmode";
    public static final String PARAM_TSRETRIES = "tsretries";
    public static final String PARAM_TSRETRY_WAIT = "tsretrywait";
    public static final String PARAM_NAME = "name";
    public static final String PARAM_URL = "url";
    public static final String PARAM_PROXY_URL = "proxyUrl";
    public static final String PARAM_PROXY_USER = "proxyUser";
    public static final String PARAM_PROXY_PASS = "proxyPass";
    public static final String PARAM_REPLACE = "replace";
    public static final String PARAM_ENCODING = "encoding";
    public static final String PARAM_DETACHED = "detached";
    public static final String PARAM_FORMAT = "format";
    public static final String PARAM_VALUE = "value";
    private final Logger log = Logger.getLogger(this.getClass().getName());
    private final String parameterName;
    private String command = "sign";
    private final KeyStoreBuilder ksparams;
    private String alias;
    private String tsaurl;
    private String tsmode;
    private int tsretries = -1;
    private int tsretrywait = -1;
    private String alg;
    private String name;
    private String url;
    private String proxyUrl;
    private String proxyUser;
    private String proxyPass;
    private boolean replace;
    private Charset encoding;
    private boolean detached;
    private String format;
    private String value;
    private AuthenticodeSigner signer;

    public SignerHelper(String parameterName) {
        this.parameterName = parameterName;
        this.ksparams = new KeyStoreBuilder(parameterName);
    }

    public SignerHelper command(String command) {
        this.command = command;
        return this;
    }

    public SignerHelper keystore(String keystore) {
        this.ksparams.keystore(keystore);
        return this;
    }

    public SignerHelper storepass(String storepass) {
        this.ksparams.storepass(storepass);
        return this;
    }

    public SignerHelper storetype(String storetype) {
        this.ksparams.storetype(storetype);
        return this;
    }

    public SignerHelper alias(String alias) {
        this.alias = alias;
        return this;
    }

    public SignerHelper keypass(String keypass) {
        this.ksparams.keypass(keypass);
        return this;
    }

    public SignerHelper keyfile(String keyfile) {
        this.ksparams.keyfile(keyfile);
        return this;
    }

    public SignerHelper keyfile(File keyfile) {
        this.ksparams.keyfile(keyfile);
        return this;
    }

    public SignerHelper certfile(String certfile) {
        this.ksparams.certfile(certfile);
        return this;
    }

    public SignerHelper certfile(File certfile) {
        this.ksparams.certfile(certfile);
        return this;
    }

    public SignerHelper alg(String alg) {
        this.alg = alg;
        return this;
    }

    public SignerHelper tsaurl(String tsaurl) {
        this.tsaurl = tsaurl;
        return this;
    }

    public SignerHelper tsmode(String tsmode) {
        this.tsmode = tsmode;
        return this;
    }

    public SignerHelper tsretries(int tsretries) {
        this.tsretries = tsretries;
        return this;
    }

    public SignerHelper tsretrywait(int tsretrywait) {
        this.tsretrywait = tsretrywait;
        return this;
    }

    public SignerHelper name(String name) {
        this.name = name;
        return this;
    }

    public SignerHelper url(String url) {
        this.url = url;
        return this;
    }

    public SignerHelper proxyUrl(String proxyUrl) {
        this.proxyUrl = proxyUrl;
        return this;
    }

    public SignerHelper proxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
        return this;
    }

    public SignerHelper proxyPass(String proxyPass) {
        this.proxyPass = proxyPass;
        return this;
    }

    public SignerHelper replace(boolean replace) {
        this.replace = replace;
        return this;
    }

    public SignerHelper encoding(String encoding) {
        this.encoding = Charset.forName(encoding);
        return this;
    }

    public SignerHelper detached(boolean detached) {
        this.detached = detached;
        return this;
    }

    public SignerHelper format(String format) {
        this.format = format;
        return this;
    }

    public SignerHelper value(String value) {
        this.value = value;
        return this;
    }

    public SignerHelper param(String key, String value) {
        if (value == null) {
            return this;
        }
        switch (key) {
            case "command": {
                return this.command(value);
            }
            case "keystore": {
                return this.keystore(value);
            }
            case "storepass": {
                return this.storepass(value);
            }
            case "storetype": {
                return this.storetype(value);
            }
            case "alias": {
                return this.alias(value);
            }
            case "keypass": {
                return this.keypass(value);
            }
            case "keyfile": {
                return this.keyfile(value);
            }
            case "certfile": {
                return this.certfile(value);
            }
            case "alg": {
                return this.alg(value);
            }
            case "tsaurl": {
                return this.tsaurl(value);
            }
            case "tsmode": {
                return this.tsmode(value);
            }
            case "tsretries": {
                return this.tsretries(Integer.parseInt(value));
            }
            case "tsretrywait": {
                return this.tsretrywait(Integer.parseInt(value));
            }
            case "name": {
                return this.name(value);
            }
            case "url": {
                return this.url(value);
            }
            case "proxyUrl": {
                return this.proxyUrl(value);
            }
            case "proxyUser": {
                return this.proxyUser(value);
            }
            case "proxyPass": {
                return this.proxyPass(value);
            }
            case "replace": {
                return this.replace("true".equalsIgnoreCase(value));
            }
            case "encoding": {
                return this.encoding(value);
            }
            case "detached": {
                return this.detached("true".equalsIgnoreCase(value));
            }
            case "format": {
                return this.format(value);
            }
            case "value": {
                return this.value(value);
            }
        }
        throw new IllegalArgumentException("Unknown " + this.parameterName + ": " + key);
    }

    void setBaseDir(File basedir) {
        this.ksparams.setBaseDir(basedir);
    }

    public void execute(String file) throws SignerException {
        this.execute(this.ksparams.createFile(file));
    }

    public void execute(File file) throws SignerException {
        switch (this.command) {
            case "sign": {
                this.sign(file);
                break;
            }
            case "timestamp": {
                this.timestamp(file);
                break;
            }
            case "extract": {
                this.extract(file);
                break;
            }
            case "remove": {
                this.remove(file);
                break;
            }
            case "tag": {
                this.tag(file);
                break;
            }
            default: {
                throw new SignerException("Unknown command '" + this.command + "'");
            }
        }
    }

    private AuthenticodeSigner build() throws SignerException {
        PrivateKey privateKey;
        String keypass;
        Certificate[] chain;
        KeyStore ks;
        try {
            ks = this.ksparams.build();
        }
        catch (KeyStoreException e) {
            throw new SignerException("Failed to load the keystore " + (this.ksparams.keystore() != null ? this.ksparams.keystore() : ""), e);
        }
        KeyStoreType storetype = this.ksparams.storetype();
        Provider provider = this.ksparams.provider();
        LinkedHashSet<String> aliases = null;
        if (this.alias == null) {
            try {
                aliases = storetype.getAliases(ks);
            }
            catch (KeyStoreException e) {
                throw new SignerException(e.getMessage(), e);
            }
            if (aliases.isEmpty()) {
                throw new SignerException("No certificate found in the keystore " + (provider != null ? provider.getName() : this.ksparams.keystore()));
            }
            if (aliases.size() == 1) {
                this.alias = (String)aliases.iterator().next();
            } else {
                throw new SignerException("alias " + this.parameterName + " must be set to select a certificate (available aliases: " + String.join((CharSequence)", ", (Iterable<? extends CharSequence>)aliases) + ")");
            }
        }
        try {
            chain = ks.getCertificateChain(this.alias);
        }
        catch (KeyStoreException e) {
            throw new SignerException(e.getMessage(), e);
        }
        if (chain == null) {
            String message = "No certificate found under the alias '" + this.alias + "' in the keystore " + (provider != null ? provider.getName() : this.ksparams.keystore());
            if (aliases == null) {
                try {
                    aliases = new LinkedHashSet<String>(Collections.list(ks.aliases()));
                    message = aliases.isEmpty() ? "No certificate found in the keystore " + (provider != null ? provider.getName() : this.ksparams.keystore()) : (aliases.contains(this.alias) ? "The keystore password must be specified" : message + " (available aliases: " + String.join((CharSequence)", ", aliases) + ")");
                }
                catch (KeyStoreException e) {
                    message = message + " (couldn't load the list of available aliases: " + e.getMessage() + ")";
                }
            }
            throw new SignerException(message);
        }
        if (this.ksparams.certfile() != null) {
            try {
                chain = CertificateUtils.loadCertificateChain((File)this.ksparams.certfile());
            }
            catch (Exception e) {
                throw new SignerException("Failed to load the certificate from " + this.ksparams.certfile(), e);
            }
        }
        char[] password = (keypass = this.ksparams.keypass()) != null ? keypass.toCharArray() : new char[]{};
        try {
            privateKey = (PrivateKey)ks.getKey(this.alias, password);
        }
        catch (Exception e) {
            throw new SignerException("Failed to retrieve the private key from the keystore", e);
        }
        if (this.alg != null && DigestAlgorithm.of((String)this.alg) == null) {
            throw new SignerException("The digest algorithm " + this.alg + " is not supported");
        }
        try {
            this.initializeProxy(this.proxyUrl, this.proxyUser, this.proxyPass);
        }
        catch (Exception e) {
            throw new SignerException("Couldn't initialize proxy", e);
        }
        if (this.tsaurl == null && storetype == KeyStoreType.TRUSTEDSIGNING) {
            this.tsaurl = "http://timestamp.acs.microsoft.com/";
            this.tsmode = TimestampingMode.RFC3161.name();
            this.tsretries = 3;
        }
        return new AuthenticodeSigner(chain, privateKey).withProgramName(this.name).withProgramURL(this.url).withDigestAlgorithm(DigestAlgorithm.of((String)this.alg)).withSignatureProvider(provider).withSignaturesReplaced(this.replace).withTimestamping(this.tsaurl != null || this.tsmode != null).withTimestampingMode(this.tsmode != null ? TimestampingMode.of(this.tsmode) : TimestampingMode.AUTHENTICODE).withTimestampingRetries(this.tsretries).withTimestampingRetryWait(this.tsretrywait).withTimestampingAuthority(this.tsaurl != null ? this.tsaurl.split(",") : null);
    }

    public void sign(String file) throws SignerException {
        this.sign(this.ksparams.createFile(file));
    }

    public void sign(File file) throws SignerException {
        block23: {
            if (file == null) {
                throw new SignerException("file must be set");
            }
            if (!file.exists()) {
                throw new SignerException("The file " + file + " couldn't be found");
            }
            try (Signable signable = Signable.of(file, this.encoding);){
                File detachedSignature = this.getDetachedSignature(file);
                if (this.detached && detachedSignature.exists()) {
                    try {
                        this.log.info("Attaching Authenticode signature to " + file);
                        this.attach(signable, detachedSignature);
                        break block23;
                    }
                    catch (Exception e) {
                        throw new SignerException("Couldn't attach the signature to " + file, e);
                    }
                }
                if (this.signer == null) {
                    this.signer = this.build();
                }
                this.log.info("Adding Authenticode signature to " + file);
                this.signer.sign(signable);
                if (this.detached) {
                    this.detach(signable, detachedSignature);
                }
            }
            catch (IllegalArgumentException | UnsupportedOperationException e) {
                throw new SignerException(e.getMessage());
            }
            catch (SignerException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SignerException("Couldn't sign " + file, e);
            }
        }
    }

    private void attach(Signable signable, File detachedSignature) throws IOException, CMSException {
        byte[] signatureBytes = Files.readAllBytes(detachedSignature.toPath());
        CMSSignedData signedData = new CMSSignedData((CMSProcessable)null, ContentInfo.getInstance((Object)new ASN1InputStream(signatureBytes).readObject()));
        signable.setSignature(signedData);
        signable.save();
    }

    private void detach(Signable signable, File detachedSignature) throws IOException {
        CMSSignedData signedData = signable.getSignatures().get(0);
        byte[] content = signedData.toASN1Structure().getEncoded("DER");
        if (this.format == null || "DER".equalsIgnoreCase(this.format)) {
            Files.write(detachedSignature.toPath(), content, new OpenOption[0]);
        } else if ("PEM".equalsIgnoreCase(this.format)) {
            try (FileWriter out = new FileWriter(detachedSignature);){
                String encoded = Base64.getEncoder().encodeToString(content);
                out.write("-----BEGIN PKCS7-----\n");
                for (int i = 0; i < encoded.length(); i += 64) {
                    out.write(encoded.substring(i, Math.min(i + 64, encoded.length())));
                    out.write(10);
                }
                out.write("-----END PKCS7-----\n");
            }
        } else {
            throw new IllegalArgumentException("Unknown output format '" + this.format + "'");
        }
    }

    private File getDetachedSignature(File file) {
        return new File(file.getParentFile(), file.getName() + ".sig");
    }

    private void extract(File file) throws SignerException {
        if (!file.exists()) {
            throw new SignerException("Couldn't find " + file);
        }
        try (Signable signable = Signable.of(file);){
            List<CMSSignedData> signatures = signable.getSignatures();
            if (signatures.isEmpty()) {
                throw new SignerException("No signature found in " + file);
            }
            File detachedSignature = this.getDetachedSignature(file);
            if ("PEM".equalsIgnoreCase(this.format)) {
                detachedSignature = new File(detachedSignature.getParentFile(), detachedSignature.getName() + ".pem");
            }
            this.log.info("Extracting signature to " + detachedSignature);
            this.detach(signable, detachedSignature);
        }
        catch (IllegalArgumentException | UnsupportedOperationException e) {
            throw new SignerException(e.getMessage());
        }
        catch (SignerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SignerException("Couldn't extract the signature from " + file, e);
        }
    }

    private void remove(File file) throws SignerException {
        if (!file.exists()) {
            throw new SignerException("Couldn't find " + file);
        }
        try (Signable signable = Signable.of(file);){
            List<CMSSignedData> signatures = signable.getSignatures();
            if (signatures.isEmpty()) {
                this.log.severe("No signature found in " + file);
                return;
            }
            this.log.info("Removing signature from " + file);
            signable.setSignature(null);
            signable.save();
        }
        catch (IllegalArgumentException | UnsupportedOperationException e) {
            throw new SignerException(e.getMessage());
        }
        catch (Exception e) {
            throw new SignerException("Couldn't remove the signature from " + file, e);
        }
    }

    private void tag(File file) throws SignerException {
        if (!file.exists()) {
            throw new SignerException("Couldn't find " + file);
        }
        try (Signable signable = Signable.of(file);){
            List<CMSSignedData> signatures = signable.getSignatures();
            if (signatures.isEmpty()) {
                throw new SignerException("No signature found in " + file);
            }
            this.log.info("Adding tag to " + file);
            CMSSignedData signature = signatures.get(0);
            signature = this.addUnsignedAttribute(signature, AuthenticodeObjectIdentifiers.JSIGN_UNSIGNED_DATA_OBJID, this.getTagValue());
            signable.setSignature(signature);
        }
        catch (SignerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SignerException("Couldn't modify the signature of " + file, e);
        }
    }

    private CMSSignedData addUnsignedAttribute(CMSSignedData signature, ASN1ObjectIdentifier oid, ASN1Encodable value) {
        SignerInformationStore store = signature.getSignerInfos();
        Collection signers = store.getSigners();
        SignerInformation signer = (SignerInformation)signers.iterator().next();
        AttributeTable attributes = signer.getUnsignedAttributes();
        if (attributes == null) {
            attributes = new AttributeTable((ASN1Set)new DERSet());
        }
        attributes = attributes.add(oid, value);
        signers.remove(signer);
        signers.add(SignerInformation.replaceUnsignedAttributes((SignerInformation)signer, (AttributeTable)attributes));
        return CMSSignedData.replaceSigners((CMSSignedData)signature, (SignerInformationStore)new SignerInformationStore(signers));
    }

    private ASN1Encodable getTagValue() throws IOException {
        if (this.value == null) {
            byte[] array = new byte[1024];
            String begin = "-----BEGIN TAG-----";
            System.arraycopy(begin.getBytes(), 0, array, 0, begin.length());
            String end = "-----END TAG-----";
            System.arraycopy(end.getBytes(), 0, array, array.length - end.length(), end.length());
            return new DEROctetString(array);
        }
        if (this.value.startsWith("0x")) {
            byte[] array = Hex.decode((String)this.value.substring(2));
            return new DEROctetString(array);
        }
        if (this.value.startsWith("file:")) {
            byte[] array = Files.readAllBytes(new File(this.value.substring("file:".length())).toPath());
            return new DEROctetString(array);
        }
        return new DERUTF8String(this.value);
    }

    private void timestamp(File file) throws SignerException {
        if (!file.exists()) {
            throw new SignerException("Couldn't find " + file);
        }
        try {
            this.initializeProxy(this.proxyUrl, this.proxyUser, this.proxyPass);
        }
        catch (Exception e) {
            throw new SignerException("Couldn't initialize proxy", e);
        }
        try (Signable signable = Signable.of(file);){
            if (signable.getSignatures().isEmpty()) {
                throw new SignerException("No signature found in " + file);
            }
            Timestamper timestamper = Timestamper.create(this.tsmode != null ? TimestampingMode.of(this.tsmode) : TimestampingMode.AUTHENTICODE);
            timestamper.setRetries(this.tsretries);
            timestamper.setRetryWait(this.tsretrywait);
            if (this.tsaurl != null) {
                timestamper.setURLs(this.tsaurl.split(","));
            }
            DigestAlgorithm digestAlgorithm = this.alg != null ? DigestAlgorithm.of((String)this.alg) : DigestAlgorithm.getDefault();
            ArrayList<CMSSignedData> signatures = new ArrayList<CMSSignedData>();
            for (CMSSignedData signature : signable.getSignatures()) {
                SignerInformation signerInformation = (SignerInformation)signature.getSignerInfos().iterator().next();
                SignerId signerId = signerInformation.getSID();
                X509CertificateHolder certificate = (X509CertificateHolder)signature.getCertificates().getMatches((Selector)signerId).iterator().next();
                String digestAlgorithmName = new DefaultAlgorithmNameFinder().getAlgorithmName(signerInformation.getDigestAlgorithmID());
                String keyAlgorithmName = new DefaultAlgorithmNameFinder().getAlgorithmName(new ASN1ObjectIdentifier(signerInformation.getEncryptionAlgOID()));
                String name = digestAlgorithmName + "/" + keyAlgorithmName + " signature from '" + certificate.getSubject() + "'";
                if (SignatureUtils.isTimestamped(signature) && !this.replace) {
                    this.log.fine(name + " already timestamped");
                    signatures.add(signature);
                    continue;
                }
                boolean expired = certificate.getNotAfter().before(new Date());
                if (expired) {
                    this.log.fine(name + " is expired, skipping");
                    signatures.add(signature);
                    continue;
                }
                this.log.info("Adding timestamp to " + name);
                signature = SignatureUtils.removeTimestamp(signature);
                signature = timestamper.timestamp(digestAlgorithm, signature);
                signatures.add(signature);
            }
            CMSSignedData signature = (CMSSignedData)signatures.get(0);
            if (signatures.size() > 1) {
                List nestedSignatures = signatures.subList(1, signatures.size());
                signature = SignatureUtils.addNestedSignature(signature, true, nestedSignatures.toArray(new CMSSignedData[0]));
            }
            signable.setSignature(signature);
        }
        catch (IOException | CMSException e) {
            throw new SignerException("Couldn't timestamp " + file, e);
        }
    }

    private void initializeProxy(String proxyUrl, final String proxyUser, final String proxyPassword) throws MalformedURLException {
        if (proxyUrl != null && !proxyUrl.trim().isEmpty()) {
            URL url;
            if (!proxyUrl.trim().startsWith("http")) {
                proxyUrl = "http://" + proxyUrl.trim();
            }
            final int port = (url = new URL(proxyUrl)).getPort() < 0 ? 80 : url.getPort();
            ProxySelector.setDefault(new ProxySelector(){

                @Override
                public List<Proxy> select(URI uri) {
                    Proxy proxy = uri.getScheme().equals("socket") ? new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(url.getHost(), port)) : new Proxy(Proxy.Type.HTTP, new InetSocketAddress(url.getHost(), port));
                    SignerHelper.this.log.fine("Proxy selected for " + uri + " : " + proxy);
                    return Collections.singletonList(proxy);
                }

                @Override
                public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
                }
            });
            if (proxyUser != null && !proxyUser.isEmpty() && proxyPassword != null) {
                Authenticator.setDefault(new Authenticator(){

                    @Override
                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(proxyUser, proxyPassword.toCharArray());
                    }
                });
            }
        }
    }
}

