/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.navx;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ReadableByteChannel;

class NAVXHeader {
    public static final int SIGNATURE = 1482047822;
    public static final int SIZE = 40;
    public int contentSize;

    NAVXHeader() {
    }

    public void read(ReadableByteChannel channel) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(40).order(ByteOrder.LITTLE_ENDIAN);
        channel.read(buffer);
        buffer.flip();
        int signature = buffer.getInt();
        if (signature != 1482047822) {
            throw new IOException("Invalid NAVX header signature");
        }
        this.contentSize = buffer.getInt(28);
        signature = buffer.getInt(36);
        if (signature != 1482047822) {
            throw new IOException("Invalid NAVX header signature");
        }
    }
}

