/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.nuget;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.SeekableByteChannel;
import java.security.MessageDigest;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import net.jsign.ChannelUtils;
import net.jsign.DigestAlgorithm;
import net.jsign.Signable;
import net.jsign.SignatureUtils;
import net.jsign.zip.CentralDirectory;
import net.jsign.zip.ZipFile;
import org.apache.poi.util.IOUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.esf.CommitmentTypeIndication;
import org.bouncycastle.asn1.ess.ESSCertIDv2;
import org.bouncycastle.asn1.ess.SigningCertificateV2;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.IssuerSerial;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSTypedData;

public class NugetFile
extends ZipFile
implements Signable {
    private static final String SIGNATURE_ENTRY = ".signature.p7s";

    public NugetFile(File file) throws IOException {
        super(file);
        this.verifyPackage();
    }

    public NugetFile(SeekableByteChannel channel) throws IOException {
        super(channel);
        this.verifyPackage();
    }

    private void verifyPackage() throws IOException {
        if (this.centralDirectory.entries.get("[Content_Types].xml") == null) {
            throw new IOException("Invalid NuGet package, [Content_Types].xml is missing");
        }
    }

    @Override
    public byte[] computeDigest(DigestAlgorithm digestAlgorithm) throws IOException {
        MessageDigest digest = digestAlgorithm.getMessageDigest();
        long endOfContentOffset = this.centralDirectory.centralDirectoryOffset;
        if (this.centralDirectory.entries.containsKey(SIGNATURE_ENTRY)) {
            endOfContentOffset = this.centralDirectory.entries.get(SIGNATURE_ENTRY).getLocalHeaderOffset();
        }
        ChannelUtils.updateDigest(this.channel, digest, 0L, endOfContentOffset);
        digest.update(this.getUnsignedCentralDirectory());
        return String.format("Version:1\n\n%s-Hash:%s\n\n", digestAlgorithm.oid, Base64.getEncoder().encodeToString(digest.digest())).getBytes();
    }

    private byte[] getUnsignedCentralDirectory() throws IOException {
        CentralDirectory centralDirectory = new CentralDirectory();
        centralDirectory.read(this.channel);
        centralDirectory.removeEntry(SIGNATURE_ENTRY);
        return centralDirectory.toBytes();
    }

    @Override
    public CMSTypedData createSignedContent(DigestAlgorithm digestAlgorithm) throws IOException {
        return new CMSProcessableByteArray(PKCSObjectIdentifiers.data, this.computeDigest(digestAlgorithm));
    }

    @Override
    public ASN1Object createIndirectData(DigestAlgorithm digestAlgorithm) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Attribute> createSignedAttributes(X509Certificate certificate) throws CertificateEncodingException {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        CommitmentTypeIndication commitmentTypeIndication = new CommitmentTypeIndication(PKCSObjectIdentifiers.id_cti_ets_proofOfOrigin);
        attributes.add(new Attribute(PKCSObjectIdentifiers.id_aa_ets_commitmentType, (ASN1Set)new DERSet((ASN1Encodable)commitmentTypeIndication)));
        byte[] certHash = DigestAlgorithm.SHA256.getMessageDigest().digest(certificate.getEncoded());
        IssuerSerial issuerSerial = new IssuerSerial(X500Name.getInstance((Object)certificate.getIssuerX500Principal().getEncoded()), certificate.getSerialNumber());
        SigningCertificateV2 signingCertificateV2 = new SigningCertificateV2(new ESSCertIDv2(certHash, issuerSerial));
        attributes.add(new Attribute(PKCSObjectIdentifiers.id_aa_signingCertificateV2, (ASN1Set)new DERSet((ASN1Encodable)signingCertificateV2)));
        return attributes;
    }

    @Override
    public List<CMSSignedData> getSignatures() throws IOException {
        if (this.centralDirectory.entries.containsKey(SIGNATURE_ENTRY)) {
            InputStream in = this.getInputStream(SIGNATURE_ENTRY, 0x100000);
            return SignatureUtils.getSignatures(IOUtils.toByteArray((InputStream)in));
        }
        return Collections.emptyList();
    }

    @Override
    public void setSignature(CMSSignedData signature) throws IOException {
        if (this.centralDirectory.entries.containsKey(SIGNATURE_ENTRY)) {
            this.removeEntry(SIGNATURE_ENTRY);
        }
        if (signature != null) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            signature.toASN1Structure().encodeTo((OutputStream)out, "DER");
            this.addEntry(SIGNATURE_ENTRY, out.toByteArray(), false);
        }
    }

    @Override
    public void save() throws IOException {
    }
}

